<%--
/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * 
 *  Use is subject to license terms.
 * 
 *  "@(#)admin_expansion_wiz_verify.jsp     1.6     03/09/25     SMI"
 */
--%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<%
  T4Interface array =
   (T4Interface)
     session.getAttribute(Constants.HttpSessionFields.CURRENT_T4);
 // lets us know if this is for the add expansion tray wizard
 //  or the remove expansion tray wizard
 String isAdd = 
  (String)session.getAttribute(
    Constants.HttpSessionFields.IS_ADD_EXPANSION);
%>
<!-- Place Java Script Here -->
<script language="JavaScript">
  function resubmitForm() {
    <% String _page = "4"; 
       if(array.isFeatureSupported(Constants.SupportedFeature.FEATURE_BOOT_R) ||
       "true".equals(isAdd)) { 
          _page = "3";
       }
    %>
    parent.setPage(<%=_page%>, "Page");
  }

</script>

<!-- HTML -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
</head>
<% 
   // tells us if the verification process is done
   String isDone = 
    (String)session.getAttribute(Constants.HttpSessionFields.VERIFICATION_STATUS);

    // flag to indicate if the current array is healthy
    boolean isArrayHealthy = false;
    try {
        if(array.getHealthStatus() == Constants.T4.HEALTH_OK_CODE) {
            isArrayHealthy = true;
        }
    } catch(Exception e) {}
%>

<%@ include file="/layout/wizard_body_tag.jsp" %>
<%@ include file="/layout/user_messages.jsp"%>
<% 
    // always disable the back and next buttons
    session.setAttribute("disableNext", "true");

    // this page is used by both the add and remove expansion
    //  wizards
    // this code will determine which action to use
    // set it to remove by default
    String formAction = "/RemoveExpansionWizard.do";
    // if the boot_r feature is supported, use the
    //   remove wizard with no rarp page
    if(array != null &&
       array.isFeatureSupported(Constants.SupportedFeature.FEATURE_BOOT_R)) {
       formAction = "/RemoveExpansionWizardNoRarp.do";
    }

    // set the retry button to resubmit
    //  the form for remove expansion tray by default
    String retryButtonLink = "javascript:resubmitForm()"; 

    if("true".equals(isAdd)) {
      formAction = "/AddExpansionWizard.do";
      // if this is the add expansion tray wizard,
      //  this is page 3
      retryButtonLink = "javascript:resubmitForm()";
      // for the add expansion wizard, the last button
      //  is a finish wizard button
      session.setAttribute(Constants.HttpSessionFields.NEED_FINISH_BUTTON, "true");
    } else {
       // otherwise, for the remove expansion wizard, the last button
       //  is a close wizard button
       session.setAttribute(Constants.HttpSessionFields.NEED_CLOSE_BUTTON, "true");
    }
%>

<html:form name="wizardframework" type="com.sun.netstorage.array.mgmt.cfg.ui.forms.WizardFrameworkForm" action="<%=formAction%>">

<%@ include file="/wizard/wizard_framework_fields.jsp"%>

<%

   if(!"true".equals(isDone)) {
%>
        <script language="JavaScript">
           window.setTimeout(resubmitForm, 300);
        </script>
<% } else { 
        // if the thread is done, reset it 
        //  so if the user tries to retry the verification
        //  process, it will start over
        session.setAttribute(
          Constants.HttpSessionFields.VERIFICATION_STATUS, "false");
   }
%>


<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">

    <td>
      <div class="wizard-content-title-text">
        <bean:message key="expansion.verify.header"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/images/general/dot.gif" border="0"></td>
  </tr>

</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">   
  <tr>
   <td>
      <% if(!"true".equals(isDone)) { %>
        <bean:message key="expansion.verify.notready.instructions"/>
      <% } else if(isArrayHealthy){ // only show this if the array is healthy %>
        <%  // only show the StorADE link if M3
            if(Repository.getRepository().getConfigInteger() == 
                MaseratiConfig.MIDRANGE3_INT) {
        %>
             <bean:message key="expansion.verify.ready.instructions.m3"/>
             <a href="<%=session.getAttribute(Constants.HttpSessionFields.SADE)%>" target="_blank">
              <bean:message key="main.menu.health.info.link"/>
             </a>
      <%   } else { %> 
              <bean:message key="expansion.verify.ready.instructions.m12"/>
              <bean:message key="main.menu.health.info.link"/>
      <%   }
         } 
      %>
   </td>
  </tr>
</table>

<% 
  // if the thread is done, and the array
  //  is still not ready, show 'try again' button
  if("true".equals(isDone)) { 

     if(!isArrayHealthy) {
%>
<!-- try again button --> 
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <td><bean:message key="expansion.verify.tryagain.instructions"/></td>
  </tr>
  <tr>
    <td><img alt width="1" height="8" border="0" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <td>
      <component:button text="expansion.verify.tryagain.button" href="<%=retryButtonLink%>" title="expansion.verify.tryagain.button" isEnabled="<%=true%>" />
    </td>
  </tr>
  <tr>
    <td><img alt width="1" height="8" border="0" src="images/general/dot.gif"></td>
  </tr>
</table>
<%   } 
  } %>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <td>
      <div class="major-category-text">
        <bean:message key="expansion.trays"/>
      </div>
    </td>
  </tr>
  <tr>
    <td><img alt width="1" height="8" border="0" src="images/general/dot.gif"></td>
  </tr>
</table>


<table class="back-table" border="0" cellspacing="0" cellpadding="1" >
  <tr>
    <td>
      <table class="front-table" border="0" cellspacing="0" cellpadding="0">

        <tr class="header-row">
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.id"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.type"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.state"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.status"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.role"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.numdrives"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.tray.table.driveshealthy"/>
            </div>
          </td>
        </tr>
        <% if(!"true".equals(isDone)) { %>
        <tr>
           <td colspan="7">
            <div class="table-normal-text">
              <bean:message key="expansion.verify.arraynotready.retrying"/>
            </div>
          </td>
        </tr>
        <% } else { %>
        <logic:present name="Expansion" property="trays">
         <logic:iterate id="tray" name="Expansion" property="trays" type="TrayInterface" indexId="idx">
          <tr>
           <td>
            <div class="table-normal-text">
              <bean:write name="tray" property="id"/> 
            </div>
          </td>
           <td>
            <div class="table-normal-text">
             <%
                String typeStr = "tray.type." + tray.getTrayType();                                
             %>
              <bean:message key="<%=typeStr%>"/> 
            </div>
          </td>
           <td>
            <div class="table-normal-text">
             <%
                String stateStr = "tray.state." + tray.getState();                                
             %>
              <bean:message key="<%=stateStr%>"/> 
            </div>
          </td>
           <td>
            <div class="table-normal-text">
             <%
                String statusStr = "tray.status." + tray.getStatus();                                
             %>
              <bean:message key="<%=statusStr%>"/> 
            </div>
          </td>
           <td>
            <div class="table-normal-text">
             <%
                String roleStr = "tray.role." + tray.getRole();                                
             %>
              <bean:message key="<%=roleStr%>"/> 
            </div>
          </td>
           <td align="right">
            <div class="table-normal-text">
              <bean:write name="tray" property="numberOfDrives"/>
            </div>
          </td>
           <td>
            <div class="table-normal-text">
              <%
                 try {
                  if(tray.areAllDisksHealthy()) {
              %>
                   <bean:message key="yes"/> 
              <%  } else { %>
                   <bean:message key="no"/> 
              <%  }
                 } catch(Exception e) { %>
                     --
              <%
                 }
              %>
            </div>
          </td>
        </tr>
         </logic:iterate>
        </logic:present>
        <% } %>
      </table>
    </td>
  </tr>
</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">

  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<%  if("true".equals(isAdd) && isArrayHealthy && "true".equals(isDone)) { %>
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>

        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="add.expansion.existing.pools" />
              </div>
            </td>           
          </tr>
        </table>
      </td>
    </tr>
      <tr>
      <td nowrap>
        <table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><img alt width="1" height="8" border="0" src="images/general/dot.gif"></td>
          </tr>

          <tr>
            <td nowrap>
              <table class="back-table" border="0" cellspacing="0" cellpadding="1">
                <tr>
                  <td>
                    <table class="front-table" border="0" cellspacing="0" cellpadding="0">
                      <tr class="header-row">
                        <td nowrap></td>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="add.expansion.final.step"/>
                          </div>
                        </td>
                      </tr>
                      <tr>
                         <td>
                           <html:checkbox name="Expansion" property="shouldOnline"/>
                         </td>
                         <td>
                           <bean:message key="add.expansion.online.exisiting"/>
                         </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>

  </tr>
</table>

<% } %>
</div>

</html:form>
</body>

</html:html>
