<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)admin_individual_array_confirm.jsp    1.5    03/09/25     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html locale="true">
<!-- end locale -->

<%
	boolean doResetLabels = false;
	boolean enableAction = true;
	boolean showRarpEntries = false;
	
    // figure out which array power management action this is
    String confirmLabel = "admin.general.individualarray.shutdown";
    String confirmAction = "javascript:submitForm('arrayshutdown')";
    String actionPath = "root.menu.item3.item0.arrayshutdown";
    if (((String) request.getAttribute("action")).indexOf("label") != -1) {
        confirmLabel = "admin.general.individualarray.resetlabels";
        confirmAction = "javascript:submitForm('arrayresetlabels')";
        actionPath = "root.menu.item3.item0.arrayresetlabels";
    	doResetLabels = true;
        showRarpEntries = 
            ((Boolean) request.getAttribute("showRarpEntries")).booleanValue();
    	// If any of the arrays doesn't have RARP set, disable the reset labels button.    	
   		List rarpEntries = (List) session.getAttribute("RarpEntryList");
   		if (rarpEntries != null && rarpEntries.size() > 0) { 
   			for(int i = 0; i < rarpEntries.size(); i++) {
   				if (((RARPEntry) rarpEntries.get(i)).getMacAddress() == null) {   					
   					enableAction = false;
   					break;
   				}	
   			}
    	} else {
            // No RARP entries and...         
            if (showRarpEntries) {
                // ...some arrays have 3.0 firmware - something is wrong.
                enableAction = false;
            }
    	}
    } else if (((String) request.getAttribute("action")).indexOf("reset") != -1) {
        confirmLabel = "admin.general.individualarray.reset";
        confirmAction = "javascript:submitForm('arrayreset')";
        actionPath = "root.menu.item3.item0.arrayreset";
    }
    String formAction = "/" + actionPath + ".do";
%>

<!--  -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
	<title>
		<bean:message  key="admin.general.individualarray.confirm.title"/>
	</title>
</head>
<%@ include file="/layout/bodytag.jsp"%>
<html:form action="<%=formAction%>">
<%@include file="/layout/top.jsp"%>
<%@include file="/layout/breadcrumb.jsp"%>
<%@include file="/layout/spacer.jsp"%>

<%@include file="/layout/spacer.jsp"%>
<%@include file="/layout/user_messages.jsp"%>
<%@include file="/layout/spacer.jsp"%>

<!-- override the selected sub item for the paging mechanism-->
<% selectedSubItem = actionPath; %>

<!-- hidden element which specifies the action for this form -->
<input type="hidden" name="action" value="<%=request.getAttribute("action")%>">
<div class="content-layout">
<!-- Button row -->
<table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
      	<table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td>
              <img width="250" height="1" border="0" src="images/general/dot.gif">
            </td>
            <td align="left">
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td>
                    <component:button text="<%=confirmLabel%>" 
                                    href="<%=confirmAction%>" 
                                    title="<%=confirmLabel%>"
                                    isEnabled="<%=enableAction%>" />
				  </td>
				  <td>
				  	<img width="10" height="1" border="0" src="images/general/dot.gif">
				  </td>
				  <td>
				    <component:button text="button.cancel" 
                                    href="javascript:submitForm('cancelconfirm')" 
                                    title="button.cancel"
                                    isEnabled="true" />
				  </td>
				</tr>
		      </table>
		    </td>
		  </tr>
		</table>  
      </td>
    </tr>
</table>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="admin.general.individualarray.selections"/>
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="10" src="/images/general/dot.gif" width="1"></td>
    </tr>
</table> 

<!-- list selected arrays for the action to confirm -->
<table class="back-table" border="0" cellspacing="0" cellpadding="1">
  <tr>
    <td>
      <table class="front-table" border="0" cellspacing="0" cellpadding="0">        
        <tr class="header-row">
          <td align="left" nowrap>
            <div class="table-header-text">
 		        <bean:message key="main.menu.t4.summary.name" />
            </div>
          </td>           
          <td align="left" nowrap>
            <div class="table-header-text">
                <bean:message key="main.menu.t4.summary.description" />
            </div>
          </td>   
          <td align="left" nowrap>
            <div class="table-header-text">
                <bean:message key="admin.general.individualarray.rarp.ipaddress" />
            </div>
          </td>          
        </tr>     
        <logic:iterate id="t4" name="SelectedIndividualArrays" type="T4Interface">  
           <tr>
              <td align="left" nowrap>
                 <div class="table-normal-text">
                    <bean:write name="t4" property="name"/>
                 </div>
              </td> 
              <td align="left" nowrap>
                 <div class="table-normal-text">
                    <logic:present name="t4" property="description">
                        <bean:write name="t4" property="description"/>
                    </logic:present>
                    <logic:notPresent name="t4" property="description">
                        &nbsp;
                    </logic:notPresent>
                 </div>
              </td>
              <td align="left" nowrap>
                 <div class="table-normal-text">
                    <bean:write name="t4" property="clusterName"/>
                 </div>
              </td> 
           </tr>
        </logic:iterate>
      </table>
    </td>
  </tr>
</table>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<%@include file="admin_show_active_jobs_include.jsp"%>
	
<% if (doResetLabels && showRarpEntries) { %>
	<%@include file="admin_show_rarp_entries_include.jsp"%>	
<% } %>

</html:form>
</body>

</html>
