<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_configstoragewiz_selecttrays.jsp     1.4     03/08/07     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<html:html>

<head>
<%@include file="/layout/page_head_section.jsp"%>
</head>

<%@ include file="/layout/wizard_body_tag.jsp" %>
<html:form action="/ConfigStorageByProfileWizard.do">
<% try { 
    T4Interface currentT4 =
      (T4Interface)session.getAttribute(Constants.HttpSessionFields.CURRENT_T4);
%>
<%@ include file="/wizard/wizard_framework_fields.jsp"%>

<div class="content-layout">

<%@ include file="/layout/user_messages.jsp"%>

<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">
    <td>
      <div class="wizard-content-title-text"> <bean:message key="configure.storage.wizard.section.header" arg0="<%=((T4Interface)session.getAttribute(Constants.HttpSessionFields.CURRENT_T4)).getName()%>"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/image
s/general/dot.gif" border="0"></td>
  </tr>
</table>


 <!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
<%
      PoolCreateForm form = 
        (PoolCreateForm)session.getAttribute(
          Constants.HttpSessionFields.CREATE_POOL_FORM_NAME);

      // flag to indicate if the selected profile has a
      //  variable number of drives
      boolean isVariable = false;
      if(Constants.ProfileProperties.NUMBER_OF_DRIVES_VARIABLE.equals(
          form.getSelectedProfileObject().getNumberOfDrives())) {
         isVariable = true;
      }

%>

<!-- if there are no trays available, show info message -->
<logic:notPresent name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="traysForProfile">
<table width="80%">
  <tr><td width="100%">
    <table border="0" cellspacing="0" cellpadding="2" align="left" bgcolor="#9999CC" width="100%">
      <tr><td>
        <table cellspacing="0" cellpadding="5" border="0"  bgcolor="#FFFFFF" width="100%">
          <tr>
            <td valign="top"><img src="images/icons/info_16.gif" width="16" height="16" alt='<bean:message key="icon.warning"/>' border="0"></td>
            <td><div class="error-message-header-text">
                  <bean:message key="configure.storage.wizard.notrays"/> 
                </div>
          </tr>
        </table>
      </td></tr>
    </table>
  </td></tr>
  <tr><td>
    <img src="images/general/dot.gif" width="1" height="10" border="0">
  </td></tr>
</table>
</logic:notPresent>

<!-- otherwise, show the tray listing -->
<logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="traysForProfile"> 

  <!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td>
      <% if(currentT4.isFeatureSupported(
               Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE)) { 
      %>
          <bean:message key="configure.storage.tray.instructions"/> 
      <% } else { %>
          <bean:message key="configure.storage.tray.instructions.noahs"/> 
      <% } %>
    </td>
  </tr>
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<!-- BEGIN SECTION:  variable length table populated with items contained in major
                     object displayed on this page -->
<!-- OPTIONAL section, dependig on purpose of page -->
<!-- NOTE:  the buttons above the table are optional.  They exist on pages where
            they are required.  If the buttons are not there, then the first column
            with the checkboxes also has to be removed -->
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>

            <td nowrap>
              <div>
                <bean:message key="configure.storage.selected.profile"/>
                <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName"/>
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>

    </tr>
  </table>
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>

    </tr>
  </table>
  
  <!-- whole tray listing table-->
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
        <table border="0" cellspacing="0" cellpadding="0">          
          <tr>
            <td><img alt width="1" height="2" border="0" src="images/general/dot.gif"></td>
          </tr>           
          <tr>
            <td nowrap>
              <table class="back-table" border="0" cellspacing="0" cellpadding="1">
                <tr>
                  <td>
                    <table class="front-table" border="0" cellspacing="0" cellpadding="0">
                      <tr class="header-row">
                        <td>&nbsp; </td>
                        <td nowrap>
                          <div class="table-header-text">
                            <bean:message key="tray.table.id"/>
                          </div>
                        </td>      
                        <td nowrap>
                          <div class="table-header-text">
                            <bean:message key="tray.table.drivenum.short"/> 
                          </div>
                        </td>       
                        <td nowrap>
                          <div class="table-header-text">
                            <% if(currentT4.isFeatureSupported(
                                Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE)) { 
                            %>
                                 <bean:message key="tray.table.ahs"/> 
                            <% } else { %>
                                 <bean:message key="tray.table.hotspare"/> 
                            <% } %>
                          </div>
                        </td>           
                        <td nowrap>
                          <div class="table-header-text">
                           <%
                             // if it's variable, display the 'Assign Drives' column
                             //  otherwise show the 'Drives per Pool' column
                             if(isVariable) {
                           %>
                               <bean:message key="tray.table.assigndrives"/> 
                          <% } else { %>
                               <bean:message key="tray.table.drivesperpool"/> 
                          <% } %>
                          </div>
                        </td>                        
                        <td nowrap>
                          <div class="table-header-text">
                            <bean:message key="tray.table.numberofpools"/> 
                          </div>
                        </td>
                      </tr>
                      <!-- Begin tray row listing(s) -->              
                                                              
 				     <logic:iterate id="trayForProfile" name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="traysForProfile" type="TrayForProfile" indexId="idx"> 				 	      
                     <tr>           
                       <td>
                          <input checked type="checkbox" name="checkboxid" value="<%=idx%>">
                       </td>                  
                       <td align="right">     
                         <div class="table-label-text">                    
                           <bean:write name="trayForProfile" property="tray.id"/>
                         </div>
                        </td>     
                        <td align="right">  
                          <div class="table-label-text">                        
                            <bean:write name="trayForProfile" property="tray.numberOfDrives"/>
                          </div>
                        </td>                    
                        <td align="right">        
                          <div class="table-label-text">                  
                            <% 
                               // check and see if we already have pre-selected values
                               boolean hasPrevSelections = false;
                               List breakdowns = form.getPoolBreakdowns();
                               PoolBreakdownForTray breakdown = null;
                               int totalBreakdownDisks = 0;
                               int hotspareValue = 0;

                               try {
                                 // if we have breakdown objects then we know
                                 //  we have previous selections
                                 if(breakdowns != null &&
                                    !breakdowns.isEmpty()) {
                                  hasPrevSelections = true;
                                  // go through each one to get the number of disks, and hotspare value
                                  //  previously selected
                                  for (Iterator it = breakdowns.iterator(); it.hasNext();) {
                                   PoolBreakdownForTray pb = (PoolBreakdownForTray) it.next();
                                   if(trayForProfile.getTray().getId().equals(pb.getTrayId())) {
                                     breakdown = pb;
                                     if(!currentT4.isFeatureSupported(
                                       Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE)) { 
                                         hotspareValue = pb.getUseSpare() ? 1 : 0;
                                     }
                                     for(int i = 0; i < pb.getNumPools(); i++) {
                                        totalBreakdownDisks += pb.getNumDisks(i);
                                     }
                                     break;
                                   }
                                 }// end for
                               }
                             } catch(Exception e) {}

                               if(currentT4.isFeatureSupported(
                                Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE)) { 
                            %>
                                <%=trayForProfile.getTray().getNumberOfDisksInRole(Constants.Disks.ROLE_ARRAY_SPARE)%>
                            <% } else { %>
                                <select name="hotspare">
                                       <option <%=(hasPrevSelections && hotspareValue == Constants.Tray.HOTSPARE_0) ? "selected" : ""%>><%=Constants.Tray.HOTSPARE_0%>
                                       <option <%=(hasPrevSelections && hotspareValue == Constants.Tray.HOTSPARE_1) ? "selected" : ""%>><%=Constants.Tray.HOTSPARE_1%>
                                </select>
                            <% } %>
                          </div>
                        </td>      
                        <td align="right">                         
                          <div class="table-label-text"> 
                            <% if(isVariable) { %>
                               <select name="numdisks">    
                                 <%

                                   List possibleDisks = trayForProfile.getPossibleDisksToAssign();
                                   int maxDisk = 
                                     ((Integer)possibleDisks.get(possibleDisks.size() - 1)).intValue();
                                   for(int j = 0; j < possibleDisks.size(); j++) {
                                     int disk = ((Integer)possibleDisks.get(j)).intValue();
                                     // if we have previous selections
                                     if(hasPrevSelections) {
                                       if(breakdown != null &&
                                          disk == totalBreakdownDisks) {
                                          // we have to preselect the values that
                                          //  were already selected
                                 %>
                                          <option selected><%=disk%>
                                 <%
                                          continue;
                                       } else if(breakdown == null) {
                                           if(disk == maxDisk) {
                                 %>
                                              <option selected><%=disk%>
                                <%
                                              continue;
                                           }
                                       }
                                     } else if(disk == maxDisk) {
                                       // select the maximum by default
                                 %>
                                       <option selected><%=disk%>
                                <%   
                                       // continue here so the this disk number
                                       //  won't be added again with the next line
                                       continue;
                                     } // end else if maxDisk
                                %>
                                     <!-- add the rest of the options -->
                                     <option><%=disk%>
                                <%    
                                   }// end for
                                %>
                               </select> 
                            <% } else { %>
                                 <!-- if it's not variable, just show the number
                                       of drives for the profile -->
                                 <input type="hidden" name="numdisks" value="<%=form.getSelectedProfileObject().getNumberOfDrives()%>"/>

                                 <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="selectedProfileObject.numberOfDrives"/>
                            <% } %>
                          </div>
                        </td>
                        <td align="right">
                          <div class="table-label-text"> 
                            <% if(trayForProfile.getMaxPoolsAvailable() == 1) { %>
                                <bean:write name="trayForProfile" property="maxPoolsAvailable"/>
                                <input type="hidden" name="numpools" value="<%=trayForProfile.getMaxPoolsAvailable()%>">
                            <% } else { 
                            %>
                                <select name="numpools">
                                  <% 
                                    int poolNum = 0;
                                    for(int i = 1; i <= Constants.Tray.MAX_POOLS; i++) { 
                                      poolNum = i;

                                      if(hasPrevSelections) { 
                                         if(breakdown != null &&
                                            poolNum == breakdown.getNumPools()) {
                                  %>
                                          <option selected><%=poolNum%>
                                  <%
                                           continue;
                                         }
                                      }
                                  %>
                                      <option><%=poolNum%>
                                  <% } // end for %>
                                </select>

                            <% } %>
                          </div>
                        </td>
                         </tr>
                        </logic:iterate>
                    </table>
                  </td>
                </tr>             
              </table>
            </td>
          </tr>           
        </table>
      </td>
    </tr>
  </table> <!-- end whole tray table listing -->


</logic:present>   

</div>

<% } catch(Exception e) {
       Trace.error(this, 
         "sm_configstoragewiz_selecttrays.jsp", 
         "Page exception: " + e);
   }
%>
</html:form>
</body>

</html:html>
