<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_createpoolwiz_confirm.jsp    1.16    03/08/07     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<html:html>

<head>
<%@include file="/layout/page_head_section.jsp"%>
</head>

<%@ include file="/layout/wizard_body_tag.jsp" %>
<html:form action="/CreatePoolWizard.do">
<%@ include file="/wizard/wizard_framework_fields.jsp"%> 
<%@ include file="/layout/user_messages.jsp"%>

<% try {
     com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolCreateForm form =
       (com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolCreateForm)
         session.getAttribute(Constants.HttpSessionFields.CREATE_POOL_FORM_NAME);

 %>

<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">

    <td>
      <div class="wizard-content-title-text">
        <bean:message key="storage.mgmt.pool.createwiz.toc.4"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/images/general/dot.gif"
border="0"></td>
  </tr>

</table>

<!-- spacer between two sections -->
<%@ include file="/layout/spacer.jsp"%>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><bean:message key="pool.creation.wizard.confirm.instructions"/></td>

  </tr>
</table>

<!-- spacer between two sections -->
<%@ include file="/layout/spacer.jsp"%>

<table class="back-table" border="0" cellspacing="0" cellpadding="1">
  <tr>
    <td>
      <table class="front-table" border="0" cellspacing="0" cellpadding="0">
        <tr class="header-row">
          <td>
            <div class="table-header-text">
              <bean:message key="detail.property"/>
            </div>
          </td>   
          <td>
            <div class="table-header-text">
              <bean:message key="detail.value"/>
            </div>
          </td>                 
        </tr>
        <logic:iterate id="poolBreaks" name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="poolBreakdowns" type="PoolBreakdownForTray" indexId="idx"> 				 	      
         <% for(int i = 0; i < poolBreaks.getNumPools(); i++) { %>
         <tr>
         
          <td>           
            <div class="table-normal-text">
               <bean:message key="pools.table.name"/>
            </div>
          </td>
          <td> 
            <div class="table-normal-text">           
              <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newPoolName"/>           
            </div>
          </td>
        
         </tr>
         <tr>
        
          <td>    
            <div class="table-normal-text">        
              <bean:message key="tray.table.id"/>            
            </div>
          </td>
          <td> 
            <div class="table-normal-text">           
              <bean:write name="poolBreaks" property="trayId"/>
            </div>
          </td>
        
         </tr>
         <tr>
        
          <td>
            <div class="table-normal-text">
              <bean:message key="tray.table.drivenum.short"/>
            </div>
          </td>
          <td>
            <div class="table-normal-text">
              <%=poolBreaks.getNumDisks(i)%>
            </div>
          </td>
        
         </tr>

         <% if(!((T4Interface)session.getAttribute(
                Constants.HttpSessionFields.CURRENT_T4)).
                 isFeatureSupported(
                  Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE)) { 
         %>
         <tr>
        
          <td>
            <div class="table-normal-text">
              <bean:message key="tray.table.hotspare"/>
            </div>
          </td>
          <td>
            <div class="table-normal-text">
              <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="hotSpare"/>
            </div>
          </td>
        
         </tr>
         <% } %>
         <tr>
          <td>
            <div class="table-normal-text">
              <bean:message key="tray.table.drive.size"/>
            </div>
          </td>
          <td>
            <div class="table-normal-text">
              <component:volumeSizeDisplay size="<%=poolBreaks.getEffectiveDiskSize(i).toString()%>"/>
            </div>
          </td>
         </tr>
         <tr>
          <td>
            <div class="table-normal-text">
              <bean:message key="storage.mgmt.system.profile"/>
            </div>
          </td>
          <td>
            <div class="table-normal-text">
              <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName"/>           
            </div>
          </td>
         </tr>
         <tr>
          <td>
            <div class="table-normal-text">
              <bean:message key="pools.table.size"/>
            </div>
          </td>
          <td>
            <div class="table-normal-text">
              <component:volumeSizeDisplay size="<%=poolBreaks.getPoolCapacity(i).toString()%>"/>
            </div>
          </td>
        </tr>
       <% } %>
      </logic:iterate>
      </table>

    </td>
  </tr>
</table>


    </td>
  </tr>
</table>

<% } catch (Throwable t) {
    Trace.verbose(this, "create pool confirm exception", t);
}
%>


</html:form>
</body>

</html:html>

