<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_manage_volumes_include.jsp    1.12    03/08/28     SMI"
   * 
   */
 --%>

<%
   // flag to indicate if this is a volumes listing for a pool
   boolean isVolumeListForPool = false;

   // by default show the volumes list
   String listName = Constants.HttpSessionFields.VOLUME_LIST;

   // if we have a pool volume list; show that list
   if(request.getAttribute(Constants.HttpRequestFields.POOLS_VOLUME_LIST_NAME) != null) {
      listName = 
        (String)request.getAttribute(
           Constants.HttpRequestFields.POOLS_VOLUME_LIST_NAME);
      isVolumeListForPool = true;
   }
   boolean hasVolumeList = false;
   List volList = (List)session.getAttribute(listName);
   if(volList != null && !volList.isEmpty()) {
      hasVolumeList = true;
   } else {
       session.removeAttribute(listName);
   }

   boolean maxVols = false;
   if(hasVolumeList && volList.size() == ((T4Interface)session.getAttribute(Constants.HttpSessionFields.CURRENT_T4)).getMaxNumberOfVolumes()) {
   	maxVols = true;
   }
%>

<!-- if this is scoped by pool, show the header for volumes for pool -->
<% if(isVolumeListForPool) {  
     String name = 
       (String)request.getAttribute(Constants.HttpRequestFields.DETAILED_POOL_NAME);
%>
<!-- use a hidden value to let the VolumesAction know this is a volume list
  for a pool and not the full list -->
<input type="hidden" name="<%=Constants.HttpRequestFields.POOLS_VOLUME_LIST_NAME%>" value="<%=Constants.HttpSessionFields.POOL_VOLUME_LIST%>">
<table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
             <div class="major-category-text">
              <bean:message key="storage.mgmt.system.expert.pools.volumes.header" arg0='<%=name%>'/>
             </div>
            </td>
            <td valign="bottom" width="99%">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr>
                  <td class="property-separator" valign="bottom"><img alt border="0" height="2" src="/images/general/dot.gif" width="1"></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
  </table>
<% } %>


<!-- volume section instructions --> 
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <td>
      <% if(isVolumeListForPool) { %>
            <bean:message key="express.subreports.volumeforpool.instructions"/>
      <% } else { %>
            <bean:message key="express.subreports.volume.instructions"/>
      <% } %>
    </td>
  </tr>
</table>

<%@include file="/layout/spacer.jsp"%>

<!-- if this is scoped by array, show the header for volumes for array -->
<% if(!isVolumeListForPool) { 
       String name = "";
       T4Interface array = 
          (T4Interface)session.getAttribute(
           Constants.HttpSessionFields.CURRENT_T4);
       if(array != null){
         name = array.getName();
       }
%> 
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="storage.mgmt.volumes.header" arg0="<%=name%>"/>
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
  </table>
<% } %>
<!-- spacer between two sections -->
<%@include file="/layout/spacer.jsp"%>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>

    <td align="left" valign="middle">
      <table border="0" cellpadding="0" cellspacing="0">
         <tr>
            <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <% String hrefLink = "javascript:createVolumeWizard()";
                                 if(isVolumeListForPool) {
                                    com.sun.netstorage.array.mgmt.cfg.ui.
                                      forms.PoolForm pform = 
                                       (com.sun.netstorage.array.mgmt.cfg.ui.
                                         forms.PoolForm)
                                          session.getAttribute(
                                           Constants.HttpSessionFields.POOLFORM_NAME);

                                     if(pform != null) {
                                        String poolId = pform.getDetailedPool().getName();
                                        hrefLink = "javascript:createVolumeOnPool('" + poolId + "');";
                                     }
                                 }
                                 %>
                              <component:button text="button.create" href="<%=hrefLink%>" title="button.create" isEnabled="<%=!readOnly && !maxVols%>" /> 
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>   
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>              
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                                <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item4voldelconfirm.do';document.forms[0].submit();" title="button.delete" isEnabled="<%=!readOnly && hasVolumeList%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>   
           </tr>
       </table>
   </td>
 
    
   
    
 </tr>
 <tr>
   <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
 </tr>
</table>


  <table>
    <%@include file="/layout/prevnext.jsp"%>
    <tr>
      <td nowrap>
        <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
           <tr>
             <td>
              <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                  <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>                           
                  <td nowrap>
                    <div class="table-header-text">
                      <bean:message key="storage.mgmt.volumes.name" />
                    </div>
                  </td>
                  <td nowrap>
                    <div class="table-header-text">
                      <bean:message key="storage.mgmt.volumes.pool" />
                    </div>
                  </td>
                  <td nowrap>
                    <div class="table-header-text">
                      <bean:message key="storage.mgmt.volumes.profile" />
                    </div>
                  </td>
                  <td nowrap >
                    <div class="table-header-text">
                      <bean:message key="report.volume.lun.label" />
                    </div>
                  </td>
                  <td nowrap >
                    <div class="table-header-text">
                      <bean:message key="storage.mgmt.volumes.capacity" />
                    </div>
                  </td>
                  <td nowrap>
                    <div class="table-header-text">
                      <bean:message key="storage.mgmt.volumes.status" />
                    </div>
                  </td>
                </tr>
       <logic:notPresent name="<%=listName%>">
          <tr>
            <td colspan="7">
              <bean:message key="storage.mgmt.volumes.noneavailable"/>
            </td>
          </tr>
       </logic:notPresent>
       <logic:present name="<%=listName%>">
         <!-- Begin Volume row listing -->
         <%@include file="/layout/listingCalc.jsp"%>
		 <logic:iterate id="volume" indexId="index" name="<%=listName%>" type="StorageVolumeInterface"  offset='<%=offsetStr%>' length='<%=lengthStr%>'>
                <tr>
                  <td align="center">
                    <div class="table-normal-text">
                      <input type="checkbox" name="id" value="<%=index%>" <% if(readOnly) {%>disabled <% } %>>
                    </div>
                  </td>
                  <td align="left" nowrap>
                    <div class="table-normal-text">
		    <a href="root.menu.item0.item4edit.do?index=<%=index%>&listName=<%=listName%>">
			  <bean:write name="volume" property="name"/>
			  </a>
                    </div>
                  </td>
                  <td align="left" nowrap>
                    <div class="table-normal-text">
                      <% if(isVolumeListForPool) { %>
              	          <bean:write name="volume" property="raidGroupName"/>
                      <% } else {%>
                          <html:link href="root.menu.item0.item2pooldetails.do"
              	             paramId="name" paramName="volume" paramProperty="raidGroupName">
                              <bean:write name="volume" property="raidGroupName"/></html:link>
                      <% } %>
                    </div>
                  </td>
                  <td align="left" nowrap>
                    <div class="table-normal-text">
                      <html:link href="root.menu.item0.item3profiledetails.do"
           	             paramId="profileName" paramName="volume" paramProperty="profileName">
                         <bean:write name="volume" property="profileName"/>
                      </html:link>
                    </div>
                  </td>
                  <td align="right" nowrap>
                    <div class="table-normal-text">
                      <% int lunNo = volume.getLUN();
                          if(lunNo == -1) {
                      %>
                           <bean:message key="storage.mgmt.volumes.no.lun.value"/>
                      <% }else { %>
                           <%=lunNo%>
                      <% } %>
                    </div>
                  </td>
                  <td align="right" nowrap>
                    <div class="table-normal-text">
                       <component:volumeSizeDisplay size="<%=volume.getSize().toString()%>"/>
                    </div>
                  </td>
                  <td align="left" nowrap>
                    <div class="table-normal-text">
                      <bean:message key='<%="storage.mgmt.volumes.status." + volume.getStatus()%>' />
                    </div>
                  </td>
                </tr>
            </logic:iterate>
          </logic:present>  
          </table>
        </td>
       </tr>
     </table>
   </td>
  </tr>
  <tr>
    <td colspan="5"><img alt border="0" height="1" width="300" src="images/general/dot.gif"></td>
  </tr>
  <%@include file="/layout/prevnext.jsp"%>
</table>
