/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.inet;

import com.sun.netstorage.mgmt.inet.Constants;
import com.sun.netstorage.mgmt.inet.InetDaemon;
import com.sun.netstorage.mgmt.inet.InetDaemonProperties;
import com.sun.netstorage.mgmt.inet.NetD;
import com.sun.netstorage.mgmt.inet.NetDaemon;
import com.sun.netstorage.mgmt.logic.ModuleInitializer;
import com.sun.netstorage.mgmt.logic.ServiceImpl;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.ui.shell.LogTracerImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class InetDaemonImpl
extends ServiceImpl
implements ModuleInitializer,
InetDaemon,
Constants {
    public static final Map map = new HashMap();
    private static InetDaemon me = null;
    private LogTracer logger;
    private boolean initDone = false;
    private static final String implCls = "com.sun.netstorage.mgmt.inet.InetDaemonImpl";
    private static final String ifcCls = "com.sun.netstorage.mgmt.inet.InetDaemon";
    static final String sccs_id = "@(#)InetDaemonImpl.java 1.7\t02/04/03 SMI";

    private InetDaemonImpl() {
        super(ifcCls);
        this.setDebug(InetDaemonProperties.isDebug());
        this.setTraceLevel(InetDaemonProperties.getTrace());
    }

    public void moduleInit() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        this.logInfo("starting daemons...");
        this.logger = new LogTracerImpl(this.getLogService());
        String[] stringArray = InetDaemonProperties.getDaemonNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!map.containsKey(string)) {
                this.logInfo("    configuring \"" + string + "\" daemon...");
                Properties properties = new Properties();
                properties.setProperty("daemon.name", InetDaemonProperties.getDaemonName(string));
                properties.setProperty("net.port", Integer.toString(InetDaemonProperties.getPort(string)));
                properties.setProperty("daemon.impl.classname", InetDaemonProperties.getDaemonImplClass(string));
                properties.setProperty("daemon.ifc.classname", InetDaemonProperties.getDaemonInterfaceClass(string));
                properties.setProperty("net.session.class", InetDaemonProperties.getSessionClass(string));
                properties.setProperty("net.iohandler.class", InetDaemonProperties.getIOHandlerClass(string));
                properties.setProperty("daemon.version", InetDaemonProperties.getVersion(string));
                properties.setProperty("net.queuelength", Integer.toString(InetDaemonProperties.getQueueLength(string)));
                properties.setProperty("net.maxqueued", Integer.toString(InetDaemonProperties.getMaxQueued(string)));
                properties.setProperty("net.maxconnections", Integer.toString(InetDaemonProperties.getMaxConnections(string)));
                properties.setProperty("net.time.warn", Integer.toString(InetDaemonProperties.getTimeToWarn(string)));
                properties.setProperty("net.time.disconnect", Integer.toString(InetDaemonProperties.getTimeToDisc(string)));
                properties.setProperty("net.time.housekeeping", Integer.toString(InetDaemonProperties.getTimeToHousekeep(string)));
                properties.setProperty("net.floodprotection", Integer.toString(InetDaemonProperties.getFloodProtection(string)));
                map.put(string, new NetD(properties, this.getLookup(), this.logger));
                this.startup(string);
            }
            ++n;
        }
    }

    public final void startup() {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.startup(string);
        }
    }

    public final void startup(String string) {
        NetDaemon netDaemon = this.getNetDaemon(string);
        if (null != netDaemon) {
            netDaemon.setServing(true);
            this.logInfo("    started \"" + string + "\" daemon");
        } else {
            this.logMinor("    failed to start \"" + string + "\" daemon");
        }
    }

    public final void shutdown() {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NetDaemon netDaemon = this.getNetDaemon(string);
            if (null == netDaemon) continue;
            netDaemon.setServing(false);
            this.logInfo("    shutdown \"" + string + "\" daemon");
        }
    }

    public final void shutdown(String string) {
        NetDaemon netDaemon = this.getNetDaemon(string);
        if (null != netDaemon) {
            netDaemon.setServing(false);
            this.logInfo("    shutdown \"" + string + "\" daemon");
        }
    }

    public static final InetDaemon getInstance() {
        if (InetDaemonProperties.isDebug()) {
            System.err.println("0 InetDaemonImpl.getInstance() me: " + me);
        }
        if (null == me) {
            me = new InetDaemonImpl();
        }
        if (InetDaemonProperties.isDebug()) {
            System.err.println("1 InetDaemonImpl.getInstance() me: " + me);
        }
        return me;
    }

    public String[] getDaemonNames() {
        Set set = map.keySet();
        return set.toArray(new String[set.size()]);
    }

    public NetDaemon getNetDaemon(String string) {
        return NetD.getInstance(string);
    }

    public static final NetDaemon getInstance(String string) {
        return NetD.getInstance(string);
    }

    public static final void main(String[] stringArray) {
        InetDaemon inetDaemon = InetDaemonImpl.getInstance();
        String[] stringArray2 = inetDaemon.getDaemonNames();
        int n = 0;
        while (n < stringArray2.length) {
            NetDaemon netDaemon = inetDaemon.getNetDaemon(stringArray2[n]);
            if (null == netDaemon) {
                System.err.println("InetDaemon: ERROR: could not get daemon " + stringArray2[n]);
            } else {
                netDaemon.setServing(true);
                netDaemon.setServing(false);
            }
            ++n;
        }
    }
}

