/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.inet;

import com.sun.netstorage.mgmt.app.ApplicationProperties;
import com.sun.netstorage.mgmt.inet.Constants;
import com.sun.netstorage.mgmt.services.ServiceProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class InetDaemonProperties
extends ServiceProperties
implements Constants {
    private static final String SCCS_ID = "@(#)InetDaemonProperties.java 1.14  02/11/15 SMI";
    private static int defQueueLength = -1;
    private static int defMaxConnections = -1;
    private static int defMaxQueued = -1;
    private static int defTimeToWarn = -1;
    private static int defTimeToDisc = -1;
    private static int defTimeToHouse = -1;
    private static int defFloodProtection = -1;
    private static String defSessionClass = null;
    private static String defIOHandlerClass = null;
    private static String defVersion = null;
    private static boolean debug = false;
    public static final String INETD_PREFIX = ServiceProperties.SERVICE_PREFIX + ".inetd";
    public static final String INETD = INETD_PREFIX + ".";
    public static final String INETD_DEFAULTS = INETD + "defaults.";
    public static final String Q_LEN_PROPERTY = INETD_DEFAULTS + "net.queuelength";
    public static final String Q_LEN_DEFAULT = "5";
    public static final String MAX_CONN_PROPERTY = INETD_DEFAULTS + "net.maxconnections";
    public static final String MAX_CONN_DEFAULT = "5";
    public static final String MAX_Q_PROPERTY = INETD_DEFAULTS + "net.maxqueued";
    public static final String MAX_Q_DEFAULT = "0";
    public static final String WARN_TIME_PROPERTY = INETD_DEFAULTS + "net.time.warn";
    public static final String WARN_TIME_DEFAULT = "2000000";
    public static final String DISC_TIME_PROPERTY = INETD_DEFAULTS + "net.time.disconnect";
    public static final String DISC_TIME_DEFAULT = "2000000";
    public static final String HOUSE_TIME_PROPERTY = INETD_DEFAULTS + "net.time.housekeeping";
    public static final String HOUSE_TIME_DEFAULT = "2000000";
    public static final String FLOODPROT_PROPERTY = INETD_DEFAULTS + "net.floodprotection";
    public static final String FLOODPROT_DEFAULT = "5";
    public static final String SESSCLASS_PROPERTY = INETD_DEFAULTS + "net.session.class";
    public static final String SESSCLASS_DEFAULT = "com.sun.netstorage.mgmt.inet.telnet.TelnetSession";
    public static final String IOHANDLER_PROPERTY = INETD_DEFAULTS + "net.iohandler.class";
    public static final String IOHANDLER_DEFAULT = "com.sun.netstorage.mgmt.io.telnet.TelnetIO";
    public static final String VERSION_PROPERTY = INETD_DEFAULTS + "daemon.version";
    public static final String VERSION_DEFAULT = "1.0.0.0";
    public static final String DAEMONLIST_PROPERTY = INETD + "daemon.list";
    public static final String DAEMONLIST_DEFAULT = "shell";
    private static final String DAEMON_PREFIX = INETD + "daemon";
    private static final String DAEMON_DOT = DAEMON_PREFIX + '.';
    public static final String DAEMON_NAME_PREFIX = DAEMON_PREFIX + ".name.";
    private static ThreadGroup ourThreadGroup;

    public static final boolean isDebug() {
        return ServiceProperties.isServiceDebug((String)"inetd");
    }

    public static final int getTrace() {
        return ServiceProperties.getServiceTrace((String)"inetd");
    }

    public static int getQueueLength() {
        if (-1 == defQueueLength) {
            defQueueLength = ApplicationProperties.intProperty((String)Q_LEN_PROPERTY, (String)"5");
        }
        return defQueueLength;
    }

    public static int getMaxConnections() {
        if (-1 == defMaxConnections) {
            defMaxConnections = ApplicationProperties.intProperty((String)MAX_CONN_PROPERTY, (String)"5");
        }
        return defMaxConnections;
    }

    public static int getMaxQueued() {
        if (-1 == defMaxQueued) {
            defMaxQueued = ApplicationProperties.intProperty((String)MAX_Q_PROPERTY, (String)MAX_Q_DEFAULT);
        }
        return defMaxQueued;
    }

    public static int getTimeToWarn() {
        if (-1 == defTimeToWarn) {
            defTimeToWarn = ApplicationProperties.intProperty((String)WARN_TIME_PROPERTY, (String)"2000000");
        }
        return defTimeToWarn;
    }

    public static int getTimeToDisc() {
        if (-1 == defTimeToDisc) {
            defTimeToDisc = ApplicationProperties.intProperty((String)DISC_TIME_PROPERTY, (String)"2000000");
        }
        return defTimeToDisc;
    }

    public static int getTimeToHousekeep() {
        if (-1 == defTimeToHouse) {
            defTimeToHouse = ApplicationProperties.intProperty((String)HOUSE_TIME_PROPERTY, (String)"2000000");
        }
        return defTimeToHouse;
    }

    public static int getFloodProtection() {
        if (-1 == defFloodProtection) {
            defFloodProtection = ApplicationProperties.intProperty((String)FLOODPROT_PROPERTY, (String)"5");
        }
        return defFloodProtection;
    }

    public static String getSessionClass() {
        if (null == defSessionClass) {
            defSessionClass = ApplicationProperties.getProperty((String)SESSCLASS_PROPERTY, (String)SESSCLASS_DEFAULT);
        }
        return defSessionClass;
    }

    public static String getIOHandlerClass() {
        if (null == defIOHandlerClass) {
            defIOHandlerClass = ApplicationProperties.getProperty((String)IOHANDLER_PROPERTY, (String)IOHANDLER_DEFAULT);
        }
        return defIOHandlerClass;
    }

    public static String getVersion() {
        if (null == defVersion) {
            defVersion = ApplicationProperties.getProperty((String)VERSION_PROPERTY, (String)VERSION_DEFAULT);
        }
        return defVersion;
    }

    public static String[] getDaemonList() {
        String string = ApplicationProperties.getProperty((String)DAEMONLIST_PROPERTY, (String)DAEMONLIST_DEFAULT);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t");
        if (debug) {
            System.err.println("daemonList: list " + string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
            if (!debug) continue;
            System.err.println("daemonList: " + arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getDaemonNames() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        Iterator<Object> iterator = ApplicationProperties.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (!string2.startsWith(DAEMON_NAME_PREFIX) || (string = ApplicationProperties.stringProperty((String)string2, null)) == null) continue;
            vector.add(string);
        }
        if (vector.size() == 0) {
            vector.add(DAEMONLIST_DEFAULT);
        }
        if (vector.size() > 0) {
            stringArray = vector.toArray(new String[vector.size()]);
        }
        return stringArray;
    }

    public static String getDaemonKey(String string, String string2) {
        return DAEMON_PREFIX + "." + string + "." + string2;
    }

    public static int getQueueLength(String string) {
        return InetDaemonProperties.intProperty(string, "net.queuelength", InetDaemonProperties.getQueueLength());
    }

    public static String getDaemonName(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "daemon.name"), (String)string);
    }

    public static String getDaemonImplClass(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "daemon.impl.classname"), null);
    }

    public static String getDaemonInterfaceClass(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "daemon.ifc.classname"), (String)InetDaemonProperties.getDaemonImplClass(string));
    }

    public static String getVersion(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "daemon.version"), (String)InetDaemonProperties.getVersion());
    }

    public static int getPort(String string) {
        return InetDaemonProperties.intProperty(string, "net.port", -1);
    }

    public static int getMaxConnections(String string) {
        return InetDaemonProperties.intProperty(string, "net.maxconnections", InetDaemonProperties.getMaxConnections());
    }

    public static int getFloodProtection(String string) {
        return InetDaemonProperties.intProperty(string, "net.floodprotection", InetDaemonProperties.getFloodProtection());
    }

    public static String getSessionClass(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "net.session.class"), (String)InetDaemonProperties.getSessionClass());
    }

    public static String getIOHandlerClass(String string) {
        return ApplicationProperties.getProperty((String)(DAEMON_DOT + string + '.' + "net.iohandler.class"), (String)InetDaemonProperties.getIOHandlerClass());
    }

    public static int getMaxQueued(String string) {
        return InetDaemonProperties.intProperty(string, "net.maxqueued", InetDaemonProperties.getMaxQueued());
    }

    public static int getTimeToWarn(String string) {
        return InetDaemonProperties.intProperty(string, "net.time.warn", InetDaemonProperties.getTimeToWarn());
    }

    public static int getTimeToDisc(String string) {
        return InetDaemonProperties.intProperty(string, "net.time.disconnect", InetDaemonProperties.getTimeToDisc());
    }

    public static int getTimeToHousekeep(String string) {
        return InetDaemonProperties.intProperty(string, "net.time.housekeeping", InetDaemonProperties.getTimeToHousekeep());
    }

    static int intProperty(String string, String string2, int n) {
        String string3 = InetDaemonProperties.getDaemonKey(string, string2);
        return ApplicationProperties.intProperty((String)string3, (int)n);
    }

    public static void list() {
        ApplicationProperties.list((String)INETD);
    }

    public static final synchronized ThreadGroup getInetThreadGroup() {
        if (ourThreadGroup == null) {
            ourThreadGroup = new ThreadGroup(ServiceProperties.getServiceThreadGroup(), INETD_PREFIX);
        }
        return ourThreadGroup;
    }

    private InetDaemonProperties() {
    }

    static {
        if (InetDaemonProperties.isDebug()) {
            InetDaemonProperties.list();
        }
        ourThreadGroup = null;
    }
}

