/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.inet;

import com.sun.netstorage.mgmt.inet.Constants;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.net.BootException;
import com.sun.netstorage.mgmt.net.PortListener;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.util.StringUtils;
import dtw.telnetd.net.ConnectionFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;

public abstract class NetDaemon
implements Constants {
    private static final boolean debug = false;
    protected final Properties myProps;
    protected final Lookup myLookup;
    protected final LogTracer myLogger;
    protected final String myName;
    protected PortListener myPortListener;
    private int myPort;
    private static final String myClass = "com.sun.netstorage.mgmt.inet.NetDaemon";
    private static final HashMap daemonMap = new HashMap();
    static final String sccs_id = "@(#)NetDaemon.java 1.7\t02/01/16 SMI";

    protected NetDaemon(Properties properties, Lookup lookup, LogTracer logTracer) throws BootException {
        if (null != properties) {
            this.myProps = properties;
            this.myName = this.myProps.getProperty("daemon.name");
            String string = this.myProps.getProperty("net.port");
            this.myPort = -1;
            try {
                this.myPort = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BootException("`boot.exc.err.invalid.port`", new Serializable[]{string}, numberFormatException);
            }
        } else {
            throw new BootException("`boot.exc.err.properties`");
        }
        this.myLookup = lookup;
        this.myLogger = logTracer;
        daemonMap.put(new Integer(this.myPort), this);
    }

    protected void prePrepareListener() {
    }

    protected void postPrepareListener() {
    }

    public final void setServing(boolean bl) {
        try {
            if (null == this.myPortListener) {
                this.prePrepareListener();
                this.prepareListener();
            }
            this.postPrepareListener();
            this.myPortListener.setListening(bl);
        }
        catch (BootException bootException) {
            this.myLogger.log("BootException - setServing.prepareListener()");
            this.myLogger.log(StringUtils.getStackTrace((Throwable)((Object)bootException)));
        }
    }

    public final boolean isServing() {
        boolean bl = false;
        if (null != this.myPortListener) {
            bl = this.myPortListener.isListening();
        }
        return bl;
    }

    protected final void registerConnectionFilter(ConnectionFilter connectionFilter) {
        if (null != this.myPortListener) {
            this.myPortListener.getConnectionManager().setConnectionFilter(connectionFilter);
        }
    }

    protected final void shutdown() {
        if (null == this.myPortListener) {
            return;
        }
        this.myPortListener.shutdown();
        this.myPortListener.stop();
        this.myPortListener = null;
    }

    protected final String getName() {
        return this.myName;
    }

    protected final int getPort() {
        return this.myPort;
    }

    public String getVersion() {
        return this.myProps.getProperty("daemon.version");
    }

    protected final void prepareListener() throws BootException {
        this.myPortListener = PortListener.createPortListener(this.myProps, this.myLookup, this.myLogger);
        try {
            this.myPortListener.start();
        }
        catch (Exception exception) {
            throw new BootException("Failure while starting PortListener thread: " + exception.getMessage());
        }
    }

    public static final NetDaemon getInstance(int n) {
        return (NetDaemon)daemonMap.get(new Integer(n));
    }
}

