/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.io;

import com.sun.netstorage.mgmt.net.Connection;
import com.sun.netstorage.mgmt.net.ConnectionData;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;

public abstract class NetProtoIO {
    private static final boolean debug = false;
    protected final LogTracer logger;
    protected final Connection myConnection;
    protected final ConnectionData myConnectionData;
    protected final DataOutputStream outstream;
    protected final DataInputStream instream;
    protected final InetAddress localAddy;
    protected final Object initCommData;
    protected boolean initializing;
    protected boolean closing;
    protected boolean cr;
    protected boolean nl;
    public static final int IO_EXCEPTION = -1;
    public static final int EOF_EXCEPTION = -2;
    static final String sccs_id = "@(#)NetProtoIO.java 1.6 02/07/12 SMI";

    public NetProtoIO(Connection connection) throws IOException {
        this.myConnection = connection;
        this.logger = connection.getLogger();
        this.myConnectionData = connection.getConnectionData();
        this.localAddy = this.myConnectionData.getSocket().getLocalAddress();
        this.closing = false;
        this.cr = false;
        this.initProtoHandler();
        this.instream = new DataInputStream(this.myConnectionData.getSocket().getInputStream());
        this.outstream = new DataOutputStream(new BufferedOutputStream(this.myConnectionData.getSocket().getOutputStream()));
        this.initCommData = this.initCommunications();
    }

    public abstract void write(byte var1);

    public final void write(int n) {
        this.write((byte)n);
    }

    public final void write(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.write(byArray[n]);
            ++n;
        }
    }

    public final void write(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.write((byte)nArray[n]);
            ++n;
        }
    }

    public final void write(char c) {
        this.write((byte)c);
    }

    public final void write(String string) {
        try {
            this.outstream.writeBytes(string);
        }
        catch (IOException iOException) {
            this.write(string.getBytes());
        }
    }

    public final void flush() {
        block2: {
            try {
                this.outstream.flush();
            }
            catch (IOException iOException) {
                if (!this.myConnection.isActive()) break block2;
                this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
            }
        }
    }

    public abstract void closeOutput();

    public abstract int read();

    public final void closeInput() {
        try {
            this.instream.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int read16int() {
        int n;
        try {
            try {
                int n2;
                n = n2 = this.instream.readUnsignedShort();
                Object var5_6 = null;
                NetProtoIO netProtoIO = this;
            }
            catch (EOFException eOFException) {
                if (this.myConnection.isActive()) {
                    this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
                }
                int n3 = -2;
                Object var5_7 = null;
                NetProtoIO netProtoIO = this;
                netProtoIO.myConnection.yield();
                return n3;
            }
            catch (IOException iOException) {
                if (this.myConnection.isActive()) {
                    this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
                }
                int n4 = -1;
                Object var5_8 = null;
                NetProtoIO netProtoIO = this;
                netProtoIO.myConnection.yield();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            NetProtoIO netProtoIO = this;
            netProtoIO.myConnection.yield();
            throw throwable;
        }
        netProtoIO.myConnection.yield();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int rawread() {
        int n;
        int n2 = 0;
        try {
            try {
                n2 = this.instream.readUnsignedByte();
                this.myConnectionData.activity();
                n = n2;
                Object var6_4 = null;
                NetProtoIO netProtoIO = this;
            }
            catch (EOFException eOFException) {
                if (this.myConnection.isActive()) {
                    this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
                }
                int n3 = -2;
                Object var6_5 = null;
                NetProtoIO netProtoIO = this;
                netProtoIO.myConnection.yield();
                return n3;
            }
            catch (IOException iOException) {
                if (!this.initializing && this.myConnection.isActive()) {
                    this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
                }
                int n4 = -1;
                Object var6_6 = null;
                NetProtoIO netProtoIO = this;
                netProtoIO.myConnection.yield();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            NetProtoIO netProtoIO = this;
            netProtoIO.myConnection.yield();
            throw throwable;
        }
        netProtoIO.myConnection.yield();
        return n;
    }

    protected abstract void initProtoHandler();

    protected abstract Object initCommunications();
}

