/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.net;

import com.sun.netstorage.mgmt.inet.NetSession;
import com.sun.netstorage.mgmt.inet.NetSessionUtils;
import com.sun.netstorage.mgmt.io.BasicTerminalIO;
import com.sun.netstorage.mgmt.io.NetProtoIO;
import com.sun.netstorage.mgmt.io.TerminalIO;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.net.ConnectionData;
import com.sun.netstorage.mgmt.net.ConnectionEvent;
import com.sun.netstorage.mgmt.net.ConnectionListener;
import com.sun.netstorage.mgmt.net.Constants;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.util.StringUtils;
import java.io.IOException;
import java.util.Vector;

public class Connection
extends Thread
implements Constants {
    private static int number;
    private boolean dead;
    private Vector listeners;
    private ConnectionData myConnectionData;
    private BasicTerminalIO myTerminalIO;
    private Lookup lookup;
    private LogTracer logger;
    static final String sccs_id = "@(#)Connection.java 1.3\t02/01/09 SMI";

    public Connection(ThreadGroup threadGroup, ConnectionData connectionData, Lookup lookup, LogTracer logTracer) throws IOException {
        super(threadGroup, "netConnection" + ++number);
        this.lookup = lookup;
        this.logger = logTracer;
        this.myConnectionData = connectionData;
        this.listeners = new Vector(3);
        NetProtoIO netProtoIO = NetSessionUtils.createNetProtoIO(connectionData.getIOHandlerClassName(), this);
        this.myTerminalIO = new TerminalIO(this, netProtoIO);
        this.dead = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                String string = this.myConnectionData.getSessionClassName();
                NetSession netSession = NetSessionUtils.createSession(string, this);
                netSession.run();
            }
            catch (Exception exception) {
                this.logger.log(new String[]{"got exception" + exception.toString()});
                this.logger.log(StringUtils.getStackTrace((Throwable)exception));
                Object var4_5 = null;
                this.close();
            }
            Object var4_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
    }

    public ConnectionData getConnectionData() {
        return this.myConnectionData;
    }

    public BasicTerminalIO getTerminalIO() {
        return this.myTerminalIO;
    }

    public LogTracer getLogger() {
        return this.logger;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void close() {
        if (this.dead) {
            return;
        }
        try {
            this.dead = true;
            this.logger.trace(new String[]{"Closed " + this.toString() + " and inactive."});
            this.myTerminalIO.close();
            this.myConnectionData.getSocket().close();
            this.myConnectionData.getManager().registerClosedConnection(this);
        }
        catch (Exception exception) {
            this.logger.log(new String[]{"got exception " + exception.toString()});
            this.logger.log(StringUtils.getStackTrace((Throwable)exception));
        }
    }

    public boolean isActive() {
        return !this.dead;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.listeners.addElement(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.listeners.removeElement(connectionListener);
    }

    public void processConnectionEvent(ConnectionEvent connectionEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            ConnectionListener connectionListener = (ConnectionListener)this.listeners.elementAt(n);
            if (connectionEvent.isType(101)) {
                connectionListener.connectionLoggedOff(connectionEvent);
            } else if (connectionEvent.isType(100)) {
                connectionListener.connectionTimedOut(connectionEvent);
            } else if (connectionEvent.isType(102)) {
                connectionListener.connectionLogoutRequest(connectionEvent);
            } else if (connectionEvent.isType(103)) {
                connectionListener.connectionBroken(connectionEvent);
            }
            ++n;
        }
    }
}

