/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.net;

import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.net.ConnectionData;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class ConnectionQueue {
    private Vector queuedConnections;
    private int maxqueued;
    private static final String NET_QUEUE = "net-queue";
    static final String sccs_id = "@(#)ConnectionQueue.java 1.4\t02/07/10 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$net$Messages;

    public ConnectionQueue(int n) {
        this.queuedConnections = new Vector(n);
        this.maxqueued = n;
    }

    public void addToQueue(ConnectionData connectionData) {
        if (this.queuedConnections.size() < this.maxqueued) {
            this.queuedConnections.addElement(connectionData);
            this.informQueued();
        } else {
            this.denyQueueing(connectionData);
        }
    }

    public synchronized ConnectionData connectFromQueue() {
        ConnectionData connectionData = (ConnectionData)this.queuedConnections.firstElement();
        this.queuedConnections.removeElementAt(0);
        this.informQueued();
        return connectionData;
    }

    public synchronized void informQueuedOfShutdown() {
        int n = 0;
        Enumeration enumeration = this.queuedConnections.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionData connectionData = (ConnectionData)enumeration.nextElement();
            String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$net$Messages == null ? ConnectionQueue.class$("com.sun.netstorage.mgmt.net.Messages") : class$com$sun$netstorage$mgmt$net$Messages), (String)"`net.msg.info.shut_down`", (Object[])new Serializable[]{NET_QUEUE}, (Locale)connectionData.getLocale());
            try {
                PrintStream printStream = this.getStream(connectionData.getSocket());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.queuedConnections.removeElementAt(n++);
        }
    }

    public boolean getQueueStatus() {
        return this.queuedConnections.size() != 0;
    }

    private synchronized void informQueued() {
        int n = 1;
        Enumeration enumeration = this.queuedConnections.elements();
        while (enumeration.hasMoreElements()) {
            Object var3_3 = null;
            ConnectionData connectionData = (ConnectionData)enumeration.nextElement();
            String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$net$Messages == null ? ConnectionQueue.class$("com.sun.netstorage.mgmt.net.Messages") : class$com$sun$netstorage$mgmt$net$Messages), (String)"`net.msg.info.shut_down`", (Object[])new Serializable[]{NET_QUEUE, Integer.toString(n)}, (Locale)connectionData.getLocale());
            try {
                PrintStream printStream = this.getStream(connectionData.getSocket());
            }
            catch (IOException iOException) {
                this.queuedConnections.removeElement(var3_3);
            }
            ++n;
        }
    }

    private void denyQueueing(ConnectionData connectionData) {
        String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$net$Messages == null ? (class$com$sun$netstorage$mgmt$net$Messages = ConnectionQueue.class$("com.sun.netstorage.mgmt.net.Messages")) : class$com$sun$netstorage$mgmt$net$Messages), (String)"`net.msg.info.queue_is_full`", (Object[])new Serializable[]{NET_QUEUE}, (Locale)connectionData.getLocale());
        try {
            PrintStream printStream = this.getStream(connectionData.getSocket());
            printStream.println(string);
            connectionData.getSocket().close();
        }
        catch (IOException iOException) {}
    }

    private PrintStream getStream(Socket socket) throws IOException {
        return new PrintStream(socket.getOutputStream());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

