/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.net;

import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.net.BootException;
import com.sun.netstorage.mgmt.net.ConnectionManager;
import com.sun.netstorage.mgmt.net.Constants;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.util.StringUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;

public class PortListener
extends Thread
implements Constants {
    private int myPort;
    private int floodProtection;
    private ServerSocket srvsock;
    private Socket incoming = null;
    private boolean available = false;
    private LogTracer logger;
    private Lookup lookup;
    private ConnectionManager myConnectionManager;
    private static final HashMap portL = new HashMap();
    private static final String logmsg = "Listening on Port {0,number,integer} with queue size of {1,number,integer}.";
    static final String sccs_id = "@(#)PortListener.java 1.4\t02/01/09 SMI";

    private PortListener(int n, int n2, Lookup lookup, LogTracer logTracer) {
        this.myPort = n;
        this.floodProtection = n2;
        this.lookup = lookup;
        this.logger = logTracer;
        this.srvsock = null;
    }

    public void run() {
        try {
            this.srvsock = new ServerSocket(this.myPort, this.floodProtection);
            Object[] objectArray = new Object[]{new Integer(this.myPort), new Integer(this.floodProtection)};
            this.logger.trace(new String[]{MessageFormat.format(logmsg, objectArray)});
            while (true) {
                this.incoming = this.srvsock.accept();
                if (this.available) {
                    this.myConnectionManager.makeConnection(this.incoming);
                } else {
                    this.incoming.close();
                }
                this.yield();
            }
        }
        catch (IOException iOException) {
            this.logger.log(new String[]{iOException.toString()});
            this.logger.log(StringUtils.getStackTrace((Throwable)iOException));
            return;
        }
    }

    public final Lookup getLookup() {
        return this.lookup;
    }

    public final LogTracer getLogger() {
        return this.logger;
    }

    public final void setListening(boolean bl) {
        this.available = bl;
    }

    public final boolean isListening() {
        return this.available;
    }

    public final ConnectionManager getConnectionManager() {
        return this.myConnectionManager;
    }

    public final void shutdown() {
        this.myConnectionManager.shutdown();
        this.myConnectionManager.stop();
    }

    public static PortListener createPortListener(Properties properties, Lookup lookup, LogTracer logTracer) throws BootException {
        PortListener portListener = null;
        try {
            int n = Integer.parseInt(properties.getProperty("net.port"));
            Integer n2 = new Integer(n);
            if (!portL.containsKey(n2)) {
                int n3 = Integer.parseInt(properties.getProperty("net.floodprotection"));
                portListener = new PortListener(n, n3, lookup, logTracer);
                portL.put(n2, portListener);
            } else {
                portListener = (PortListener)portL.get(n2);
            }
        }
        catch (Exception exception) {
            throw new BootException("Failure while creating PortListener instance:\n" + exception.getMessage());
        }
        portListener.myConnectionManager = ConnectionManager.createConnectionManager(properties, lookup, logTracer);
        try {
            portListener.myConnectionManager.start();
        }
        catch (Exception exception) {
            throw new BootException("Failure while starting ConnectionManager watchdog thread:\n" + exception.getMessage());
        }
        return portListener;
    }
}

