/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.array.t3.config;

import com.sun.netstorage.mgmt.dm.t3.logic.fb.config.T3CacheContext;
import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.services.configuration.device.context.FibreSCSIContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.FirmwareContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.IdContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.MultiPathContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.NetworkContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.VolumeContext;
import com.sun.netstorage.mgmt.ui.array.t3.Messages;
import com.sun.netstorage.mgmt.ui.array.t3.config.CtxCode;
import com.sun.netstorage.mgmt.ui.cli.StorEdgeLogin;
import com.sun.netstorage.mgmt.ui.util.PropertySetException;
import com.sun.netstorage.mgmt.ui.util.PropertyValue;
import com.sun.netstorage.mgmt.util.SimpleProperty;
import com.sun.netstorage.mgmt.util.UIProperty;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class T3SystemContext
implements Messages {
    String id = null;
    IdContext idCtx = null;
    FirmwareContext fwCtx = null;
    T3CacheContext cacheCtx = null;
    MultiPathContext mpCtx = null;
    NetworkContext netCtx = null;
    VolumeContext volCtx = null;
    FibreSCSIContext fsCtx = null;
    int unitCount = 0;
    static final String sccs_id = "@(#)T3SystemContext.java 1.24    03/01/30 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$array$t3$Messages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages;

    public T3SystemContext(String string, T3CacheContext t3CacheContext, MultiPathContext multiPathContext, NetworkContext networkContext) {
        this(string, null, null, t3CacheContext, multiPathContext, networkContext, null, null, 0);
    }

    public T3SystemContext(String string, IdContext idContext, FirmwareContext firmwareContext, T3CacheContext t3CacheContext, MultiPathContext multiPathContext, NetworkContext networkContext) {
        this(string, idContext, firmwareContext, t3CacheContext, multiPathContext, networkContext, null, null, 0);
    }

    public T3SystemContext(String string, IdContext idContext, FirmwareContext firmwareContext, T3CacheContext t3CacheContext, MultiPathContext multiPathContext, NetworkContext networkContext, VolumeContext volumeContext, FibreSCSIContext fibreSCSIContext, int n) {
        this.id = string;
        this.idCtx = idContext;
        this.fwCtx = firmwareContext;
        this.cacheCtx = t3CacheContext;
        this.mpCtx = multiPathContext;
        this.netCtx = networkContext;
        this.volCtx = volumeContext;
        this.fsCtx = fibreSCSIContext;
        this.unitCount = n;
    }

    public IdContext getIdContext() {
        return this.idCtx;
    }

    public FirmwareContext getFirmwareContext() {
        return this.fwCtx;
    }

    public NetworkContext getNetworkContext() {
        return this.netCtx;
    }

    public T3CacheContext getT3CacheContext() {
        return this.cacheCtx;
    }

    public FibreSCSIContext getFibreSCSIContext() {
        return this.fsCtx;
    }

    public void setFibreSCSIContext(FibreSCSIContext fibreSCSIContext) {
        this.fsCtx = fibreSCSIContext;
    }

    public MultiPathContext getMultiPathContext() {
        return this.mpCtx;
    }

    public VolumeContext getVolumeContext() {
        return this.volCtx;
    }

    public String getId() {
        return this.id;
    }

    public String getSystemName() {
        return this.idCtx.getName();
    }

    public UIProperty[] getIDInfo() {
        UIProperty[] uIPropertyArray = new UIProperty[]{new SimpleProperty("str.name", (Object)this.idCtx.getName()), new SimpleProperty("str.type", (Object)this.idCtx.getType()), new SimpleProperty("str.description", (Object)this.idCtx.getDescription()), new SimpleProperty("str.firmware.rev", (Object)this.fwCtx.getFirmwareVersion())};
        return uIPropertyArray;
    }

    public UIProperty[] getCacheInfo() {
        Object[][] objectArray = this.getCacheProperties();
        UIProperty[] uIPropertyArray = new UIProperty[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            uIPropertyArray[n] = (UIProperty)objectArray[n][1];
            ++n;
        }
        return uIPropertyArray;
    }

    public Object[][] getCacheProperties() {
        Object[][] objectArray = new Object[5][];
        PropertyValue propertyValue = null;
        propertyValue = new PropertyValue("str.cache.mirror", this.cacheCtx.getCacheMirrorStateStrings(), this.getPos(this.cacheCtx.getCacheMirrorStates(), this.cacheCtx.getCacheMirror()));
        objectArray[0] = new Object[]{"str.cache.mirror", propertyValue};
        propertyValue = new PropertyValue("str.stripe.size", this.cacheCtx.getCacheStripeKBSizeStateStrings(), this.getPos(this.cacheCtx.getCacheStripeKBSizeStates(), this.cacheCtx.getCacheStripeKBSize()));
        objectArray[1] = new Object[]{"str.stripe.size", propertyValue};
        propertyValue = new PropertyValue("str.cache.mode", this.cacheCtx.getCacheModeStateStrings(), this.getPos(this.cacheCtx.getCacheModeStates(), this.cacheCtx.getCacheMode()));
        objectArray[2] = new Object[]{"str.cache.mode", propertyValue};
        propertyValue = new PropertyValue("str.read.ahead", this.cacheCtx.getCacheReadAheadStateStrings(), this.getPos(this.cacheCtx.getCacheReadAheadStates(), this.cacheCtx.getCacheReadAhead()));
        objectArray[3] = new Object[]{"str.read.ahead", propertyValue};
        propertyValue = new PropertyValue("str.reconrate", this.cacheCtx.getCacheReconRateStateStrings(), this.getPos(this.cacheCtx.getCacheReconRateStates(), this.cacheCtx.getCacheReconRate()));
        objectArray[4] = new Object[]{"str.reconrate", propertyValue};
        return objectArray;
    }

    public UIProperty[] getMPInfo() {
        Object[][] objectArray = this.getMPProperties();
        UIProperty[] uIPropertyArray = new UIProperty[]{(UIProperty)objectArray[0][1]};
        return uIPropertyArray;
    }

    public Object[][] getMPProperties() {
        Object[][] objectArray = new Object[1][];
        PropertyValue propertyValue = new PropertyValue("str.mp", this.mpCtx.getMpSupportStateStrings(), this.getPos(this.mpCtx.getMpSupportStates(), this.mpCtx.getMpSupport()));
        objectArray[0] = new Object[]{"str.mp", propertyValue};
        return objectArray;
    }

    public UIProperty[] getNetworkInfo() {
        Object[][] objectArray = this.getNetworkProperties();
        UIProperty[] uIPropertyArray = new UIProperty[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            uIPropertyArray[n] = (UIProperty)objectArray[n][1];
            ++n;
        }
        return uIPropertyArray;
    }

    public UIProperty[] getVolSlicingInfo() {
        if (!this.isFW21Above()) {
            return null;
        }
        PropertyValue propertyValue = null;
        String string = "`Disabled`";
        if (this.volCtx.isVolsBasedOnPSExtentsSupported()) {
            string = "`enable`";
        }
        propertyValue = new PropertyValue("`volslicing`", new String[]{string}, 0);
        Object[][] objectArrayArray = new Object[][]{{"`volslicing`", propertyValue}};
        UIProperty[] uIPropertyArray = new UIProperty[]{(UIProperty)objectArrayArray[0][1]};
        return uIPropertyArray;
    }

    public UIProperty[] getFCTopologyInfo() {
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        String string = FibreSCSIContext.getFcTopologyModeStr((int)this.fsCtx.getFcTopologyMode());
        PropertyValue propertyValue = null;
        propertyValue = new PropertyValue("`Fibre_Channel_Topology`", new String[]{string}, 0);
        arrayList.add(propertyValue);
        if (this.fsCtx.isFcSpeedSettable()) {
            int n = this.fsCtx.getFcSpeed();
            String string2 = FibreSCSIContext.getFcSpeedStr((int)n);
            propertyValue = new PropertyValue("set.fc.speed", new String[]{string2}, 0);
            arrayList.add(propertyValue);
        }
        UIProperty[] uIPropertyArray = arrayList.toArray(new UIProperty[0]);
        return uIPropertyArray;
    }

    public Object[][] getNetworkProperties() {
        Object[][] objectArray = new Object[5][];
        PropertyValue propertyValue = null;
        propertyValue = new PropertyValue("str.interface", new String[]{this.netCtx.getNetworkType()}, 0);
        objectArray[0] = new Object[]{"`Interface`", propertyValue};
        propertyValue = new PropertyValue("str.ipadd", new String[]{this.netCtx.getIpAddr()}, 0);
        objectArray[1] = new Object[]{"str.ipadd", propertyValue};
        propertyValue = new PropertyValue("str.submask", new String[]{this.netCtx.getSubnetMask()}, 0);
        objectArray[2] = new Object[]{"str.submask", propertyValue};
        propertyValue = new PropertyValue("str.gateway", new String[]{this.netCtx.getGateway()}, 0);
        objectArray[3] = new Object[]{"str.gateway", propertyValue};
        String string = "`No`";
        if (this.netCtx.isRarpEnabled()) {
            string = "`Yes`";
        }
        propertyValue = new PropertyValue("str.rarp", new String[]{string}, 0);
        objectArray[4] = new Object[]{"str.rarp", propertyValue};
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProp(String string, String string2, InputStream inputStream, OutputStream outputStream, boolean bl, Locale locale, boolean bl2, boolean bl3) throws NumberFormatException, PropertySetException {
        String string3 = string.trim();
        String string4 = string2.trim();
        Object var11_11 = null;
        Object var12_12 = null;
        if (!CtxCode.containsKey(string3)) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.parameter", (Serializable[])new String[]{string3}));
        int n = CtxCode.getCode(string3);
        int[] nArray = null;
        String[] stringArray = null;
        int n2 = -1;
        switch (n) {
            case 1401: {
                nArray = this.cacheCtx.getCacheStripeKBSizeStates();
                stringArray = this.cacheCtx.getCacheStripeKBSizeStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                this.cacheCtx.setCacheStripeKBSize(n2);
                return;
            }
            case 1402: {
                nArray = this.cacheCtx.getCacheModeStates();
                stringArray = this.cacheCtx.getCacheModeStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                if (n2 == this.cacheCtx.getCacheMode()) return;
                if (!bl2) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.mirror.on", (Serializable[])new String[0]));
                this.cacheCtx.setCacheMode(n2);
                return;
            }
            case 1403: {
                nArray = this.cacheCtx.getCacheMirrorStates();
                stringArray = this.cacheCtx.getCacheMirrorStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                if (n2 != 0 && !bl3) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.cachemode.auto", (Serializable[])new String[0]));
                this.cacheCtx.setCacheMirror(n2);
                return;
            }
            case 1405: {
                nArray = this.cacheCtx.getCacheReadAheadStates();
                stringArray = this.cacheCtx.getCacheReadAheadStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                this.cacheCtx.setCacheReadAhead(n2);
                return;
            }
            case 1406: {
                nArray = this.cacheCtx.getCacheReconRateStates();
                stringArray = this.cacheCtx.getCacheReconRateStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                this.cacheCtx.setCacheReconRate(n2);
                return;
            }
            case 1601: {
                if (string4.equalsIgnoreCase("rw")) {
                    string4 = "ReadWrite";
                }
                if ((n2 = this.getIndexValue(string4, nArray = this.mpCtx.getMpSupportStates(), stringArray = this.mpCtx.getMpSupportStateStrings())) < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                this.mpCtx.setMpSupport(n2);
                return;
            }
            case 1701: {
                this.netCtx.setGateway(string4);
                return;
            }
            case 1703: {
                this.netCtx.setIpAddr(string4);
                return;
            }
            case 1704: {
                this.netCtx.setSubnetMask(string4);
                return;
            }
            case 1705: {
                boolean bl4 = false;
                if ("yes".equalsIgnoreCase(string4)) {
                    bl4 = true;
                    this.netCtx.setRarpEnabled(bl4);
                    return;
                }
                if (!"no".equalsIgnoreCase(string4)) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                bl4 = false;
                this.netCtx.setRarpEnabled(bl4);
                return;
            }
            case 1801: {
                if (!this.isFW21Above()) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.volslicing.fw21", null));
                if (this.volCtx.isVolsBasedOnPSExtentsSupported()) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.volslicing.enabled", (Serializable[])new String[]{this.getSystemName()}));
                if (!string4.equalsIgnoreCase("enable")) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                this.volCtx.setVolsBasedOnPSExtentsSupported(true);
                return;
            }
            case 1901: {
                if (!this.isFW21Above()) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.fctopology.fw21", null));
                if (string4.equalsIgnoreCase("fabric_p2p")) {
                    string4 = "Fabric Point-to-Point";
                }
                T3SystemContext t3SystemContext = this;
                nArray = t3SystemContext.fsCtx.getFcTopologyModeStates();
                T3SystemContext t3SystemContext2 = this;
                stringArray = t3SystemContext2.fsCtx.getFcTopologyModeStateStrings();
                n2 = this.getIndexValue(string4, nArray, stringArray);
                if (n2 < 0) throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$Messages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$Messages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.Messages")) : class$com$sun$netstorage$mgmt$ui$array$t3$Messages, "str.invalid.config.value", (Serializable[])new String[]{string4}));
                String string5 = "y";
                if (bl) {
                    String string6 = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages), (String)"config.set.fctopology.warning.cli", null, (Locale)locale);
                    try {
                        outputStream.write(string6.getBytes());
                        string5 = StorEdgeLogin.readUntilCR(inputStream, outputStream, true, false, true);
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!string5.equalsIgnoreCase("y")) return;
                this.fsCtx.setFcTopologyMode(n2);
                return;
            }
            default: {
                return;
            }
        }
    }

    public void setFCSpeed(String string, String string2, String string3, InputStream inputStream, OutputStream outputStream, Locale locale, boolean bl) throws PropertySetException {
        if (!this.fsCtx.isFcSpeedSettable()) {
            throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages, "config.set.fcspeed.unsettable", (Serializable[])new String[]{string}));
        }
        if (string2 != null) {
            int n;
            if (string3 == null) {
                if (!bl) {
                    throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages, "config.set.fcspeedchg.undefined", null));
                }
                String string4 = null;
                try {
                    String string5 = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages), (String)"config.set.fcspeedchg.request.cli", null, (Locale)locale);
                    outputStream.write(string5.getBytes());
                    string4 = StorEdgeLogin.readUntilCR(inputStream, outputStream, true, false, true);
                    string2 = "cable";
                    if ("y".equalsIgnoreCase(string4)) {
                        string2 = "force";
                    }
                }
                catch (EOFException eOFException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ("auto".equalsIgnoreCase(string2)) {
                string2 = "Auto";
            }
            if ((n = FibreSCSIContext.getFcSpeedInt((String)string2)) < 0) {
                throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages, "config.set.fcspeed.invalid", null));
            }
            this.fsCtx.setFcSpeed(n);
            int n2 = FibreSCSIContext.getFcSpeedChangeInt((String)string3);
            if (n2 < 0) {
                throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages, "config.set.fcspeedchg.invalid", null));
            }
            this.fsCtx.setFcSpeedChange(n2);
        } else if (string3 != null) {
            throw new PropertySetException(new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = T3SystemContext.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages, "config.set.fcspeed.undefined", null));
        }
    }

    public int getUnitCount() {
        return this.unitCount;
    }

    int getIndexValue(String string, int[] nArray, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return nArray[n];
            }
            ++n;
        }
        return -1;
    }

    int getPos(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public boolean isFW21Above() {
        boolean bl = false;
        try {
            String string = this.fwCtx.getFirmwareVersion();
            if (string.compareTo("2.1") >= 0) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

