/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.console.login;

import com.sun.netstorage.mgmt.app.storedge.cs.CoreProperties;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.console.login.CIMAuthentication;
import com.sun.netstorage.mgmt.ui.console.login.Messages;
import com.sun.netstorage.mgmt.ui.framework.CmdCompletion;
import com.sun.netstorage.mgmt.ui.framework.Command;
import com.sun.netstorage.mgmt.ui.framework.Session;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class LoginCommand
extends Command
implements Messages {
    private String m_user = null;
    private String m_passwd = null;
    private String m_authMethod = "CIM";
    private String[] m_args = null;
    private String m_namespace = null;
    private String m_host = null;
    private boolean m_timeout = false;
    HttpServletRequest m_req = null;
    Session m_session = null;
    public static final int LOGIN_OP = 1;
    public static final int LOGOUT_OP = 2;
    int m_opType = 1;
    private static final boolean m_debug = false;
    boolean m_needsHelp = false;
    static final String LOGIN = "login";
    public static final String HELP_OPT = "help";
    public static final String USER_OPT = "user";
    public static final String PASS_OPT = "pass";
    public static final String LOGOUT_OPT = "logout";
    public static final String TIMEOUT_OPT = "timeout";
    public static final String METHOD_OPT = "method";
    public static final String NS_OPT = "namespace";
    public static final String HOST_OPT = "host";
    static final String OPTS = "h:u:p:l:m:n:o:";
    static final LongOpt[] LONGOPTS = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("user", 1, null, 117), new LongOpt("pass", 1, null, 112), new LongOpt("logout", 2, null, 108), new LongOpt("timeout", 2, null, 116), new LongOpt("method", 1, null, 109), new LongOpt("namespace", 1, null, 110), new LongOpt("host", 1, null, 111)};
    private static final String sccs_id = "@(#)LoginCommand.java 1.20    02/11/13 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$console$login$Messages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$console$login$LoginCommand;

    public LoginCommand(String[] stringArray) {
        super(LOGIN, null, null, null, null);
        this.m_args = stringArray;
    }

    public LoginCommand(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        super(LOGIN, null, null, null, null);
        this.m_req = httpServletRequest;
        this.m_args = LoginCommand.getArgs(httpServletRequest);
    }

    public LoginCommand(String string, String string2, String string3, String string4) {
        super(LOGIN, null, null, null, null);
        this.m_user = string;
        this.m_passwd = string2;
        this.m_host = string3;
        this.m_namespace = string4;
    }

    public Session getSession() {
        return this.m_session;
    }

    public int getOpType() {
        return this.m_opType;
    }

    public void setUser(String string) {
        this.m_user = string;
    }

    public void setPasswd(String string) {
        this.m_passwd = string;
    }

    public void setHostName(String string) {
        this.m_host = string;
    }

    public String getHostName() {
        return this.m_host;
    }

    public void setNameSpace(String string) {
        this.m_namespace = string;
    }

    public String getNameSpace() {
        return this.m_namespace;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPasswd() {
        return this.m_passwd;
    }

    public CmdCompletion execute(String[] stringArray) {
        this.m_args = stringArray;
        this.preExecute();
        if (2 == this.m_opType) {
            if (this.m_timeout) {
                Locale locale = this.m_req.getLocale();
                String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$console$login$Messages == null ? (class$com$sun$netstorage$mgmt$ui$console$login$Messages = LoginCommand.class$("com.sun.netstorage.mgmt.ui.console.login.Messages")) : class$com$sun$netstorage$mgmt$ui$console$login$Messages), (String)"`login.timeout`", (Locale)locale);
                this.validateSession(false, string);
            } else {
                this.validateSession(false, null);
            }
        } else if (this.isCommandValid()) {
            LoginCommand.trace(" u " + this.m_user);
            LoginCommand.trace(" p " + this.m_passwd);
            this.authenticate();
        } else {
            this.m_needsHelp = true;
        }
        return null;
    }

    public void exec() {
        this.execute(this.m_args);
    }

    private final boolean validStorageUser(String string) {
        if (null != string) {
            String[] stringArray = CoreProperties.getUsersList();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public final boolean authenticate() {
        boolean bl;
        boolean bl2 = false;
        String string = null;
        if (this.m_session == null && null != this.m_args) {
            this.preExecute();
        }
        Locale locale = null;
        if (null != this.m_req) {
            locale = this.m_req.getLocale();
        }
        if ((bl = this.validStorageUser(this.m_user)) && this.m_authMethod.equals("CIM")) {
            CIMAuthentication cIMAuthentication = new CIMAuthentication(this.m_host, this.m_namespace);
            int n = cIMAuthentication.authUser(this.m_user, this.m_passwd);
            if (-1 == n) {
                this.logAuthProblem(cIMAuthentication);
                this.logInvalidAttempt(this.m_user);
                string = cIMAuthentication.getAuthenticationFailureMsg(locale);
            } else {
                if (1 == n) {
                    this.logAuthProblem(cIMAuthentication);
                }
                bl2 = true;
            }
        } else {
            this.logInvalidAttempt(this.m_user);
            string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$console$login$Messages == null ? (class$com$sun$netstorage$mgmt$ui$console$login$Messages = LoginCommand.class$("com.sun.netstorage.mgmt.ui.console.login.Messages")) : class$com$sun$netstorage$mgmt$ui$console$login$Messages), (String)"`login.err.inv_user_passwd`", (Locale)locale);
        }
        this.validateSession(bl2, string);
        return bl2;
    }

    private void logInvalidAttempt(String string) {
        this.logMinor("`login.err.inv_login_attempt`", (Serializable[])new String[]{string});
    }

    private void logAuthProblem(CIMAuthentication cIMAuthentication) {
        this.logMinor(cIMAuthentication.getLocalizableFailureMsg());
    }

    public final void validateSession(boolean bl, String string) {
        if (null != this.m_req) {
            this.m_session = (Session)this.m_req.getSession().getAttribute("gothamSessionBean");
            if (null == this.m_session) {
                this.m_session = new Session();
                this.m_req.getSession().setAttribute("gothamSessionBean", (Object)this.m_session);
            }
            this.m_session.setExpired(this.m_timeout);
            this.m_session.setValid(bl);
            this.m_session.setUserName(this.m_user);
        } else {
            this.m_session = new Session();
            this.m_session.setValid(bl);
            this.m_session.setUserName(this.m_user);
        }
        if (!bl && null != this.m_session) {
            this.m_session.setInvalidLoginMsg(string);
        }
    }

    public boolean isCommandValid() {
        return null != this.m_user && null != this.m_passwd;
    }

    public boolean wasSuccessful() {
        return null == this.m_session ? false : this.m_session.isValid();
    }

    public void preExecute() {
        int n;
        Getopt getopt = LoginCommand.getGetopt(this.m_args);
        getopt.setOpterr(true);
        Object var3_2 = null;
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.m_needsHelp = true;
                    LoginCommand.trace("\t help");
                    break;
                }
                case 117: {
                    this.setUser(getopt.getOptarg());
                    LoginCommand.trace("\t user=" + this.getUser());
                    break;
                }
                case 112: {
                    this.setPasswd(getopt.getOptarg());
                    LoginCommand.trace("\t passwd=" + this.getPasswd());
                    break;
                }
                case 108: {
                    this.m_opType = 2;
                    LoginCommand.trace("\t opType=" + this.m_opType);
                    break;
                }
                case 116: {
                    this.m_timeout = true;
                    LoginCommand.trace("\t timout=true");
                    break;
                }
                case 109: {
                    this.m_authMethod = getopt.getOptarg();
                    LoginCommand.trace("\t auth method =" + this.m_authMethod);
                    break;
                }
                case 110: {
                    this.m_namespace = getopt.getOptarg();
                    LoginCommand.trace("\t namespace method =" + this.m_namespace);
                    break;
                }
                case 111: {
                    this.m_host = getopt.getOptarg();
                    LoginCommand.trace("\t host =" + this.m_host);
                    break;
                }
                case 58: {
                    LoginCommand.trace("Doh! You need an argument for option " + (char)getopt.getOptopt());
                    break;
                }
                default: {
                    LoginCommand.trace("The option '" + (char)getopt.getOptopt() + "' is not valid");
                }
            }
        }
    }

    public static Getopt getGetopt(String[] stringArray) {
        return new Getopt(LOGIN, stringArray, OPTS, LONGOPTS);
    }

    public static String[] getArgs(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        Object object;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String[])enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues((String)object);
            LoginCommand.trace(" args " + (String)object);
            LoginCommand.trace(" val  " + stringArray[0]);
            if (object.equals("ID")) {
                object = "sys";
            }
            if (object.equals("FAMILY")) continue;
            vector.addElement(new String("--" + (String)object));
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        object = vector.toArray(new String[vector.size()]);
        return object;
    }

    public static Getopt getGetopt(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        String[] stringArray = LoginCommand.getArgs(httpServletRequest);
        return new Getopt(LOGIN, stringArray, OPTS, LONGOPTS);
    }

    public static String N2OTgetUsageMsg() {
        String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$console$login$LoginCommand == null ? (class$com$sun$netstorage$mgmt$ui$console$login$LoginCommand = LoginCommand.class$("com.sun.netstorage.mgmt.ui.console.login.LoginCommand")) : class$com$sun$netstorage$mgmt$ui$console$login$LoginCommand), (String)"Usage: ");
        return string + LOGIN + " \n" + "\t-h | --" + HELP_OPT + " \n" + "\t-u | --" + USER_OPT + " \n" + "\t-p | --" + PASS_OPT + " \n" + "\t-l | --" + LOGOUT_OPT + " \n" + "\t-n | --" + NS_OPT + " \n" + "\t-o | --" + HOST_OPT + " \n";
    }

    public static void trace(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

