/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.framework;

import com.sun.netstorage.mgmt.locale.LocalizableInfoMessage;
import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.ui.framework.CmdCompletion;
import com.sun.netstorage.mgmt.ui.framework.CmdRetStatus;
import com.sun.netstorage.mgmt.ui.util.alert.AlertMsg;
import com.sun.netstorage.mgmt.ui.util.alert.AlertType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public abstract class ViewBean {
    protected String view = null;
    protected String path = null;
    protected Object vobj = null;
    protected Locale locale = null;
    protected HashMap alerts = new HashMap();
    static final String sccs_id = "@(#)ViewBean.java 1.9    02/11/05 SMI";

    public ViewBean() {
    }

    public ViewBean(String string, String string2, Locale locale) {
        this.view = string;
        this.path = string2;
        this.locale = locale;
    }

    public String getViewName() {
        return this.view;
    }

    public void setViewName(String string) {
        this.view = string;
    }

    public String getViewPath() {
        return this.path;
    }

    public void setViewPath(String string) {
        this.path = string;
    }

    public Object getValueObject() {
        return this.vobj;
    }

    public void setValueObject(Object object) {
        this.vobj = object;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addAlert(AlertMsg alertMsg) {
        Vector vector;
        if (alertMsg == null) {
            return;
        }
        AlertType alertType = alertMsg.getType();
        if (this.alerts.containsKey(alertType)) {
            vector = (Vector)this.alerts.get(alertType);
        } else {
            vector = new Vector();
            this.alerts.put(alertType, vector);
        }
        vector.add(alertMsg);
    }

    public void addErrorAlert(LocalizableMessage localizableMessage, CmdCompletion cmdCompletion) {
        Vector<LocalizableMessage> vector = new Vector<LocalizableMessage>();
        int n = 0;
        while (n < cmdCompletion.size()) {
            LocalizableMessage localizableMessage2;
            CmdRetStatus cmdRetStatus = cmdCompletion.getRetStatus(n);
            if (cmdRetStatus.getReturnCode() != 0 && (localizableMessage2 = cmdRetStatus.getStderr()) != null) {
                vector.add(localizableMessage2);
            }
            ++n;
        }
        if (!vector.isEmpty()) {
            this.addAlert(new AlertMsg(AlertType.ERROR, localizableMessage, vector));
        }
    }

    public void addWarningAlert(CmdCompletion cmdCompletion) {
        LocalizableInfoMessage localizableInfoMessage;
        Object object;
        Vector<LocalizableInfoMessage> vector = new Vector<LocalizableInfoMessage>();
        int n = 0;
        while (n < cmdCompletion.size()) {
            object = cmdCompletion.getRetStatus(n);
            localizableInfoMessage = ((CmdRetStatus)object).getInfoMessages();
            if (localizableInfoMessage != null) {
                int n2 = 0;
                while (n2 < ((LocalizableInfoMessage)localizableInfoMessage).length) {
                    vector.add(localizableInfoMessage[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        object = vector.iterator();
        while (object.hasNext()) {
            localizableInfoMessage = (LocalizableInfoMessage)object.next();
            this.addAlert(new AlertMsg(AlertType.WARNING, localizableInfoMessage.getTitle(), new LocalizableMessage[]{localizableInfoMessage.getMessage()}));
        }
    }

    public AlertMsg[] removeAlertMessages(AlertType alertType) {
        if (!this.alerts.containsKey(alertType)) {
            return new AlertMsg[0];
        }
        Vector vector = (Vector)this.alerts.remove(alertType);
        return vector.toArray(new AlertMsg[vector.size()]);
    }

    public AlertMsg[] getAlertMessages(AlertType alertType) {
        if (!this.alerts.containsKey(alertType)) {
            return new AlertMsg[0];
        }
        Vector vector = (Vector)this.alerts.get(alertType);
        return vector.toArray(new AlertMsg[vector.size()]);
    }

    public String getAlertMessagesAsInlineTag() {
        StringBuffer stringBuffer = new StringBuffer();
        AlertMsg[] alertMsgArray = this.removeAlertMessages(AlertType.ERROR);
        int n = 0;
        while (n < alertMsgArray.length) {
            stringBuffer.append(alertMsgArray[n].getAsInlineMessage(this.locale));
            ++n;
        }
        alertMsgArray = this.removeAlertMessages(AlertType.WARNING);
        int n2 = 0;
        while (n2 < alertMsgArray.length) {
            stringBuffer.append(alertMsgArray[n2].getAsInlineMessage(this.locale));
            ++n2;
        }
        alertMsgArray = this.removeAlertMessages(AlertType.INFO);
        int n3 = 0;
        while (n3 < alertMsgArray.length) {
            stringBuffer.append(alertMsgArray[n3].getAsInlineMessage(this.locale));
            ++n3;
        }
        return stringBuffer.toString();
    }
}

