/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.services.discovery;

import com.sun.netstorage.mgmt.dm.t3.services.discovery.DiscoveryException;
import com.sun.netstorage.mgmt.dm.t3.services.discovery.DiscoveryProcessProperty;
import com.sun.netstorage.mgmt.dm.t3.services.discovery.DiscoveryService;
import com.sun.netstorage.mgmt.dm.t3.services.discovery.DiscoveryServiceImpl;
import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.framework.ViewBean;
import com.sun.netstorage.mgmt.ui.util.LocalizablePropertyData;
import com.sun.netstorage.mgmt.ui.util.PropertyDataModel;
import com.sun.netstorage.mgmt.ui.util.TableUtil;
import com.sun.netstorage.mgmt.ui.util.alert.AlertMsg;
import com.sun.netstorage.mgmt.ui.util.alert.AlertType;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.StringTokenizer;

public class DiscoveryViewBean
extends ViewBean {
    static final String DEFAULT_NAME = "discoveryBean";
    static final String DEFAULT_PATH = "/jsp/services/discovery/discovery.jsp";
    DiscoveryService service = DiscoveryServiceImpl.getInstance();
    int step = 0;
    private final int totalSteps = 4;
    String selection = null;
    String ipAddr = null;
    String startIp = null;
    String endIp = null;
    String cidr = null;
    String passwd = null;
    String confirmPW = null;
    String errMsg = null;
    static final String sccs_id = "@(#)DiscoveryViewBean.java 1.14    02/10/07 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages;

    public DiscoveryViewBean() {
        super(DEFAULT_NAME, DEFAULT_PATH, Locale.getDefault());
    }

    public DiscoveryViewBean(Locale locale) {
        super(DEFAULT_NAME, DEFAULT_PATH, locale);
    }

    public void stopDiscovery() {
        try {
            this.service.shutdown();
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.stop.failTitle", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
        }
    }

    public void startDiscovery() {
        try {
            this.service.start();
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.start.failTitle", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
        }
    }

    public void createCIDRRange(String string, String string2, String string3) {
        try {
            this.service.createCIDRDiscRangeParms(string, string2, string3);
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.taskCreationFailed.title", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
        }
    }

    public void createIpRange(String string, String string2, String string3, String string4) {
        try {
            this.service.createIPDiscRangeParms(string, string2, string3, string4);
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.taskCreationFailed.title", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
        }
    }

    public void deleteCriteria(String string) {
        try {
            this.service.deleteDiscRangeParms(string);
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.remove.task.failedTitle", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
        }
    }

    public void deleteMultiCriteria(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.deleteCriteria(stringArray[n]);
            ++n;
        }
    }

    public String getDiscoveryInventory(Locale locale) {
        Object[][] objectArray;
        String[] stringArray = new String[]{"discovery.header.device.type", "discovery.header.ip.range", "discovery.header.perc.complete", "discovery.header.disc.status"};
        String[] stringArray2 = null;
        DiscoveryProcessProperty[] discoveryProcessPropertyArray = null;
        boolean bl = true;
        String string = "discovery.msg.no.setting";
        try {
            discoveryProcessPropertyArray = this.service.getDiscoveryProcProperties();
        }
        catch (DiscoveryException discoveryException) {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages, "discovery.tableCreationFailed.title", new Serializable[0]);
            AlertMsg alertMsg = new AlertMsg(AlertType.ERROR, localizableMessage, discoveryException.getLocalizableMessage());
            this.addAlert(alertMsg);
            string = "discovery.msg.no.setting.cimdown";
        }
        if (discoveryProcessPropertyArray != null && discoveryProcessPropertyArray.length != 0) {
            int n = discoveryProcessPropertyArray.length;
            objectArray = new String[n][4];
            stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = discoveryProcessPropertyArray[n2].getHandleValue();
                objectArray[n2][0] = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages") : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages), (String)"discovery.wizard.sun_array_type", (Locale)locale);
                objectArray[n2][1] = discoveryProcessPropertyArray[n2].getParamsValue();
                objectArray[n2][2] = discoveryProcessPropertyArray[n2].getPercentCompleteValue();
                objectArray[n2][3] = discoveryProcessPropertyArray[n2].getDiscoveryStateValue();
                ++n2;
            }
        } else {
            objectArray = new String[1][4];
            objectArray[0][0] = " ";
            objectArray[0][1] = "discovery.msg.no.setting";
            objectArray[0][2] = " ";
            objectArray[0][3] = " ";
            bl = false;
        }
        PropertyDataModel propertyDataModel = new PropertyDataModel("Discovery", stringArray, objectArray, (Object)(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages = DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages")) : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages));
        propertyDataModel.setColumnAlignmentData(new int[]{2, 2, 2, 2});
        LocalizablePropertyData localizablePropertyData = new LocalizablePropertyData(propertyDataModel);
        propertyDataModel = localizablePropertyData.toPropertyDataModel(locale);
        if (bl) {
            return TableUtil.getCheckboxedSortTable(propertyDataModel, "ID", stringArray2);
        }
        return TableUtil.getSortTable(propertyDataModel);
    }

    public String[] getSupportedDeviceTypes() {
        return new String[]{"T3"};
    }

    public String getSelectedDeviceType() {
        return "T3";
    }

    public String[] getStepDescription() {
        return this.getStepDescription(Locale.getDefault());
    }

    public String[] getStepDescription(Locale locale) {
        String[] stringArray = new String[4];
        int n = 0;
        while (n < 4) {
            stringArray[n] = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages == null ? DiscoveryViewBean.class$("com.sun.netstorage.mgmt.ui.services.discovery.DiscoveryMessages") : class$com$sun$netstorage$mgmt$ui$services$discovery$DiscoveryMessages), (String)("discovery.step" + (n + 1)), (Locale)locale);
            ++n;
        }
        return stringArray;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String string) {
        this.selection = string;
    }

    public String getIPAddress() {
        return this.ipAddr;
    }

    public void setIPAddress(String string) {
        this.ipAddr = string;
    }

    public String getStartIP() {
        return this.startIp;
    }

    public void setStartIP(String string) {
        this.startIp = string;
    }

    public String getEndIP() {
        return this.endIp;
    }

    public void setEndIP(String string) {
        this.endIp = string;
    }

    public String getCIDRAddress() {
        return this.cidr;
    }

    public void setCIDRAddress(String string) {
        this.cidr = string;
    }

    public String getPassword() {
        return this.passwd;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    public String getConfirmPassword() {
        return this.confirmPW;
    }

    public void setConfirmPassword(String string) {
        this.confirmPW = string;
    }

    public void setErrorMessage(String string) {
        this.errMsg = string;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public static boolean isValidIP(String string) {
        return DiscoveryViewBean.isValidHostName(string) || DiscoveryViewBean.isValidIPv4(string);
    }

    public static boolean isValidHostName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() < 1) {
            return false;
        }
        char c = string2.charAt(0);
        if ('a' <= c && 'z' <= c || 'A' <= c && 'Z' <= c) {
            int n = 0;
            while (n < string2.length()) {
                c = string2.charAt(n);
                if (!('a' <= c && 'z' <= c || 'A' <= c && 'Z' <= c || '.' != c)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidIPv4(String var0) {
        if (var0 == null) {
            return false;
        }
        var1_1 = var0.trim();
        var2_2 = new StringTokenizer(var1_1, new String("."));
        if (var2_2.countTokens() == 4) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.nextToken();
            try {
                var4_4 = Integer.parseInt(var3_3);
                if (0 > var4_4 || var4_4 > 255) {
                    return false;
                }
                continue;
            }
            catch (NumberFormatException var4_5) {
                return false;
            }
lbl15:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl16:
        // 1 sources

        return true;
    }

    public static boolean isValidCIDR(String string) {
        String string2 = string.trim();
        int n = string2.indexOf(47);
        if (n < 0) {
            return false;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        if (!DiscoveryViewBean.isValidIPv4(string3)) {
            return false;
        }
        try {
            int n2 = Integer.parseInt(string4);
            return 0 <= n2 && n2 <= 32;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getHostAddress(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

