/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.services.util;

import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.services.util.AlignmentConstants;
import com.sun.netstorage.mgmt.ui.services.util.TableColumn;
import com.sun.netstorage.mgmt.ui.util.ChainedException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class HTMLTags
implements AlignmentConstants {
    static final Class BUNDLE = class$com$sun$netstorage$mgmt$ui$services$util$HTMLTags == null ? (class$com$sun$netstorage$mgmt$ui$services$util$HTMLTags = HTMLTags.class$("com.sun.netstorage.mgmt.ui.services.util.HTMLTags")) : class$com$sun$netstorage$mgmt$ui$services$util$HTMLTags;
    private static final String PAGE_NUMBER = "pageNum";
    private static final int PAGE_NUMBER_DEFAULT = -222;
    private static final String SORT_COLUMN = "sortBy";
    private static final String FIRST_ROW = "tableIndex";
    private static final int FIRST_ROW_DEFAULT = 0;
    private static final String PAGE_SIZE = "tableSize";
    private static final int PAGE_SIZE_DEFAULT = 25;
    private static final int MAX_ACTION_BUTTONS = 3;
    public static final String ALARM_NONE = "";
    public static final String ALARM_MINOR = "minor";
    public static final String ALARM_MAJOR = "major";
    public static final String ALARM_CRITICAL = "critical";
    public static final String ALARM_DOWN = "down";
    public static final String GO_BUTTON = "tablePagingGo";
    public static final String ACTIONS_MENU = "actionsMenu";
    public static final String MESSAGE_INFO = "infoMessages";
    public static final String MESSAGE_WARNING = "warningMessages";
    public static final String MESSAGE_ERROR = "errorMessages";
    static final String MESSAGE_EXCEPTION = "exceptionMessages";
    private static final String TIMESTAMPS = "timestamps";
    static final String PROFILING = "profiling";
    private static final String CRUMB_URL = "crumb.url.";
    private static final String CRUMB_TEXT = "crumb.text.";
    public static final String CONTENT_FORM = "contentForm";
    public static final String WRAP_OFF = "off";
    public static final String WRAP_VIRTUAL = "virtual";
    public static final String WRAP_PHYSICAL = "physical";
    static final String sccs_id = "@(#)HTMLTags.java 1.9    03/01/08 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$services$util$HTMLTags;

    public static String getCustomTag(Class clazz, String string, Locale locale) {
        return Localize.getString((Object)clazz, (String)string, (Locale)locale);
    }

    public static String[] getCustomTags(Class clazz, String[] stringArray, Locale locale) {
        return new String[]{"TODO - Remind Jeff to implement getCustomTags()"};
    }

    public static String getSectionHeaderStartTag(String string, Locale locale) {
        return HTMLTags.getTag("sectionHeaderStart", string, locale);
    }

    public static String getSectionHeaderEndTag(Locale locale) {
        return HTMLTags.getTag("sectionHeaderEnd", locale);
    }

    public static String getBreadCrumbTag(String string) {
        return "deprecated crumb for " + string;
    }

    public static void setBreadCrumbData(HttpSession httpSession, String string, String string2, String string3) {
        if (string2 != null) {
            httpSession.setAttribute(CRUMB_URL + string, (Object)string2);
        } else {
            httpSession.removeAttribute(CRUMB_URL + string);
        }
        if (string3 != null) {
            httpSession.setAttribute(CRUMB_TEXT + string, (Object)string3);
        } else {
            httpSession.removeAttribute(CRUMB_TEXT + string);
        }
    }

    public static String getLinkTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<a href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        stringBuffer.append(string2);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public static String getEmailLinkTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<a href=\"mailto:");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        stringBuffer.append(string2);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public static String getLinkButtonTag(String string, String string2, Locale locale) {
        return HTMLTags.getTag("textButton", new String[]{string, string2}, locale);
    }

    public static String getDisabledButtonTag(String string, Locale locale) {
        return HTMLTags.getTag("disabledButton", string, locale);
    }

    public static String getFormSubmitter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("submitcontrol");
        if (ACTIONS_MENU.equals(string)) {
            string = httpServletRequest.getParameter(ACTIONS_MENU);
        }
        return string;
    }

    public static String getSubmitButtonTag(String string, String string2, Locale locale) {
        String string3 = "javascript:document.contentForm.submitcontrol.value = '" + string + "'; document.contentForm.submit()";
        string3 = string3 + "\" title=\"" + string2;
        string3 = string3 + "\" onkeypress=\"" + string3;
        return HTMLTags.getLinkButtonTag(string3, string2, locale);
    }

    public static String getResetButtonTag(String string, Locale locale) {
        return HTMLTags.getLinkButtonTag("javascript:document.contentForm.reset()", string, locale);
    }

    public static String getSelectionButtonsTag(String string, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTMLTags.getTag("selectionScript", locale));
        stringBuffer.append(HTMLTags.getTag("selectionButtons", string, locale));
        return stringBuffer.toString();
    }

    public static String getInputFieldTag(String string, String string2, int n, int n2) {
        return HTMLTags.getInputTag("text", string, string2, n, n2, false);
    }

    public static String getInputPasswordTag(String string, String string2, int n, int n2) {
        return HTMLTags.getInputTag("password", string, string2, n, n2, false);
    }

    public static String getInputCheckboxTag(String string, String string2, boolean bl) {
        return HTMLTags.getInputTag("checkbox", string, string2, 0, 0, bl);
    }

    public static String getInputRadioButtonTag(String string, String string2, boolean bl) {
        return HTMLTags.getInputTag("radio", string, string2, 0, 0, bl);
    }

    private static String getInputTag(String string, String string2, String string3, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<input type=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (string2 != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        if (string3 != null) {
            stringBuffer.append(" value=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        if (n > 0) {
            stringBuffer.append(" size=\"");
            stringBuffer.append(n);
            stringBuffer.append('\"');
        }
        if (n2 > 0) {
            stringBuffer.append(" maxlength=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (bl) {
            stringBuffer.append(" checked");
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String getTextAreaTag(String string, String string2, int n, int n2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<textarea");
        if (string != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        if (n > 0) {
            stringBuffer.append(" rows=\"");
            stringBuffer.append(n);
            stringBuffer.append('\"');
        }
        if (n2 > 0) {
            stringBuffer.append(" cols=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (string3 != null) {
            stringBuffer.append(" wrap=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        stringBuffer.append(">");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("</textarea>\n");
        return stringBuffer.toString();
    }

    public static String getInfoBoxTag(String string, Locale locale) {
        return HTMLTags.getTag("messageBox", new String[]{HTMLTags.getTag("infoIcon", locale), string}, locale);
    }

    public static String getWarningBoxTag(String string, Locale locale) {
        return HTMLTags.getTag("messageBox", new String[]{HTMLTags.getTag("warningIcon", locale), string}, locale);
    }

    public static String getErrorBoxTag(String string, Locale locale) {
        return HTMLTags.getTag("messageBox", new String[]{HTMLTags.getTag("errorIcon", locale), string}, locale);
    }

    public static String getExceptionBoxTag(HttpServletRequest httpServletRequest, String string, Throwable throwable, Locale locale) {
        if (throwable == null) {
            return ALARM_NONE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTMLTags.getTag("exceptionMessage", throwable.getMessage(), locale));
        if (httpServletRequest != null) {
            String string2 = HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString());
            stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuffer.append(HTMLTags.getLinkTag("/exception?page=" + string, HTMLTags.getTag("exceptionDetail", locale)));
            HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_EXCEPTION);
            Throwable throwable2 = throwable;
            while (throwable2 != null) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(HTMLTags.getTag("exceptionMessage", throwable2.getMessage(), locale));
                stringBuffer2.append("\n<blockquote><pre>");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                throwable2.printStackTrace(new PrintStream(byteArrayOutputStream));
                stringBuffer2.append(byteArrayOutputStream.toString());
                System.err.println(byteArrayOutputStream.toString());
                stringBuffer2.append("</pre></blockquote>");
                HTMLTags.addPendingMessage(httpServletRequest, MESSAGE_EXCEPTION, stringBuffer2.toString());
                throwable2 = throwable2 instanceof ChainedException ? ((ChainedException)throwable2).getCause() : (throwable2 instanceof ServletException ? ((ServletException)throwable2).getRootCause() : (throwable2 instanceof RemoteException ? ((RemoteException)throwable2).detail : null));
            }
        }
        return HTMLTags.getErrorBoxTag(stringBuffer.toString(), locale);
    }

    public static void addPendingMessage(HttpServletRequest httpServletRequest, String string, String string2) {
        if (string2 == null) {
            return;
        }
        String[] stringArray = HTMLTags.getPendingMessages(httpServletRequest, string);
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string2;
        httpServletRequest.getSession().setAttribute(string, (Object)stringArray2);
    }

    public static String[] removePendingMessages(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray = HTMLTags.getPendingMessages(httpServletRequest, string);
        httpServletRequest.getSession().removeAttribute(string);
        return stringArray;
    }

    public static String[] getPendingMessages(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray = new String[]{};
        Object object = httpServletRequest.getSession().getAttribute(string);
        if (object != null && stringArray.getClass().isAssignableFrom(object.getClass())) {
            return (String[])object;
        }
        return new String[0];
    }

    public static String getPendingMessagesTag(HttpServletRequest httpServletRequest, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_ERROR);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(HTMLTags.getErrorBoxTag(stringArray[n], locale));
            ++n;
        }
        String[] stringArray2 = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_WARNING);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringBuffer.append(HTMLTags.getWarningBoxTag(stringArray2[n2], locale));
            ++n2;
        }
        String[] stringArray3 = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_INFO);
        int n3 = 0;
        while (n3 < stringArray3.length) {
            stringBuffer.append(HTMLTags.getInfoBoxTag(stringArray3[n3], locale));
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static boolean isProfilingOn(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameter(PROFILING) != null || "true".equals(httpServletRequest.getSession().getAttribute(PROFILING));
    }

    public static void addTimestamp(HttpServletRequest httpServletRequest, String string) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return;
        }
        Timestamp[] timestampArray = HTMLTags.getTimestamps(httpServletRequest);
        Timestamp[] timestampArray2 = new Timestamp[timestampArray.length + 1];
        System.arraycopy(timestampArray, 0, timestampArray2, 0, timestampArray.length);
        timestampArray2[timestampArray.length] = new Timestamp(string);
        httpServletRequest.setAttribute(TIMESTAMPS, (Object)timestampArray2);
    }

    public static Timestamp[] getTimestamps(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return null;
        }
        Timestamp[] timestampArray = new Timestamp[]{};
        Object object = httpServletRequest.getAttribute(TIMESTAMPS);
        if (object != null && timestampArray.getClass().isAssignableFrom(object.getClass())) {
            return (Timestamp[])object;
        }
        return new Timestamp[0];
    }

    public static Timestamp[] removeTimestamps(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return null;
        }
        Timestamp[] timestampArray = HTMLTags.getTimestamps(httpServletRequest);
        httpServletRequest.removeAttribute(TIMESTAMPS);
        return timestampArray;
    }

    public static String getTimestampTags(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return ALARM_NONE;
        }
        Timestamp[] timestampArray = HTMLTags.removeTimestamps(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<br><table>\n");
        long l = 0L;
        Timestamp timestamp = new Timestamp("end");
        int n = 0;
        while (n <= timestampArray.length) {
            Timestamp timestamp2 = n < timestampArray.length ? timestampArray[n] : timestamp;
            stringBuffer.append("<tr><td align=right><font size=-1 color=red>");
            if (l == 0L) {
                stringBuffer.append("Profiling: ");
                stringBuffer.append(DateFormat.getTimeInstance().format(new Date(timestamp2.time)));
            } else {
                stringBuffer.append(timestamp2.time - l);
                stringBuffer.append(" ms");
            }
            stringBuffer.append(" </font></td><td align=left><font size=-1 color=red> ");
            stringBuffer.append(timestamp2.message);
            stringBuffer.append("</font></td></tr>\n");
            l = timestamp2.time;
            ++n;
        }
        if (timestampArray.length > 0) {
            stringBuffer.append("<tr><td align=right><font size=-1 color=red>Total = ");
            stringBuffer.append(timestamp.time - timestampArray[0].time);
            stringBuffer.append(" ms </font></td></tr>");
        }
        stringBuffer.append("</table></font>");
        return stringBuffer.toString();
    }

    public static String getStatusImageTag(String string, Locale locale) {
        return HTMLTags.getAlarmImageTag(HTMLTags.statusToAlarm(string), locale);
    }

    public static String getAlarmImageTag(String string, Locale locale) {
        if (string == null || string.length() == 0) {
            return ALARM_NONE;
        }
        String string2 = "alarmIcon." + string;
        String string3 = HTMLTags.getTag(string2, locale);
        if (string3 == null || !string3.equals(string2)) {
            return ALARM_NONE;
        }
        return string3;
    }

    public static String statusToAlarm(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).equals("error") || string.equals("nonRecover")) {
                return ALARM_DOWN;
            }
            if (string.equals("lostComm")) {
                return ALARM_CRITICAL;
            }
            if (string.equals("degraded") || string.equals("predFail") || string.equals("noContact")) {
                return ALARM_MAJOR;
            }
            if (string.equals("stressed") || string.equals("stopped") || string.equals("stopping") || string.equals("starting") || string.equals("service")) {
                return ALARM_MINOR;
            }
        }
        return ALARM_NONE;
    }

    public static String getImageTag(Class clazz, String string, Locale locale) {
        String string2 = Localize.getString((Object)clazz, (String)(string + ".url"), (Locale)locale);
        if (string2.endsWith(".url")) {
            return HTMLTags.getImageTag(ALARM_NONE, 0, 0, string);
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(Localize.getString((Object)clazz, (String)(string + ".width"), (Locale)locale));
            n2 = Integer.parseInt(Localize.getString((Object)clazz, (String)(string + ".height"), (Locale)locale));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string3 = Localize.getString((Object)clazz, (String)(string + ".text"), (Locale)locale);
        if (string3.endsWith(".text")) {
            string3 = null;
        }
        return HTMLTags.getImageTag(string2, n, n2, string3);
    }

    private static String getImageTag(String string, int n, int n2, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<img src=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (n > 0 && n2 > 0) {
            stringBuffer.append(" width=\"");
            stringBuffer.append(n);
            stringBuffer.append("\" height=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (string2 != null) {
            stringBuffer.append(" alt=\"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String getListTag(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(bl ? "<ol>" : "<ul>");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("\n  <li>");
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        stringBuffer.append(bl ? "\n</ol>\n" : "\n</ul>\n");
        return stringBuffer.toString();
    }

    public static String getTableTitleTag(String string, Locale locale) {
        return HTMLTags.getTag("tableTitle", string, locale);
    }

    public static String getTableTitleTag(String string, int n, int n2, int n3, Locale locale) {
        if (n == 0 && n2 <= n3 && n3 <= 25) {
            return HTMLTags.getTableTitleTag(string, locale);
        }
        return HTMLTags.getTag("tableTitle", HTMLTags.getTag("tablePagingTitle", new String[]{string, Integer.toString(n + 1), Integer.toString(Math.min(n + n3, n2)), Integer.toString(n2)}, locale), locale);
    }

    public static String getTableTag(String string, TableColumn[] tableColumnArray, String[][] stringArray, int n, int n2, int n3, int n4, Locale locale) {
        boolean bl;
        int n5;
        int n6;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTMLTags.getTag("tableStart", locale));
        if (tableColumnArray != null) {
            boolean bl2 = false;
            stringBuffer.append(HTMLTags.getTag("tableHeaderRow", locale));
            int n7 = 0;
            while (n7 < tableColumnArray.length) {
                stringBuffer.append(HTMLTags.getTag("tableHeaderWithMarkup", new String[]{tableColumnArray[n7].title, tableColumnArray[n7].alignment}, locale));
                if (tableColumnArray[n7].sortable) {
                    bl2 = true;
                }
                ++n7;
            }
            stringBuffer.append("</tr>");
            if (bl2 && stringArray != null && stringArray.length > 0) {
                stringBuffer.append(HTMLTags.getTag("tableSortRow", locale));
                n6 = 0;
                while (n6 < tableColumnArray.length) {
                    if (tableColumnArray[n6].sortable) {
                        n5 = n6 + 1;
                        stringBuffer.append(HTMLTags.getTag("tableSort", new String[]{tableColumnArray[n6].alignment, n == n5 ? HTMLTags.getTag("sortAscendSelect", locale) : HTMLTags.getTag("sortAscend", HTMLTags.getTableURL(string, n5, n2, n4), locale), n == -n5 ? HTMLTags.getTag("sortDescendSelect", locale) : HTMLTags.getTag("sortDescend", HTMLTags.getTableURL(string, -n5, n2, n4), locale)}, locale));
                    } else {
                        stringBuffer.append(HTMLTags.getTag("tableSortEmpty", locale));
                    }
                    ++n6;
                }
                stringBuffer.append("</tr>");
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            String string2 = HTMLTags.getTag("tableDataRow", locale);
            String string3 = HTMLTags.getTag("tableDataRowDivider", Integer.toString(tableColumnArray != null ? tableColumnArray.length : (stringArray[0] != null ? stringArray[0].length : 1)), locale);
            n6 = 0;
            while (n6 < stringArray.length) {
                if (n6 > 0) {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(string2);
                n5 = 0;
                while (n5 < stringArray[n6].length) {
                    String string4;
                    String string5 = "\"left\"";
                    if (tableColumnArray != null && n5 < tableColumnArray.length) {
                        string5 = tableColumnArray[n5].alignment;
                    }
                    if ((string4 = stringArray[n6][n5]) == null || string4.length() == 0) {
                        string4 = "&nbsp;";
                    }
                    stringBuffer.append(n5 == 0 ? HTMLTags.getTag("tableDataWithMarkup", new String[]{string4, string5}, locale) : HTMLTags.getTag("tableData", new String[]{string4, string5}, locale));
                    ++n5;
                }
                stringBuffer.append("</tr>\n");
                ++n6;
            }
        } else if (tableColumnArray != null && tableColumnArray.length > 0) {
            stringBuffer.append(HTMLTags.getTag("tableEmptyRowWithMarkup", Integer.toString(tableColumnArray.length), locale));
        }
        stringBuffer.append(HTMLTags.getTag("tableEnd", locale));
        if (n4 < 1) {
            n4 = 25;
        }
        int n8 = n2 == 0 ? 0 : (n2 - 1) / n4 + 1;
        boolean bl3 = bl = n2 == 0 && n3 == n4;
        if (bl) {
            n4 = 25;
        }
        if ((n6 = n8 + (int)Math.ceil((double)(n3 - n2) / (double)n4)) > 1) {
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(SORT_COLUMN);
            stringBuffer.append(" value=");
            stringBuffer.append(n);
            stringBuffer.append(">\n");
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(FIRST_ROW);
            stringBuffer.append(" value=");
            stringBuffer.append(n2);
            stringBuffer.append(">\n");
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(PAGE_SIZE);
            stringBuffer.append(" value=");
            stringBuffer.append(n4);
            stringBuffer.append(">\n");
            stringBuffer.append(HTMLTags.getTag("tablePaging", new String[]{n8 == 0 ? HTMLTags.getTag("firstPageDisabled", locale) : HTMLTags.getTag("firstPage", HTMLTags.getTableURL(string, n, 0, n4), locale), n8 == 0 ? HTMLTags.getTag("prevPageDisabled", locale) : HTMLTags.getTag("prevPage", HTMLTags.getTableURL(string, n, Math.max(n2 - n4, 0), n4), locale), Integer.toString(n8 + 1), Integer.toString(n6), HTMLTags.getSubmitButtonTag(GO_BUTTON, HTMLTags.getTag(GO_BUTTON, locale), locale), n8 + 1 < n6 && !bl ? HTMLTags.getTag("nextPage", HTMLTags.getTableURL(string, n, n2 + n4, n4), locale) : HTMLTags.getTag("nextPageDisabled", locale), n8 + 1 < n6 && !bl ? HTMLTags.getTag("lastPage", HTMLTags.getTableURL(string, n, n2 + n4 * (n6 - (n8 + 1)), n4), locale) : HTMLTags.getTag("lastPageDisabled", locale), HTMLTags.getLinkButtonTag(HTMLTags.getTableURL(string, n, 0, n3), HTMLTags.getTag("tablePagingShowAllRows", locale), locale), Integer.toString(Integer.toString(n6).length())}, locale));
        }
        return stringBuffer.toString();
    }

    public static String getTableURL(String string, int n, int n2, int n3) {
        String string2 = HTMLTags.modifyURLParameter(string, SORT_COLUMN, Integer.toString(n));
        string2 = HTMLTags.modifyURLParameter(string2, FIRST_ROW, Integer.toString(n2));
        string2 = HTMLTags.modifyURLParameter(string2, PAGE_SIZE, Integer.toString(n3));
        return string2;
    }

    public static TableInfo getTableInfo(HttpServletRequest httpServletRequest, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n6 = HTMLTags.stringToInt(httpServletRequest.getParameter(SORT_COLUMN), n)) == 0) {
            n6 = n;
        }
        if ((n5 = HTMLTags.stringToInt(httpServletRequest.getParameter(FIRST_ROW), 0)) <= 0 || n5 > n2) {
            n5 = 0;
        }
        if ((n4 = HTMLTags.stringToInt(httpServletRequest.getParameter(PAGE_SIZE), 25)) <= 0) {
            n4 = 25;
        }
        if (GO_BUTTON.equals(HTMLTags.getFormSubmitter(httpServletRequest)) && (n3 = HTMLTags.stringToInt(httpServletRequest.getParameter(PAGE_NUMBER), -222)) != -222) {
            int n7 = (n3 - 1) * n4 + n5 % n4;
            return new TableInfo(n6, n7 < 0 || n7 >= n2 ? 0 : n7, n4);
        }
        return new TableInfo(n6, n5, n4);
    }

    public static int getTableSortColumn(HttpServletRequest httpServletRequest, int n) {
        return HTMLTags.stringToInt(httpServletRequest.getParameter(SORT_COLUMN), n);
    }

    public static String getContentStartTags(String string, Locale locale) {
        return HTMLTags.getTag("contentStart", new String[]{string, HTMLTags.getTag("formScripts", locale)}, locale);
    }

    public static String getContentSubSectionTags(String string, Locale locale) {
        return HTMLTags.getTag("contentSeparator", string, locale);
    }

    public static String getContentEndTags(Locale locale) {
        return HTMLTags.getTag("contentEnd", locale);
    }

    public static String getMenuTag(Class clazz, String string, String[] stringArray, String string2, Locale locale) {
        return HTMLTags.getMenuTag(clazz, string, stringArray, string2, false, locale);
    }

    public static String getActionButtonsTag(Class clazz, String string, String[] stringArray, Locale locale) {
        return HTMLTags.getActionButtonsTag(clazz, string, stringArray, null, locale);
    }

    public static String getActionButtonsTag(Class clazz, String string, String[] stringArray, boolean[] blArray, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Localize.getString((Object)BUNDLE, (String)"actionTagsStart", (Locale)locale));
        int n = stringArray.length <= 3 ? stringArray.length : 2;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray != null && n2 < blArray.length && !blArray[n2];
            String string2 = clazz == null ? stringArray[n2] : Localize.getString((Object)clazz, (String)stringArray[n2], (Locale)locale);
            stringBuffer.append(Localize.getString((Object)BUNDLE, (String)"actionItem", (Object)(bl ? HTMLTags.getDisabledButtonTag(string2, locale) : HTMLTags.getSubmitButtonTag(stringArray[n2], string2, locale))));
            ++n2;
        }
        if (n2 < stringArray.length) {
            String[] stringArray2 = new String[stringArray.length - n2 + 1];
            stringArray2[0] = string;
            System.arraycopy(stringArray, n2, stringArray2, 1, stringArray.length - n2);
            stringBuffer.append(Localize.getString((Object)BUNDLE, (String)"actionItem", (Object)HTMLTags.getSubmitMenuTag(clazz, ACTIONS_MENU, stringArray2, string, locale)));
        }
        stringBuffer.append(Localize.getString((Object)BUNDLE, (String)"actionTagsEnd", (Locale)locale));
        return stringBuffer.toString();
    }

    public static String getSubmitMenuTag(Class clazz, String string, String[] stringArray, String string2, Locale locale) {
        return HTMLTags.getMenuTag(clazz, string, stringArray, string2, true, locale);
    }

    public static String getMenuTag(Class clazz, String string, String[] stringArray, String string2, boolean bl, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<select name=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(" onChange=\"document.contentForm.submitcontrol.value = '" + string + "';");
            stringBuffer.append(" document.contentForm.submit();\"");
        }
        stringBuffer.append(">\n");
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n] != null ? stringArray[n] : ALARM_NONE;
            stringBuffer.append("  <option value=\"");
            stringBuffer.append(string3);
            if (string3.equals(string2) && string3.length() > 0) {
                stringBuffer.append("\" selected>");
            } else {
                stringBuffer.append("\">");
            }
            if (string3.length() == 0 || clazz == null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(Localize.getString((Object)clazz, (String)string3, (Locale)locale));
            }
            stringBuffer.append("</option>\n");
            ++n;
        }
        stringBuffer.append("</select>\n");
        return stringBuffer.toString();
    }

    public static String createURL(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String modifyURLParameter(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?&");
        String string4 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith(string2 + "=")) continue;
            stringBuffer.append('&');
            stringBuffer.append(string5);
        }
        if (string3 != null) {
            stringBuffer.append('&');
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string3));
        }
        return stringBuffer.length() == 0 ? string4 : HTMLTags.createURL(string4, stringBuffer.substring(1));
    }

    public static String getSubmitFormJavascriptTag(Locale locale) {
        return HTMLTags.getTag("formScripts", locale);
    }

    private static String getTag(String string, Locale locale) {
        return Localize.getString((Object)BUNDLE, (String)string, (Locale)locale);
    }

    private static String getTag(String string, Object object, Locale locale) {
        Object[] objectArray = new Object[]{object};
        return Localize.getString((Object)BUNDLE, (String)string, (Object[])objectArray, (Locale)locale);
    }

    private static String getTag(String string, Object[] objectArray, Locale locale) {
        return Localize.getString((Object)BUNDLE, (String)string, (Object[])objectArray, (Locale)locale);
    }

    public static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String trimTags(String string) {
        if (string == null) {
            return ALARM_NONE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("<".equals(string2)) {
                ++n;
                continue;
            }
            if (">".equals(string2)) {
                n = Math.max(n - 1, 0);
                continue;
            }
            if (n != 0) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Timestamp {
        public final String message;
        public final long time;

        private Timestamp(String string) {
            this.message = string;
            this.time = System.currentTimeMillis();
        }
    }

    public static final class TableInfo {
        public static final int NO_SORT_COLUMN = 0;
        public final int firstRow;
        public final int pageSize;
        public final int sortColumn;

        TableInfo(int n, int n2, int n3) {
            this.firstRow = n2;
            this.pageSize = n3;
            this.sortColumn = n;
        }
    }
}

