/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.util;

import com.sun.netstorage.mgmt.ui.util.HTMLDoc;
import com.sun.netstorage.mgmt.ui.util.HTMLTextable;
import com.sun.netstorage.mgmt.ui.util.StringPair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HTMLTag
implements HTMLTextable {
    protected Document doc = HTMLDoc.createDocument();
    protected HTMLTag parent;
    protected HTMLTag wrappee;
    protected Element root;

    protected HTMLTag(String string) {
        this.root = this.doc.createElement(string);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getTagName() {
        return this.root.getTagName();
    }

    public Element getElement() {
        return this.root;
    }

    public void setText(String string) {
        this.root.appendChild(this.doc.createTextNode(string));
    }

    public void setAttribute(String string, String string2) {
        this.root.setAttribute(string, string2);
    }

    public void setAttributes(StringPair[] stringPairArray) {
        int n = 0;
        while (n < stringPairArray.length) {
            this.root.setAttribute(stringPairArray[n].getName(), stringPairArray[n].getValue());
            ++n;
        }
    }

    public static void setAttributes(Element element, StringPair[] stringPairArray) {
        int n = 0;
        while (n < stringPairArray.length) {
            element.setAttribute(stringPairArray[n].getName(), stringPairArray[n].getValue());
            ++n;
        }
    }

    public void appendChild(HTMLTag hTMLTag) {
        Node node = this.doc.importNode(hTMLTag.getElement(), true);
        this.root.appendChild(node);
        hTMLTag.parent = this;
    }

    public void appendChildElement(Element element) {
        this.root.appendChild(element);
    }

    public void importChildElement(Element element) {
        this.root.appendChild(this.doc.importNode(element, true));
    }

    public String toHtml() {
        if (this.root != null) {
            return HTMLDoc.elementToString(this.root);
        }
        return "";
    }
}

