/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.util.alert;

import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.ui.util.alert.AlertType;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class AlertMsg {
    public static final String INFO_TITLE_SUFFIX = ".infoAlert.title";
    public static final String INFO_SUFFIX = ".infoAlert";
    public static final String WARNING_TITLE_SUFFIX = ".warningAlert.title";
    public static final String WARNING_SUFFIX = ".warningAlert";
    public static final String ERROR_TITLE_SUFFIX = ".errorAlert.title";
    public static final String ERROR_SUFFIX = ".errorAlert";
    private Vector msgs = new Vector();
    private LocalizableMessage title;
    private AlertType type;
    private static final String sccs_id = "@(#)AlertMsg.java 1.5    02/05/20 SMI";

    public AlertMsg(AlertType alertType) {
        this.type = alertType;
    }

    public AlertMsg(AlertType alertType, LocalizableMessage localizableMessage, LocalizableMessage[] localizableMessageArray) {
        this(alertType);
        this.title = localizableMessage;
        if (localizableMessageArray != null) {
            int n = 0;
            while (n < localizableMessageArray.length) {
                this.msgs.add(localizableMessageArray[n]);
                ++n;
            }
        }
    }

    public AlertMsg(AlertType alertType, LocalizableMessage localizableMessage, LocalizableMessage localizableMessage2) {
        this(alertType);
        this.title = localizableMessage;
        this.msgs.add(localizableMessage2);
    }

    public AlertMsg(AlertType alertType, Class clazz, String string, Serializable[] serializableArray, String string2, Serializable[] serializableArray2) {
        this(alertType);
        this.title = new LocalizableMessage(clazz, string, serializableArray);
        this.msgs.add(new LocalizableMessage(clazz, string2, serializableArray2));
    }

    public AlertMsg(AlertType alertType, Class clazz, String string, String string2) {
        this(alertType, clazz, string, new Serializable[0], string2, new Serializable[0]);
    }

    public AlertMsg(AlertType alertType, LocalizableMessage localizableMessage, Vector vector) {
        this(alertType);
        this.title = localizableMessage;
        this.msgs = vector;
    }

    public AlertType getType() {
        return this.type;
    }

    public LocalizableMessage getTitle() {
        return this.title;
    }

    public void setTitle(LocalizableMessage localizableMessage) {
        this.title = localizableMessage;
    }

    public LocalizableMessage[] getMessages() {
        if (this.msgs.isEmpty()) {
            return new LocalizableMessage[0];
        }
        return this.msgs.toArray(new LocalizableMessage[this.msgs.size()]);
    }

    public void addMessage(LocalizableMessage localizableMessage) {
        this.msgs.add(localizableMessage);
    }

    public String getAsInlineMessage(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        LocalizableMessage[] localizableMessageArray = this.getMessages();
        int n = 0;
        while (n < localizableMessageArray.length) {
            stringBuffer.append(localizableMessageArray[n].getLocalizedText(locale) + "<br>");
            ++n;
        }
        int n2 = stringBuffer.toString().indexOf("\n");
        while (n2 > 0) {
            stringBuffer.replace(n2, n2 + 1, "<br>");
            n2 = stringBuffer.toString().indexOf("\n");
        }
        return this.type.getInlineTag(this.title.getLocalizedText(locale), stringBuffer.toString(), locale);
    }

    public String toString() {
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.title != null) {
            stringBuffer.append(this.title.getLocalizedText(locale) + "\n\n");
        }
        LocalizableMessage[] localizableMessageArray = this.getMessages();
        int n = 0;
        while (n < localizableMessageArray.length) {
            stringBuffer.append(localizableMessageArray[n].getLocalizedText(locale));
            ++n;
        }
        return stringBuffer.toString();
    }
}

