/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.web;

import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.services.web.WebServiceProperties;
import com.sun.netstorage.mgmt.ui.console.login.LoginHandler;
import com.sun.netstorage.mgmt.ui.framework.AbstractCmdHandler;
import com.sun.netstorage.mgmt.ui.framework.Session;
import com.sun.netstorage.mgmt.ui.framework.WebCommandHandler;
import com.sun.netstorage.mgmt.ui.shell.Environment;
import com.sun.netstorage.mgmt.ui.shell.ShellImpl;
import com.sun.netstorage.mgmt.ui.util.ErrorMessage;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DMWebShell
extends ShellImpl {
    int timeoutVal = WebServiceProperties.getConnectionTimeout();
    private static final String sccs_id = "@(#)DMWebShell.java 1.29    02/06/05 SMI";

    public DMWebShell(Environment environment, Lookup lookup, Locale locale) {
        super(environment, lookup, locale);
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("ID");
        if (string != null && !string.startsWith("services")) {
            string = AbstractCmdHandler.getEffectiveId(this.lookup, string);
        }
        String string2 = httpServletRequest.getParameter("FAMILY");
        String string3 = httpServletRequest.getParameter("SERVICE");
        HttpSession httpSession = httpServletRequest.getSession();
        String string4 = (String)httpSession.getAttribute("PRIMARY_URI");
        String string5 = (String)httpSession.getAttribute("PRIMARY_QRY");
        if (null != string4) {
            httpServletRequest.setAttribute("PRIMARY_URI", (Object)string4);
            httpSession.setAttribute("PRIMARY_URI", null);
        } else {
            httpServletRequest.setAttribute("PRIMARY_URI", (Object)httpServletRequest.getRequestURI());
        }
        if (null != string5) {
            httpServletRequest.setAttribute("PRIMARY_QRY", (Object)string5);
            httpSession.setAttribute("PRIMARY_QRY", null);
        } else {
            httpServletRequest.setAttribute("PRIMARY_QRY", (Object)httpServletRequest.getQueryString());
        }
        Session session = (Session)httpSession.getAttribute("gothamSessionBean");
        Integer n = (Integer)session.getData("dm.timeout");
        if (null == n) {
            session.setData("dm.timeout", new Integer(this.timeoutVal * 1000));
        }
        session.setData("dm.last.access", new Integer((int)new Date().getTime()));
        if (null == session || !session.isValid()) {
            LoginHandler loginHandler = new LoginHandler();
            loginHandler.execute(httpServletRequest, httpServletResponse);
            return;
        }
        String string6 = httpServletRequest.getParameter("gothamcommand");
        RequestDispatcher requestDispatcher = null;
        if (null != string6) {
            requestDispatcher = httpServletRequest.getRequestDispatcher("/sun_masthead.html");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        WebCommandHandler webCommandHandler = null;
        try {
            webCommandHandler = this.findWebCommandHandler(string, string2, string3);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage errorMessage = new ErrorMessage("Internal Error:<p>Web UI Handler for <p>ID: " + string + "<br>" + "Family: " + string2 + "<br>" + "Service: " + string3 + " found is not of appropriate type<br>");
            requestDispatcher = httpServletRequest.getRequestDispatcher("/jsp/error.jsp");
            httpServletRequest.setAttribute("errorMessage", (Object)errorMessage);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (webCommandHandler != null) {
            try {
                webCommandHandler.execute(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                requestDispatcher = httpServletRequest.getRequestDispatcher("/jsp/gofirst.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else {
            String string7 = "Web UI Handler not found for ID: " + string + ", " + "Family: " + string2 + ", " + "Service: " + string3;
            this.trace(new String[]{string7});
            requestDispatcher = httpServletRequest.getRequestDispatcher("/jsp/gofirst.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private WebCommandHandler findWebCommandHandler(String string, String string2, String string3) {
        this.verbose("DMWebShell.WebCommandHandler(" + string + ", " + string2 + ", " + string3 + ")");
        if ("login".equals(string2)) {
            LoginHandler loginHandler = new LoginHandler();
            return loginHandler;
        }
        if ((null == string3 || "".equals(string3.trim())) && (null == string || "".equals(string.trim()))) {
            this.trace(new String[]{"Device/Service ID not defined"});
            return null;
        }
        Lookup lookup = this.getLookup();
        if (null == string2 || "".equals(string2.trim())) {
            string2 = lookup.getDefaultFamily(string);
        }
        if (null == string2 || "".equals(string2.trim())) {
            String[] stringArray = lookup.getFamilies(string);
            this.verbose("Family is not defined... assigning default family.");
            if (stringArray == null || stringArray.length < 1) {
                this.verbose("No applications defined for the application.");
                return null;
            }
            string2 = stringArray[0];
        }
        string2 = string2.trim().toLowerCase();
        return (WebCommandHandler)this.findCmdHandler("WEB", string, string2, string3);
    }

    public static void updateSession(Session session) {
        if (null == session) {
            return;
        }
        session.setData("dm.last.access", new Integer((int)new Date().getTime()));
    }

    public static void updateSession(HttpSession httpSession) {
        if (null == httpSession) {
            return;
        }
        Session session = (Session)httpSession.getAttribute("gothamSessionBean");
        DMWebShell.updateSession(session);
    }
}

