/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.CommandOutputListener;
import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class CommandExec {
    private int returnCode;
    private String path;
    private StringWriter stdout;
    private StringWriter stderr;
    private Process proc;
    private boolean running;
    private boolean aborted;
    private ReadInputTask stdoutReaderTask;
    private ReadInputTask stderrReaderTask;
    private static final String sccs_id = "@(#)CommandExec.java\t1.9 12/12/02 SMI";

    public CommandExec(String string) {
        this.path = string;
    }

    public synchronized void exec() throws IOException {
        this.exec(null);
    }

    public synchronized int run() throws IOException {
        this.exec();
        return this.getReturnValue();
    }

    public synchronized void exec(CommandOutputListener commandOutputListener) throws IOException {
        this.running = true;
        this.aborted = false;
        Runtime runtime = Runtime.getRuntime();
        this.proc = runtime.exec(this.path);
        this.stdout = new StringSyncWriter();
        this.stderr = new StringSyncWriter();
        this.stdoutReaderTask = new ReadInputTask(this.proc.getInputStream(), this.stdout, commandOutputListener);
        this.stderrReaderTask = new ReadInputTask(this.proc.getErrorStream(), this.stderr, commandOutputListener);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob(this.stdoutReaderTask);
        threadPool.runJob(this.stderrReaderTask);
        if (commandOutputListener != null) {
            threadPool.runJob(new ReturnValueTask(commandOutputListener));
        }
    }

    public String getStandardOutput() {
        if (this.stdout == null) {
            return null;
        }
        return this.stdout.toString();
    }

    public String getErrorOutput() {
        if (this.stderr == null) {
            return null;
        }
        return this.stderr.toString();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void abort() {
        if (this.proc != null && this.running) {
            this.proc.destroy();
            this.aborted = true;
            this.proc = null;
            this.running = false;
        }
    }

    public synchronized int getReturnValue() throws IllegalStateException {
        boolean bl;
        if (!this.running) {
            return this.returnCode;
        }
        do {
            try {
                if (this.proc == null) {
                    throw new IllegalStateException();
                }
                this.returnCode = this.proc.waitFor();
                this.stdoutReaderTask.finish();
                this.stderrReaderTask.finish();
                bl = false;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        this.proc = null;
        this.running = false;
        return this.returnCode;
    }

    public synchronized int getReturnValue(long l) throws IllegalStateException, InterruptedException {
        ThreadPool threadPool = ThreadPool.getThreadPool();
        TaskMonitor taskMonitor = new TaskMonitor(l);
        threadPool.runJob(taskMonitor);
        int n = this.getReturnValue();
        taskMonitor.stop();
        if (this.aborted) {
            throw new InterruptedException();
        }
        return n;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            CommandExec commandExec = new CommandExec("echo hello");
            this.assertCondition(commandExec.run() == 0);
            this.assertEquals("hello\n", commandExec.getStandardOutput());
            commandExec = new CommandExec("echo abcdefg");
            this.assertCondition(commandExec.run() == 0);
            this.assertEquals("abcdefg\n", commandExec.getStandardOutput());
            commandExec = new CommandExec("sleep 30");
            commandExec.exec();
            try {
                commandExec.getReturnValue(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.fail("Command didn't timeout");
        }

        public static void main(String[] stringArray) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append(" ");
                    ++n;
                }
                String string = stringBuffer.toString();
                System.out.println("COMMAND: " + string);
                CommandExec commandExec = new CommandExec(string);
                commandExec.exec(new TestListener());
                System.exit(commandExec.getReturnValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static class TestListener
    implements CommandOutputListener {
        public void stdOutput(String string) {
            System.out.println(string);
        }

        public void errOutput(String string) {
            System.out.println("ERROR:" + string);
        }

        public void finished(int n) {
            System.out.println("EXIT " + n);
        }
    }

    private static class StringSyncWriter
    extends StringWriter {
        private StringSyncWriter() {
        }

        public synchronized String toString() {
            return super.toString();
        }

        public synchronized void write(int n) {
            super.write(n);
        }

        public synchronized StringBuffer getBuffer() {
            return super.getBuffer();
        }
    }

    private class ReadInputTask
    implements Runnable {
        InputStream input;
        StringWriter output;
        boolean finished;
        CommandOutputListener listener;
        StringBuffer line;

        ReadInputTask(InputStream inputStream, StringWriter stringWriter, CommandOutputListener commandOutputListener) {
            this.input = inputStream;
            this.output = stringWriter;
            this.listener = commandOutputListener;
        }

        public void run() {
            if (this.listener != null) {
                this.line = new StringBuffer();
            }
            try {
                int n;
                while (-1 != (n = this.input.read())) {
                    this.output.write(n);
                    if (this.line == null || n == 13) continue;
                    if (n == 10) {
                        if (this == CommandExec.this.stdoutReaderTask) {
                            this.listener.stdOutput(this.line.toString());
                        } else {
                            this.listener.errOutput(this.line.toString());
                        }
                        this.line.delete(0, this.line.length());
                        continue;
                    }
                    this.line.append((char)n);
                }
            }
            catch (IOException iOException) {
                Report.error.log(iOException, (Object)CommandExec.this.path);
            }
            this.setFinished(true);
        }

        public synchronized void setFinished(boolean bl) {
            this.finished = bl;
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.notify();
        }

        public synchronized void finish() {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ReturnValueTask
    implements Runnable {
        private CommandOutputListener listener;

        ReturnValueTask(CommandOutputListener commandOutputListener) {
            this.listener = commandOutputListener;
        }

        public void run() {
            this.listener.finished(CommandExec.this.getReturnValue());
        }
    }

    private class TaskMonitor
    implements Runnable {
        private long timeout;
        private boolean stopped;

        TaskMonitor(long l) {
            this.timeout = l;
        }

        public synchronized void stop() {
            boolean bl = true;
            this.notify();
        }

        public synchronized void run() {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stopped) {
                return;
            }
            if (CommandExec.this.isRunning()) {
                CommandExec.this.abort();
            }
        }
    }
}

