/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.CommandRunner;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CommandRunnerImpl
implements CommandRunner {
    private String[] cmdList = new String[]{"STOP : Stop all services.", "ECHO <message> : Echo message arguments", "MEM : List JVM memory usage.", "LIST : List all available commands."};
    private Map commanders;
    private static final String sccs_id = "@(#)CommandRunnerImpl.java\t1.11 04/05/02 SMI";

    public String getRoot() {
        return "/";
    }

    public int execute(String string, String string2, Writer writer) {
        try {
            writer.write(this.execute(string, string2));
        }
        catch (IOException iOException) {
            return 1;
        }
        return 0;
    }

    public String execute(String string, String string2) {
        try {
            Report.trace.log("Command=" + string);
            Report.trace.log("Args=" + string2);
            if (string.equals("STOP")) {
                System.exit(0);
            } else {
                if (string.equals("ECHO")) {
                    return string2;
                }
                if (string.equals("LIST")) {
                    return this.list();
                }
                if (string.equals("MEM")) {
                    return this.mem();
                }
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            return "Command execute " + string + " FAILED:" + stringWriter.toString();
        }
        return "ERROR:/" + string + " Command not found.";
    }

    void setCommanderMap(Map map) {
        this.commanders = map;
    }

    private String list() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.commanders.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CommandRunner commandRunner = (CommandRunner)entry.getValue();
            String[] stringArray = commandRunner.getCommands();
            String string = commandRunner.getRoot();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(string + "/" + stringArray[n] + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String mem() {
        StringBuffer stringBuffer = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        long l3 = l2 - l;
        stringBuffer.append("Used  Memory = " + l3 + "\n");
        stringBuffer.append("Free  Memory = " + l + "\n");
        stringBuffer.append("Total Memory = " + l2 + "\n");
        return stringBuffer.toString();
    }

    public String[] getCommands() {
        return this.cmdList;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            CommandRunnerImpl commandRunnerImpl = new CommandRunnerImpl();
            String string = "ECHO";
            String string2 = "a b; c. def g";
            this.assertEquals(commandRunnerImpl.execute(string, string2), string2);
            String[] stringArray = commandRunnerImpl.getCommands();
        }
    }
}

