/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.CommandHandler;
import com.sun.jade.apps.command.CommandRunner;
import com.sun.jade.apps.command.CommandRunnerImpl;
import com.sun.jade.apps.command.CommandService;
import com.sun.jade.apps.command.Pool;
import com.sun.jade.apps.command.Server;
import com.sun.jade.util.locale.LocalizableMessage;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CommandServiceImpl
implements CommandService {
    private static final int DEFAULT_PORT = 8089;
    private static final int DEFAULT_THREAD = 2;
    private Server server;
    private int port;
    private int thread = 2;
    private IOException serverError;
    private HashMap runList = new HashMap();
    private String serviceName;
    private CommandRunner[] startup = new CommandRunner[0];
    private static final String sccs_id = "@(#)CommandServiceImpl.java\t1.15 12/10/02 SMI";

    public CommandServiceImpl(Properties properties) {
        String string = properties.getProperty("port");
        try {
            this.port = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.port = 8089;
        }
        String string2 = properties.getProperty("threads");
        try {
            this.thread = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.thread = 2;
        }
        if ("N".equals(properties.getProperty("enable"))) {
            return;
        }
        Report.debug.log("Installer", (Object)("Starting command Service: port = " + this.port + " threads=" + this.thread));
        this.initService();
        try {
            this.server = new Server(new Pool(new CommandHandler(this), this.thread), this.port);
            this.server.start();
        }
        catch (IOException iOException) {
            this.serverError = iOException;
            this.server = null;
        }
    }

    public CommandServiceImpl() {
        this.initService();
    }

    private void initService() {
        CommandRunnerImpl commandRunnerImpl = new CommandRunnerImpl();
        commandRunnerImpl.setCommanderMap(this.runList);
        this.runList.put(commandRunnerImpl.getRoot(), commandRunnerImpl);
        int n = 0;
        while (n < this.startup.length) {
            this.runList.put(this.startup[n].getRoot(), this.startup[n]);
            ++n;
        }
        String string = "localhost";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.serviceName = "http://" + string + ":" + this.port;
    }

    public String getName() throws RemoteException {
        String string = "localhost";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "http://" + string + ":" + this.port;
    }

    public String getClassName() throws RemoteException {
        return "com.sun.jade.apps.command.CommandService";
    }

    public LocalizableMessage getDescription() throws RemoteException {
        return null;
    }

    public LocalizableMessage getCaption() throws RemoteException {
        return null;
    }

    public String execute(String string) throws RemoteException {
        String string2 = this.getRootName(string);
        string = this.getCommand(string);
        String string3 = this.getCommandName(string);
        String string4 = this.getCommandArgs(string);
        if (this.serverError != null) {
            return this.serverError.toString();
        }
        if (string2.equals("/") && string3.equals("")) {
            return this.htmlList();
        }
        CommandRunner commandRunner = (CommandRunner)this.runList.get(string2);
        if (commandRunner == null) {
            return "ERROR: Command runner " + string2 + " not found";
        }
        StringWriter stringWriter = new StringWriter();
        if (commandRunner.execute(string3, string4, stringWriter) == 0) {
            return stringWriter.toString();
        }
        return "FAILURE";
    }

    private String htmlList() throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.runList.entrySet();
        Iterator iterator = set.iterator();
        stringBuffer.append("<HTML>");
        stringBuffer.append("<H1> StorADE Developer Interface </H1>");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CommandRunner commandRunner = (CommandRunner)entry.getValue();
            String[] stringArray = commandRunner.getCommands();
            String string = commandRunner.getRoot();
            stringBuffer.append("<H2>");
            stringBuffer.append(string);
            stringBuffer.append("</H2><UL>");
            int n = 0;
            while (n < stringArray.length) {
                String string2 = this.getCommand(stringArray[n]);
                String string3 = this.getCommandName(string2);
                String string4 = this.getCommandArgs(string2);
                stringBuffer.append("<LI><A HREF=\"");
                stringBuffer.append(this.getName());
                stringBuffer.append(string + "/" + string3 + "\">");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("</A>");
                ++n;
            }
            stringBuffer.append("</UL>");
        }
        stringBuffer.append("<FORM method=\"POST\" action=\"/MF/INSTALL\">");
        stringBuffer.append("MF/INSTALL ");
        stringBuffer.append("type <SELECT name=type> ");
        stringBuffer.append("<OPTION VALUE=t3>T3 Array");
        stringBuffer.append("<OPTION VALUE=switch>Fibre Switch");
        stringBuffer.append("<OPTION VALUE=fake>Fake Switch");
        stringBuffer.append("</SELECT>");
        stringBuffer.append("ip <INPUT name=ip> ");
        stringBuffer.append("<INPUT type=submit value=ok>");
        stringBuffer.append("</FORM>");
        stringBuffer.append("<FORM method=\"POST\" action=\"/ECHO\">");
        stringBuffer.append("ECHO ");
        stringBuffer.append("string <INPUT name=string> ");
        stringBuffer.append("<INPUT type=submit value=ok>");
        stringBuffer.append("</FORM>");
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    private String getRootName(String string) {
        int n = string.lastIndexOf("/");
        String string2 = "/";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if (string2.charAt(0) != '/') {
            return "/" + string2;
        }
        return string2;
    }

    private String getCommand(String string) {
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private String getCommandName(String string) {
        int n = string.indexOf(" ");
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getCommandArgs(String string) {
        int n = string.indexOf(" ");
        if (n < 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public String[] getCommands(String string) throws RemoteException {
        CommandRunner commandRunner = (CommandRunner)this.runList.get(string);
        return commandRunner.getCommands();
    }

    public String[] getRunners() throws RemoteException {
        Set set = this.runList.entrySet();
        Iterator iterator = set.iterator();
        String[] stringArray = new String[this.runList.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n++] = (String)entry.getKey();
        }
        return stringArray;
    }

    public void addRunner(CommandRunner commandRunner) throws RemoteException {
        this.runList.put(commandRunner.getRoot(), commandRunner);
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            CommandServiceImpl commandServiceImpl = new CommandServiceImpl();
            this.assertEquals(commandServiceImpl.getCommand("BLAH"), "BLAH");
            this.assertEquals(commandServiceImpl.getRootName("BLAH"), "/");
            this.assertEquals(commandServiceImpl.getCommand("/BLAH"), "BLAH");
            this.assertEquals(commandServiceImpl.getRootName("/BLAH"), "/");
            this.assertEquals(commandServiceImpl.getCommand("/BLAH/GOO"), "GOO");
            this.assertEquals(commandServiceImpl.getRootName("/BLAH/GOO"), "/BLAH");
            String string = "testing an echo command :)";
            this.assertEquals(commandServiceImpl.execute("ECHO " + string), string);
            this.assertEquals(commandServiceImpl.execute("ECHO  "), " ");
            this.assertEquals(commandServiceImpl.execute("ECHO "), "");
            this.assertEquals(commandServiceImpl.execute("ECHO"), "");
        }
    }
}

