/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.CommandRunner;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MultiRunner
implements CommandRunner {
    private HashMap runList = new HashMap();
    private static final String sccs_id = "@(#)MultiRunner.java\t1.3 12/11/01 SMI";

    public MultiRunner() {
        this.addRunner(new TopLevelRunner());
    }

    public MultiRunner(CommandRunner[] commandRunnerArray) {
        this.addRunner(new TopLevelRunner());
        int n = 0;
        while (n < commandRunnerArray.length) {
            this.addRunner(commandRunnerArray[n]);
            ++n;
        }
    }

    public int execute(String string, String string2, Writer writer) {
        String string3 = this.getRootName(string);
        String string4 = this.getCommandName(string);
        CommandRunner commandRunner = (CommandRunner)this.runList.get(string3);
        if (commandRunner == null) {
            return 1;
        }
        return commandRunner.execute(string4, string2, writer);
    }

    public String[] getCommands() {
        Object object;
        Vector<String> vector = new Vector<String>();
        Set set = this.runList.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            CommandRunner commandRunner = (CommandRunner)object.getValue();
            String[] stringArray = commandRunner.getCommands();
            String string = commandRunner.getRoot();
            int n = 0;
            while (n < stringArray.length) {
                vector.add(new String(string + "/" + stringArray[n] + "\n"));
                ++n;
            }
        }
        object = new String[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    public String getRoot() {
        return "/";
    }

    public synchronized void addRunner(CommandRunner commandRunner) {
        this.runList.put(commandRunner.getRoot(), commandRunner);
    }

    private String getRootName(String string) {
        int n = string.lastIndexOf("/");
        String string2 = "/";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if (string2.charAt(0) != '/') {
            return "/" + string2;
        }
        return string2;
    }

    private String getCommandName(String string) {
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    class TopLevelRunner
    implements CommandRunner {
        private String[] cmdList = new String[]{"STOP : Stop all services.", "ECHO <message> : Echo message arguments", "MEM  : List JVM memory usage.", "LIST : List all available commands."};

        TopLevelRunner() {
        }

        public String getRoot() {
            return "/";
        }

        public String[] getCommands() {
            return this.cmdList;
        }

        public int execute(String string, String string2, Writer writer) {
            try {
                writer.write(this.execute(string, string2));
            }
            catch (IOException iOException) {
                return 1;
            }
            return 0;
        }

        private String execute(String string, String string2) {
            try {
                if (string.equals("STOP")) {
                    System.exit(0);
                } else {
                    if (string.equals("ECHO")) {
                        return string2;
                    }
                    if (string.equals("LIST")) {
                        return this.list();
                    }
                    if (string.equals("MEM")) {
                        return this.mem();
                    }
                }
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                return "Command execute " + string + " FAILED:" + stringWriter.toString();
            }
            return "ERROR:/" + string + " Command not found.";
        }

        private String mem() {
            StringBuffer stringBuffer = new StringBuffer();
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            long l3 = l2 - l;
            stringBuffer.append("Used  Memory = " + l3 + "\n");
            stringBuffer.append("Free  Memory = " + l + "\n");
            stringBuffer.append("Total Memory = " + l2 + "\n");
            return stringBuffer.toString();
        }

        private String list() throws Exception {
            StringBuffer stringBuffer = new StringBuffer();
            Set set = MultiRunner.this.runList.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                CommandRunner commandRunner = (CommandRunner)entry.getValue();
                String[] stringArray = commandRunner.getCommands();
                String string = commandRunner.getRoot();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(string + "/" + stringArray[n] + "\n");
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }
}

