/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.Echo;
import com.sun.jade.apps.command.RequestCreator;
import com.sun.jade.apps.command.RequestHandler;
import com.sun.jade.util.unittest.UnitTest;
import java.net.Socket;
import java.util.LinkedList;

public class Pool
implements RequestHandler {
    private static final int MAX_THREADS = 8;
    private RequestCreator creator;
    LinkedList list = new LinkedList();
    LinkedList handlers = new LinkedList();

    public Pool(RequestCreator requestCreator, int n) {
        this.creator = requestCreator;
        if (requestCreator == null || n < 1 || n > 8) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < n) {
            Handler handler = new Handler(requestCreator, this);
            this.handlers.add(handler);
            handler.start();
            ++n2;
        }
    }

    public synchronized void handleRequest(Socket socket) {
        this.list.add(socket);
        this.notifyAll();
    }

    private synchronized Socket getRequest() {
        while (this.list.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (Socket)this.list.removeFirst();
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            Pool pool = new Pool(new Echo(), 8);
        }
    }

    private class Handler
    extends Thread {
        private Pool p;
        private RequestHandler r;
        private boolean doRun = true;

        Handler(RequestCreator requestCreator, Pool pool2) {
            this.p = pool2;
            this.r = requestCreator.createHandler();
        }

        public void abort() {
            this.doRun = false;
        }

        public void run() {
            while (this.doRun) {
                Socket socket = this.p.getRequest();
                if (socket == null) continue;
                try {
                    this.r.handleRequest(socket);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

