/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.exec;

import com.sun.jade.apps.diags.exec.DiagnosticTestServiceImpl;
import com.sun.jade.apps.diags.exec.SessionTestQue;
import com.sun.jade.apps.diags.exec.TestRunEntry;
import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMDateTime;
import java.rmi.RemoteException;
import java.util.Iterator;

class ContextManager {
    private DiagnosticResult failedResult;
    private TestRunEntry testRun;
    private SessionTestQue session;
    private DiagnosticTestServiceImpl testService;
    private DiagnosticTestInfo testInfo;
    private MF device;
    private DiagnosableHelper diagHelper;
    private static final String LOG_TAG = "SessionTestQue";

    public ContextManager(TestRunEntry testRunEntry, SessionTestQue sessionTestQue) {
        this.testRun = testRunEntry;
        this.session = sessionTestQue;
        this.init();
    }

    public boolean getContext() {
        Object object;
        Object object2;
        Object object3;
        this.checkSettings();
        boolean bl = false;
        int[] nArray = this.testInfo.getTestCharacteristics();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == 2) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            Report.debug.log(LOG_TAG, (Object)"Test has exclusive bit set.");
            Iterator iterator = this.testService.getCurrentTestRunEntries().iterator();
            object3 = this.testInfo.getTestClassName();
            while (iterator.hasNext()) {
                object2 = (TestRunEntry)iterator.next();
                if (this.testRun == object2 || !this.entryRunning((TestRunEntry)object2) || !((String)object3).equals(((TestRunEntry)object2).getTest().getTestClassName())) continue;
                DiagnosticException diagnosticException = new DiagnosticException("DIAG_ERR_EXCLUSIVE_TEST_CONFLICT");
                this.failedResult = this.createFailedResult(diagnosticException);
                return false;
            }
        }
        boolean bl2 = false;
        object3 = this.testInfo.getTestableElements();
        n = 0;
        while (n < ((TestableElement[])object3).length) {
            object2 = object3[n];
            object = ((TestableElement)object2).getCreationClassName();
            if (((String)object).equals(this.testInfo.getMSEClassName()) && ((TestableElement)object2).getIsExclusiveForDevice()) {
                bl2 = true;
                break;
            }
            ++n;
        }
        if (bl2) {
            Report.debug.log(LOG_TAG, (Object)"Test has exclusive for device set.");
            try {
                object2 = this.testService.getCurrentTestRunEntries().iterator();
                object = this.device.getName();
                String string = this.device.getClassName();
                String string2 = this.testRun.getElementKey().toString();
                Report.debug.log(LOG_TAG, (Object)(string2 + " " + string + ":" + (String)object));
                while (object2.hasNext()) {
                    TestRunEntry testRunEntry = (TestRunEntry)object2.next();
                    Report.debug.log(LOG_TAG, (Object)("Check " + testRunEntry.getElementKey().toString()));
                    if (this.testRun == testRunEntry || string2.equals(testRunEntry.getElementKey().toString()) || !this.entryRunning(testRunEntry)) continue;
                    MF mF = testRunEntry.getMf();
                    Report.debug.log(LOG_TAG, (Object)(mF.getClassName() + ":" + mF.getName()));
                    if (!((String)object).equals(mF.getName()) || !string.equals(mF.getClassName())) continue;
                    DiagnosticException diagnosticException = new DiagnosticException("DIAG_ERR_EXCLUSIVE_DEVICE_CONFLICT");
                    this.failedResult = this.createFailedResult(diagnosticException);
                    return false;
                }
            }
            catch (RemoteException remoteException) {
                object = new DiagnosticException("DIAG_ERR_OUT_OF_RESOURCES");
                this.failedResult = this.createFailedResult((Exception)object);
                return false;
            }
        }
        object2 = this.testInfo.getTestContext();
        Report.debug.log(LOG_TAG, (Object)"Context passes");
        return true;
    }

    private void init() {
        this.device = this.testRun.getMf();
        this.testInfo = this.testRun.getTest();
        this.testService = this.session.getTestService();
        try {
            this.diagHelper = (DiagnosableHelper)this.device.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean entryRunning(TestRunEntry testRunEntry) {
        int n = testRunEntry.getState();
        if (n == 3) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        Report.debug.log(LOG_TAG, (Object)("entry running " + n));
        return true;
    }

    private boolean checkSettings() {
        boolean bl = false;
        try {
            bl = this.diagHelper.validateTest(this.testInfo);
        }
        catch (Exception exception) {
            this.failedResult = this.createFailedResult(exception);
            return false;
        }
        if (!bl) {
            DiagnosticException diagnosticException = new DiagnosticException("DIAG_ERR_INVALID_SETTING_FOR_TEST");
            this.failedResult = this.createFailedResult(diagnosticException);
        }
        Report.debug.log(LOG_TAG, (Object)"Settings passed");
        return bl;
    }

    public DiagnosticResult getFailedResult() {
        return this.failedResult;
    }

    public DiagnosticResult createFailedResult(Exception exception) {
        LocalizedString localizedString = new LocalizedString(exception);
        if (exception instanceof DiagnosticException) {
            localizedString = ((DiagnosticException)exception).getLocalizedString();
        }
        return this.createFailedResult(localizedString.toString());
    }

    public DiagnosticResult createFailedResult(String string) {
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(this.testInfo.getMSE());
        diagnosticResult.setTestStartTime(new CIMDateTime());
        diagnosticResult.setDiagnosticName(this.testInfo.getTestName());
        diagnosticResult.setDiagnosticCreationClassName(this.testInfo.getTestClassName());
        diagnosticResult.setElementKey(new ElementKey());
        diagnosticResult.setSettings(this.testInfo.getSettingsForTest());
        diagnosticResult.setUserID(this.session.getUserIdSessionId());
        diagnosticResult.setMse(new ReferenceForMSE(this.testInfo.getMSE()));
        diagnosticResult.setDiagSystemCreationClassName(referenceForMSE.getSystemClassName());
        if (referenceForMSE.getSystemName() != null) {
            diagnosticResult.setDiagSystemName(referenceForMSE.getSystemName());
        } else {
            diagnosticResult.setDiagSystemName(referenceForMSE.getKeyValue());
        }
        diagnosticResult.setFinalResults(TestState.FAILED, string);
        return diagnosticResult;
    }

    private void validateResult(DiagnosticResult diagnosticResult) {
        if (diagnosticResult.getDiagSystemName() == null) {
            ReferenceForMSE referenceForMSE = new ReferenceForMSE(this.testInfo.getMSE());
            if (referenceForMSE.getSystemName() != null) {
                diagnosticResult.setDiagSystemName(referenceForMSE.getSystemName());
            } else {
                diagnosticResult.setDiagSystemName(referenceForMSE.getKeyValue());
            }
        }
    }

    public DiagnosticResult runTest() {
        DiagnosticResult diagnosticResult = null;
        try {
            diagnosticResult = this.diagHelper.runTest(this.testInfo, this.session);
            this.validateResult(diagnosticResult);
        }
        catch (Exception exception) {
            diagnosticResult = this.createFailedResult(exception);
        }
        return diagnosticResult;
    }

    public static class Test
    extends UnitTest {
        public void test() {
        }
    }
}

