/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.exec;

import com.sun.jade.apps.diags.exec.DiagnosticTestEvent;
import com.sun.jade.apps.diags.exec.DiagnosticTestListener;
import com.sun.jade.apps.diags.exec.DiagnosticTestRegistry;
import com.sun.jade.apps.diags.exec.DiagnosticTestService;
import com.sun.jade.apps.diags.exec.GlobalTestOptions;
import com.sun.jade.apps.diags.exec.SessionTestQue;
import com.sun.jade.apps.diags.exec.TestRun;
import com.sun.jade.apps.diags.lib.Diagnosable;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.discovery.InstallEvent;
import com.sun.jade.apps.discovery.InstallListener;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.SADE_DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticTest;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class DiagnosticTestServiceImpl
implements DiagnosticTestService {
    private InstallListener installListener;
    private DiagnosticTest test = new DiagnosticTest();
    private Vector listeners = new Vector();
    private HashMap sessionQue = new HashMap();
    static HashMap allSessionsListenerList = new HashMap();
    private CIMBeanPersistence beanPersist;
    public static final String sccs_id = "@(#)DiagnosticTestServiceImpl.java\t1.61 11/08/02 SMI";

    public DiagnosticTestServiceImpl(Properties properties) {
        this.installListener = new ThisServiceInstallListener();
    }

    public String getServiceName() {
        return "Diagnostic Test Service";
    }

    public Object getTests() {
        return this.test;
    }

    private synchronized void updateDiagnosticTestListener() {
        boolean bl = false;
        DiagnosticTestEvent diagnosticTestEvent = new DiagnosticTestEvent(this.test);
        int n = 0;
        while (n < this.listeners.size()) {
            DiagnosticTestListener diagnosticTestListener = (DiagnosticTestListener)this.listeners.elementAt(n);
            try {
                diagnosticTestListener.notify(diagnosticTestEvent);
            }
            catch (RemoteException remoteException) {
                this.listeners.setElementAt(null, n);
                bl = true;
                remoteException.printStackTrace();
            }
            ++n;
        }
    }

    public synchronized void addDiagnosticTestListener(DiagnosticTestListener diagnosticTestListener) {
        try {
            DiagnosticTestEvent diagnosticTestEvent = new DiagnosticTestEvent(this.test);
            diagnosticTestListener.notify(diagnosticTestEvent);
            this.listeners.add(diagnosticTestListener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public synchronized void removeDiagnosticTestListener(DiagnosticTestListener diagnosticTestListener) {
        this.listeners.remove(diagnosticTestListener);
    }

    public synchronized DiagnosticTestInfo[] getTestsForMF(MF mF) throws RemoteException {
        return this.getMseTestsForMF(mF, new ReferenceForMSE(mF.getClassName(), mF.getName()));
    }

    public synchronized DiagnosticTestInfo[] getMseTestsForMF(MF mF, ReferenceForMSE referenceForMSE) throws RemoteException {
        return DiagnosticTestRegistry.getInstance().getMseTestsForMF(mF, referenceForMSE);
    }

    public synchronized String openSession(String string, DiagnosticResultListener diagnosticResultListener, Locale locale) {
        String string2 = string;
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string2);
        if (sessionTestQue == null) {
            try {
                sessionTestQue = new SessionTestQue(diagnosticResultListener, string2, this, locale);
                this.sessionQue.put(string2, sessionTestQue);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.debugLog("Reconnected user to original session.");
            sessionTestQue.setSessionListener(diagnosticResultListener);
        }
        return string2;
    }

    public synchronized void killSession(String string) {
        String string2 = string;
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string2);
        if (sessionTestQue == null) {
            return;
        }
        allSessionsListenerList.remove(string);
        boolean bl = sessionTestQue.abortAllTests();
        if (!bl) {
            this.sessionQue.remove(string2);
        } else {
            this.debugLog("Session not removed, not all tests aborted");
        }
    }

    public synchronized ElementKey submitTest(String string, DiagnosticTestInfo diagnosticTestInfo, MF mF) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User (" + string + ") has no session to submitTest to");
            return null;
        }
        ElementKey elementKey = sessionTestQue.addTest(diagnosticTestInfo, mF);
        return elementKey;
    }

    public synchronized void openAllSessionsView(String string) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no session can't View All");
            return;
        }
        DiagnosticResultListener diagnosticResultListener = sessionTestQue.getSessionListener();
        allSessionsListenerList.put(string, diagnosticResultListener);
        if (allSessionsListenerList.isEmpty()) {
            this.debugLog("all sessions map is still empty");
        }
    }

    public synchronized void closeAllSessionsView(String string) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no session to remove the view from.");
            return;
        }
        allSessionsListenerList.remove(string);
    }

    public synchronized Vector viewSessionLog(String string) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no active session to view.");
            return null;
        }
        Vector vector = sessionTestQue.viewSessionLog(string);
        return vector;
    }

    public TestRun[] getArchivedTestRuns(String string) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no Session.");
            return null;
        }
        TestRun[] testRunArray = sessionTestQue.getArchivedTestRuns(string);
        return testRunArray;
    }

    public Collection getSessionExecutionIds(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * from SADE_DiagnosticResult ");
            stringBuffer.append(" WHERE UserID = '");
            stringBuffer.append(string);
            stringBuffer.append("' ");
            stringBuffer.append(" ORDER BY TestCompletionTime DESC");
            Collection collection = this.getBeanPersistence().retrieveBeans("SADE_DiagnosticResult", stringBuffer.toString());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SADE_DiagnosticResult sADE_DiagnosticResult = (SADE_DiagnosticResult)iterator.next();
                vector.add(sADE_DiagnosticResult.getExecutionID());
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Results not found.");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Unknown problem - Results not found.");
        }
        return vector;
    }

    public long countDiagnosticResultsByUser(String string) {
        long l = 0L;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT COUNT(*) from SADE_DiagnosticResult ");
            stringBuffer.append(" WHERE UserID = '");
            stringBuffer.append(string);
            stringBuffer.append("' ");
            stringBuffer.append(" ORDER BY TestCompletionTime DESC");
            l = this.getBeanPersistence().countBeans("SADE_DiagnosticResult", stringBuffer.toString());
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Results not found.");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Unknown problem - Cannot count Results.");
        }
        return l;
    }

    public Iterator getDiagnosticResultsByUser(String string, long l, long l2) {
        Vector<DiagnosticResult> vector = new Vector<DiagnosticResult>();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT ");
            if (l >= 0L && l2 >= 0L) {
                stringBuffer.append("LIMIT " + l + " " + l2);
            }
            stringBuffer.append(" * from SADE_DiagnosticResult ");
            stringBuffer.append(" WHERE UserID = '");
            stringBuffer.append(string);
            stringBuffer.append("' ");
            stringBuffer.append(" ORDER BY TestCompletionTime DESC");
            Collection collection = this.getBeanPersistence().retrieveBeans("SADE_DiagnosticResult", stringBuffer.toString());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DiagnosticResult diagnosticResult = new DiagnosticResult((SADE_DiagnosticResult)iterator.next());
                vector.add(diagnosticResult);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Results not found.");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Unknown problem - Results not found.");
        }
        return vector.iterator();
    }

    public DiagnosticResult getDiagnosticResult(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * from SADE_DiagnosticResult ");
            stringBuffer.append(" WHERE ExecutionID = '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            Collection collection = this.getBeanPersistence().retrieveBeans("SADE_DiagnosticResult", stringBuffer.toString());
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                SADE_DiagnosticResult sADE_DiagnosticResult = (SADE_DiagnosticResult)iterator.next();
                return new DiagnosticResult(sADE_DiagnosticResult);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Results not found.");
        }
        return null;
    }

    public int removeDiagnosticResult(String string) {
        int n = -1;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE from SADE_DiagnosticResult ");
            stringBuffer.append(" WHERE ExecutionID = '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            n = this.getBeanPersistence().removeBeans("SADE_DiagnosticResult", stringBuffer.toString());
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"problem deleting diagnostic result.");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Unknown problem - Cannot delete results.");
        }
        return n;
    }

    public synchronized boolean abortTest(String string, ElementKey elementKey) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        boolean bl = true;
        if (sessionTestQue == null) {
            this.debugLog("User has no active session to abort a test.");
            bl = false;
        } else {
            bl = sessionTestQue.abortTest(elementKey);
        }
        return bl;
    }

    public synchronized void setGlobalOptions(String string, int n, int n2, boolean bl) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no active session to set Global Options.");
        } else {
            sessionTestQue.setGlobalSessionOptions(n, n2, bl);
        }
    }

    public synchronized GlobalTestOptions getGlobalOptions(String string) {
        GlobalTestOptions globalTestOptions = null;
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        if (sessionTestQue == null) {
            this.debugLog("User has no active session to get Global Options.");
        } else {
            globalTestOptions = sessionTestQue.getGlobalSessionOptions();
        }
        return globalTestOptions;
    }

    public synchronized boolean validateSettings(String string, ElementKey elementKey) {
        SessionTestQue sessionTestQue = (SessionTestQue)this.sessionQue.get(string);
        boolean bl = true;
        if (sessionTestQue == null) {
            this.debugLog("User has no active session to validate settings.");
            bl = false;
        } else {
            bl = sessionTestQue.validateSettings(elementKey);
        }
        return bl;
    }

    synchronized Collection getCurrentTestRunEntries() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.sessionQue.values().iterator();
        while (iterator.hasNext()) {
            SessionTestQue sessionTestQue = (SessionTestQue)iterator.next();
            Collection collection = sessionTestQue.getTestRunEntries();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                linkedList.add(iterator2.next());
            }
        }
        return linkedList;
    }

    private void debugLog(String string) {
        Report.debug.log("TestService", (Object)string);
    }

    private CIMBeanPersistence getBeanPersistence() {
        if (this.beanPersist == null) {
            try {
                this.beanPersist = PersistenceService.getService().getCIMBeanPersistence();
            }
            catch (ConnectionException connectionException) {
                Report.error.log("Error Finding CIM Persistence");
            }
        }
        return this.beanPersist;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            DiagnosticTestServiceImpl diagnosticTestServiceImpl = new DiagnosticTestServiceImpl(null);
            this.assertEquals(diagnosticTestServiceImpl.getServiceName(), "Diagnostic Test Service");
        }
    }

    private class ThisServiceInstallListener
    implements InstallListener {
        private InstallerService installerService = InstallerServiceFinder.getInstallerService();

        public ThisServiceInstallListener() {
            if (this.installerService != null) {
                this.installerService.addInstallListener(this);
            }
        }

        public void notify(InstallEvent installEvent) throws RemoteException {
            switch (installEvent.getMode()) {
                case 1: 
                case 2: {
                    MF mF = (MF)installEvent.getSource();
                    ServiceHelper[] serviceHelperArray = mF.getServiceHelpers();
                    if (serviceHelperArray == null) {
                        return;
                    }
                    int n = 0;
                    while (n < serviceHelperArray.length) {
                        if (serviceHelperArray[n] instanceof Diagnosable) {
                            Diagnosable diagnosable = (Diagnosable)((Object)serviceHelperArray[n]);
                            try {
                                DiagnosticTestInfo[] diagnosticTestInfoArray = diagnosable.getDiagnosticTests();
                                DiagnosticTestRegistry.getInstance().registerTests(mF.getClassName(), diagnosticTestInfoArray);
                            }
                            catch (DiagnosticException diagnosticException) {
                                diagnosticException.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    break;
                }
            }
        }
    }
}

