/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.exec;

import com.sun.jade.apps.diags.exec.DiagCIMHelper;
import com.sun.jade.apps.diags.exec.DiagnosticHandler;
import com.sun.jade.apps.diags.exec.DiagnosticTestServiceImpl;
import com.sun.jade.apps.diags.exec.GlobalTestOptions;
import com.sun.jade.apps.diags.exec.TestRun;
import com.sun.jade.apps.diags.exec.TestRunEntry;
import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.Persistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.TestPersistence;
import com.sun.jade.cim.bean.CIM_DiagnosticTest;
import com.sun.jade.cim.bean.SADE_DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

class SessionTestQue
implements DiagnosticResultListener,
Runnable {
    private static final String LOG_TAG = "SessionTestQue";
    private DiagnosticResultListener sessionListener;
    private String userIdSessionId;
    private HashMap testQue;
    private HashMap elementKeyMap;
    private HashMap cachedResults;
    private Vector loopingTestKeys;
    private boolean isRunning;
    private Locale locale;
    private int maxPasses = 1;
    private int maxErrors = 1;
    private boolean verbose = false;
    Persistence persistence = null;
    TestPersistence testPersistence = null;
    DiagnosticTestServiceImpl testService;
    Vector replayEvents = null;
    private CIMBeanPersistence beanPersist;

    SessionTestQue(DiagnosticResultListener diagnosticResultListener, String string, DiagnosticTestServiceImpl diagnosticTestServiceImpl, Locale locale) throws RemoteException {
        this.sessionListener = diagnosticResultListener;
        this.userIdSessionId = string;
        this.testService = diagnosticTestServiceImpl;
        this.locale = locale;
        this.testQue = new HashMap();
        this.elementKeyMap = new HashMap();
        this.cachedResults = new HashMap();
        this.loopingTestKeys = new Vector();
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.start();
        if (Report.debug.isEnabled(LOG_TAG)) {
            Report.debug.log("Locale: " + locale);
        }
        try {
            this.persistence = PersistenceService.getService();
            this.testPersistence = this.persistence.getTestPersistence();
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
    }

    public void printTestQue() {
        Report.debug.log(LOG_TAG, (Object)"Printing Test Que");
        Report.debug.log(LOG_TAG, (Object)("Set: " + this.testQue.entrySet()));
        Report.debug.log(LOG_TAG, (Object)"PrintQue Done..............");
    }

    public String getUserIdSessionId() {
        return this.userIdSessionId;
    }

    public DiagnosticResultListener getSessionListener() {
        return this.sessionListener;
    }

    public synchronized void setSessionListener(DiagnosticResultListener diagnosticResultListener) {
        this.sessionListener = diagnosticResultListener;
        Report.debug.log(LOG_TAG, (Object)"Updated Session listener for this reconnect");
        Iterator iterator = this.cachedResults.values().iterator();
        while (iterator.hasNext()) {
            DiagnosticResult diagnosticResult = (DiagnosticResult)iterator.next();
            if (!diagnosticResult.getTestStateValueMap().equals(TestState.IN_PROGRESS)) continue;
            Report.debug.log(LOG_TAG, (Object)"Notifying with cached result");
            this.notifyListeners(diagnosticResult);
        }
    }

    public synchronized ElementKey addTest(DiagnosticTestInfo diagnosticTestInfo, MF mF) {
        try {
            Report.debug.log(LOG_TAG, (Object)("TestService: SessionTestQue.addTest Test = " + diagnosticTestInfo.getTestName() + " ManagementFacade = " + mF.getClassName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestRunEntry testRunEntry = new TestRunEntry(diagnosticTestInfo, mF);
        this.testQue.put(testRunEntry.getElementKey(), testRunEntry);
        this.notifyAll();
        return testRunEntry.getElementKey();
    }

    public void run() {
        while (this.isRunning) {
            TestRunEntry testRunEntry = this.waitForIdleTest();
            this.startDiagnosticHandler(testRunEntry);
        }
    }

    private synchronized TestRunEntry waitForIdleTest() {
        TestRunEntry testRunEntry = this.getIdleTest();
        while (testRunEntry == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            testRunEntry = this.getIdleTest();
        }
        return testRunEntry;
    }

    private void startDiagnosticHandler(TestRunEntry testRunEntry) {
        DiagnosticHandler diagnosticHandler = new DiagnosticHandler(testRunEntry, this);
    }

    private synchronized TestRunEntry getIdleTest() {
        Iterator iterator = this.testQue.values().iterator();
        while (iterator.hasNext()) {
            TestRunEntry testRunEntry = (TestRunEntry)iterator.next();
            int n = testRunEntry.getState();
            if (n != 0) continue;
            testRunEntry.setState(1);
            return testRunEntry;
        }
        return null;
    }

    public synchronized void notify(DiagnosticResultEvent diagnosticResultEvent) {
        try {
            DefinitionEventData definitionEventData;
            CIMBean[] cIMBeanArray;
            MessageCode messageCode;
            String[] stringArray;
            String string;
            String string2;
            String string3;
            String string4;
            CIMObjectPath cIMObjectPath;
            CIM_DiagnosticTest cIM_DiagnosticTest;
            String string5;
            int n;
            Object[] objectArray;
            String string6;
            Properties properties;
            String string7;
            DiagnosticResult diagnosticResult = diagnosticResultEvent.getResult();
            TestRunEntry testRunEntry = this.getTestForResult(diagnosticResult);
            Report.debug.log(LOG_TAG, (Object)"Start Notify");
            Report.debug.log(LOG_TAG, (Object)("Notify with result id = " + diagnosticResult.getExecutionID()));
            if (testRunEntry == null) {
                Report.debug.log(LOG_TAG, (Object)"Got event early--Saving for replay.");
                this.addToReplay(diagnosticResultEvent);
                return;
            }
            diagnosticResult.setUserID(this.userIdSessionId);
            if (!testRunEntry.getPostedStart()) {
                Report.debug.log(LOG_TAG, (Object)"Store test starting...");
                this.storeTestRun(testRunEntry.getTest(), diagnosticResult);
                string7 = testRunEntry.getMf().getName();
                properties = DevInfo.getDeviceProperties(testRunEntry.getMf());
                string6 = ".action.start.diagnosis." + properties.getProperty("TYPE") + "." + testRunEntry.getMf().getName();
                Report.debug.log(LOG_TAG, (Object)("TOPIC: " + string6));
                objectArray = new Object[]{testRunEntry.getMf().getName()};
                n = 2;
                string5 = "diagnostic";
                cIM_DiagnosticTest = DiagCIMHelper.getCIMtest(testRunEntry.getTest());
                cIMObjectPath = diagnosticResult.getMse().getCIMObjectPath();
                string4 = cIMObjectPath.toString();
                string3 = string4 + ",DiagnosticName=\"" + cIM_DiagnosticTest.getName() + "\"";
                Report.debug.log(LOG_TAG, (Object)("********* SUBJECT:" + string3));
                string2 = "DiagnosisStart";
                string = "device";
                stringArray = null;
                messageCode = new MessageCode("app.sade3.diag.information", 2);
                cIMBeanArray = new CIMBean[]{cIM_DiagnosticTest};
                definitionEventData = new DefinitionEventData(n, string5, string3, string6, string2, stringArray, messageCode.getLocalizedStringMessage(objectArray), string, cIMBeanArray);
                EventGenerator.generateEvent(definitionEventData);
                testRunEntry.setPostedStart(true);
            }
            if (!this.loopingTestKeys.contains(diagnosticResult.getElementKey())) {
                this.addToLoopingTestKeys(diagnosticResult.getElementKey());
            }
            if (!this.elementKeyMap.containsKey(testRunEntry.getElementKey())) {
                Report.debug.log(LOG_TAG, (Object)("Setting map " + testRunEntry.getElementKey() + " -> " + diagnosticResult.getElementKey()));
                this.elementKeyMap.put(testRunEntry.getElementKey(), diagnosticResult.getElementKey());
            }
            diagnosticResult.setElementKey(testRunEntry.getElementKey());
            if (this.cachedResults.containsKey(diagnosticResult.getElementKey())) {
                this.cachedResults.remove(diagnosticResult.getElementKey());
            }
            this.cachedResults.put(diagnosticResult.getElementKey(), diagnosticResult);
            Report.debug.log(LOG_TAG, (Object)("Remapped with result id = " + diagnosticResult.getExecutionID()));
            diagnosticResult.setTestResults(diagnosticResult.getTestResults(this.locale));
            this.notifyListeners(diagnosticResult);
            if (diagnosticResult.getTestCompletionTime() != null) {
                if (testRunEntry.getPostedEnd()) {
                    return;
                }
                Report.debug.log(LOG_TAG, (Object)"TestService:Store Completed Test");
                this.storeTestRun(testRunEntry.getTest(), diagnosticResult);
                testRunEntry.setPostedEnd(true);
                string7 = testRunEntry.getMf().getName();
                properties = DevInfo.getDeviceProperties(testRunEntry.getMf());
                string6 = ".action.update.diagnosis." + properties.getProperty("TYPE") + "." + testRunEntry.getMf().getName();
                Report.debug.log(LOG_TAG, (Object)("TOPIC: " + string6));
                objectArray = new Object[]{testRunEntry.getMf().getName(), diagnosticResult.getTestStateValueMap().getValue()};
                n = 2;
                string5 = "diagnostic";
                cIM_DiagnosticTest = DiagCIMHelper.getCIMtest(testRunEntry.getTest());
                cIMObjectPath = diagnosticResult.getMse().getCIMObjectPath();
                string4 = cIMObjectPath.toString();
                string3 = string4 + ",DiagnosticName=\"" + cIM_DiagnosticTest.getName() + "\"";
                Report.debug.log(LOG_TAG, (Object)("********* SUBJECT:" + string3));
                string2 = "DiagnosisStatus";
                string = "device";
                stringArray = null;
                messageCode = new MessageCode("app.sade3.diag.information", 3);
                cIMBeanArray = new CIMBean[]{cIM_DiagnosticTest};
                definitionEventData = new DefinitionEventData(n, string5, string3, string6, string2, stringArray, messageCode.getLocalizedStringMessage(objectArray), string, cIMBeanArray);
                EventGenerator.generateEvent(definitionEventData);
                this.processCounters(diagnosticResult, testRunEntry);
                this.evaluateGlobalOptions(diagnosticResult, testRunEntry);
                Report.debug.log(LOG_TAG, (Object)"Cleanup Test Ques");
                this.cleanUpTestQue(diagnosticResult, testRunEntry);
                this.getBeanPersistence().storeCIMBean((CIMBean)((Object)diagnosticResult));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized TestRunEntry getTestForResult(DiagnosticResult diagnosticResult) {
        TestRunEntry testRunEntry = (TestRunEntry)this.testQue.get(diagnosticResult.getElementKey());
        return testRunEntry;
    }

    public synchronized TestRunEntry getTestFromQue(ElementKey elementKey) {
        TestRunEntry testRunEntry = (TestRunEntry)this.testQue.get(elementKey);
        return testRunEntry;
    }

    public synchronized void putTestInQue(ElementKey elementKey, TestRunEntry testRunEntry) {
        this.testQue.put(elementKey, testRunEntry);
        this.replay();
    }

    public synchronized void removeTestFromQue(ElementKey elementKey) {
        this.testQue.remove(elementKey);
    }

    public synchronized void addToLoopingTestKeys(ElementKey elementKey) {
        this.loopingTestKeys.add(elementKey);
    }

    public synchronized void removeFromLoopingTestKeys(ElementKey elementKey) {
        this.loopingTestKeys.remove(elementKey);
    }

    public synchronized boolean abortTest(ElementKey elementKey) {
        boolean bl = true;
        TestRunEntry testRunEntry = (TestRunEntry)this.testQue.get(elementKey);
        if (testRunEntry == null) {
            Report.warning.log("No test run for key = " + elementKey.toString());
            return false;
        }
        DiagnosticResult diagnosticResult = testRunEntry.getDiagnosticResult();
        ElementKey elementKey2 = (ElementKey)this.elementKeyMap.get(elementKey);
        if (testRunEntry.getState() == 1) {
            try {
                MF mF = testRunEntry.getMf();
                DiagnosableHelper diagnosableHelper = (DiagnosableHelper)mF.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
                bl = diagnosableHelper.abortTest(elementKey2);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (DiagnosticException diagnosticException) {
                diagnosticException.printStackTrace();
            }
            if (bl) {
                testRunEntry.setState(3);
            }
        }
        return bl;
    }

    public synchronized boolean abortAllTests() {
        Report.debug.log(LOG_TAG, (Object)"Aborting Tests for this Session");
        boolean bl = true;
        Iterator iterator = this.testQue.values().iterator();
        while (iterator.hasNext()) {
            TestRunEntry testRunEntry = (TestRunEntry)iterator.next();
            int n = testRunEntry.getState();
            if (n != 1) continue;
            Report.debug.log(LOG_TAG, (Object)"Found running test, Aborting...");
            DiagnosticResult diagnosticResult = testRunEntry.getDiagnosticResult();
            try {
                ElementKey elementKey = diagnosticResult.getElementKey();
                Report.debug.log(LOG_TAG, (Object)("Got key:" + elementKey));
                MF mF = testRunEntry.getMf();
                DiagnosableHelper diagnosableHelper = (DiagnosableHelper)mF.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
                bl = diagnosableHelper.abortTest(elementKey);
                if (!bl) {
                    return bl;
                }
                testRunEntry.setState(3);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (DiagnosticException diagnosticException) {
                diagnosticException.printStackTrace();
            }
        }
        return bl;
    }

    private void storeTestRun(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResult diagnosticResult) {
    }

    public Vector viewSessionLog(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            Collection collection = this.getBeanPersistence().retrieveBeans("SADE_DiagnosticResult");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SADE_DiagnosticResult sADE_DiagnosticResult = (SADE_DiagnosticResult)iterator.next();
                if (!string.equals(sADE_DiagnosticResult.getUserID())) continue;
                vector.add(new DiagnosticResult(sADE_DiagnosticResult).toString());
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Results not found.");
        }
        return vector;
    }

    public TestRun[] getArchivedTestRuns(String string) {
        TestRun[] testRunArray = null;
        try {
            testRunArray = this.testPersistence.retrieveUserTestRuns(this.userIdSessionId);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
        catch (NoDataFoundException noDataFoundException) {
            noDataFoundException.printStackTrace();
        }
        return testRunArray;
    }

    public synchronized boolean validateSettings(ElementKey elementKey) {
        boolean bl = false;
        try {
            TestRunEntry testRunEntry = (TestRunEntry)this.testQue.get(elementKey);
            DiagnosticTestInfo diagnosticTestInfo = testRunEntry.getTest();
            MF mF = testRunEntry.getMf();
            DiagnosableHelper diagnosableHelper = (DiagnosableHelper)mF.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
            bl = diagnosableHelper.validateTest(diagnosticTestInfo);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (DiagnosticException diagnosticException) {
            diagnosticException.printStackTrace();
        }
        return bl;
    }

    public void setGlobalSessionOptions(int n, int n2, boolean bl) {
        this.maxPasses = n;
        this.maxErrors = n2;
        this.verbose = bl;
    }

    public GlobalTestOptions getGlobalSessionOptions() {
        GlobalTestOptions globalTestOptions = new GlobalTestOptions(this.maxPasses, this.maxErrors, this.verbose);
        return globalTestOptions;
    }

    private synchronized void notifyListeners(DiagnosticResult diagnosticResult) {
        HashMap hashMap = DiagnosticTestServiceImpl.allSessionsListenerList;
        if (!hashMap.containsKey(this.userIdSessionId)) {
            try {
                this.sessionListener.notify(new DiagnosticResultEvent(diagnosticResult, this.userIdSessionId));
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                Report.debug.log(LOG_TAG, (Object)"Single Session Listener that SessionQue is trying to notify is gone!");
            }
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            DiagnosticResultListener diagnosticResultListener = (DiagnosticResultListener)iterator.next();
            try {
                diagnosticResultListener.notify(new DiagnosticResultEvent(diagnosticResult, this.userIdSessionId));
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                Report.debug.log(LOG_TAG, (Object)"An All Session Listener that SessionQue is trying to notify is gone!");
                DiagnosticTestServiceImpl.allSessionsListenerList.remove(this.userIdSessionId);
            }
        }
    }

    Collection getTestRunEntries() {
        return this.testQue.values();
    }

    DiagnosticTestServiceImpl getTestService() {
        return this.testService;
    }

    private void processCounters(DiagnosticResult diagnosticResult, TestRunEntry testRunEntry) {
        if (diagnosticResult.getTestStateValueMap().equals(TestState.FAILED)) {
            testRunEntry.IncrementErrorCount(1);
        } else if (diagnosticResult.getTestStateValueMap().equals(TestState.PASSED)) {
            int n = testRunEntry.getPassCount();
            testRunEntry.setPassCount(++n);
        }
        MessageCode messageCode = new MessageCode("app.sade3.diag.information", 1);
        Object[] objectArray = new Object[]{new Integer(this.maxPasses), new Integer(testRunEntry.getPassCount())};
        if (Report.debug.isEnabled(LOG_TAG)) {
            Report.debug.log(messageCode.toString(objectArray));
        }
    }

    private void evaluateGlobalOptions(DiagnosticResult diagnosticResult, TestRunEntry testRunEntry) {
        if (diagnosticResult.getTestStateValueMap().equals(TestState.STOPPED) || testRunEntry.getState() == 3) {
            testRunEntry.setState(2);
            return;
        }
        if (!(this.maxPasses != 0 && testRunEntry.getPassCount() >= this.maxPasses || this.maxErrors != 0 && testRunEntry.getErrorCount() >= this.maxErrors)) {
            testRunEntry.setState(0);
            this.notifyAll();
        } else {
            testRunEntry.setState(2);
        }
    }

    private synchronized void cleanUpTestQue(DiagnosticResult diagnosticResult, TestRunEntry testRunEntry) {
        if (testRunEntry.getState() == 2 || testRunEntry.getState() == 3) {
            this.removeTestFromQue(testRunEntry.getDiagnosticResult().getElementKey());
            this.removeTestFromQue(testRunEntry.getElementKey());
            this.cachedResults.remove(testRunEntry.getElementKey());
            this.cachedResults.remove(testRunEntry.getDiagnosticResult().getElementKey());
            Report.debug.log(LOG_TAG, (Object)("REMOVED " + testRunEntry.getElementKey()));
            Report.debug.log(LOG_TAG, (Object)("REMOVED " + testRunEntry.getDiagnosticResult().getElementKey()));
            Enumeration enumeration = this.loopingTestKeys.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ElementKey elementKey = (ElementKey)enumeration.nextElement();
                    TestRunEntry testRunEntry2 = this.getTestFromQue(elementKey);
                    if (testRunEntry2 == null || testRunEntry2.getDiagnosticResult().getTestCompletionTime() == null) continue;
                    Report.debug.log(LOG_TAG, (Object)("REMOVED " + elementKey));
                    this.removeTestFromQue(elementKey);
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                    Report.debug.log(LOG_TAG, (Object)"TestKeys has no more elements");
                }
            }
        }
    }

    private void replay() {
        if (this.replayEvents != null) {
            Report.debug.log(LOG_TAG, (Object)"Replay early events...");
            Vector vector = this.replayEvents;
            this.replayEvents = null;
            int n = 0;
            while (n < vector.size()) {
                this.notify((DiagnosticResultEvent)vector.get(n));
                ++n;
            }
        }
    }

    private void addToReplay(DiagnosticResultEvent diagnosticResultEvent) {
        if (this.replayEvents == null) {
            this.replayEvents = new Vector();
        }
        this.replayEvents.add(diagnosticResultEvent);
    }

    private CIMBeanPersistence getBeanPersistence() {
        if (this.beanPersist == null) {
            try {
                this.beanPersist = PersistenceService.getService().getCIMBeanPersistence();
            }
            catch (ConnectionException connectionException) {
                Report.error.log("Error Finding CIM Persistence");
            }
        }
        return this.beanPersist;
    }
}

