/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.lib;

import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.diags.lib.MonitorTest;
import com.sun.jade.cim.bean.CIM_DiagnosticTest;
import com.sun.jade.cim.bean.CIM_DiagnosticTestForMSE;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.wbem.CIMClientUser;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMClient;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class DiagnosableHelperImpl
implements DiagnosableHelper {
    private ElementKey key;
    private Vector testCache;
    private MF mf;
    private CIMClientUser ccu;
    private CIMObjectPath system;
    private HashMap map;
    private String systemName;
    private String systemClassName;

    public DiagnosableHelperImpl() throws RemoteException {
    }

    public DiagnosableHelperImpl(MF mF, CIMClientUser cIMClientUser) throws RemoteException {
        this.mf = mF;
        this.ccu = cIMClientUser;
        this.systemName = mF.getName();
        this.systemClassName = mF.getClassName();
        this.system = new CIMObjectPath(this.systemClassName);
        this.system.addKey("Name", new CIMValue((Object)this.systemName));
        this.key = new ElementKey(this.system.toString());
        this.map = new HashMap();
    }

    public String getHelperName() throws RemoteException {
        return "Diagnostic";
    }

    public String getSystemName() throws RemoteException {
        return this.systemName;
    }

    public String getSystemClassName() throws RemoteException {
        return this.systemClassName;
    }

    public MF getMF() throws RemoteException {
        return this.mf;
    }

    public DiagnosticTestInfo[] getDiagnosticTests() throws RemoteException, DiagnosticException {
        DiagnosticTestInfo[] diagnosticTestInfoArray;
        Vector<Serializable> vector = new Vector<Serializable>();
        CIMClient cIMClient = null;
        try {
            Enumeration enumeration;
            cIMClient = this.createCIMClient();
            if (cIMClient == null) {
                Report.error.log("Couldn't get CIM client from MF.");
                throw new DiagnosticException("DIAG_ERR_OUT_OF_RESOURCES");
            }
            diagnosticTestInfoArray = "CIM_DiagnosticTestForMSE";
            CIMObjectPath cIMObjectPath = new CIMObjectPath((String)diagnosticTestInfoArray);
            Report.debug.log("Getting instances of CIM_DiagnosticTestForMSE for " + this.system.toString());
            boolean bl = false;
            if (this.testCache != null) {
                enumeration = this.testCache.elements();
            } else {
                enumeration = cIMClient.enumerateInstances(cIMObjectPath, true, false, false, false, null);
                bl = true;
                this.testCache = new Vector();
            }
            Report.debug.log("Building test list");
            while (enumeration.hasMoreElements()) {
                DiagnosticSetting diagnosticSetting;
                Serializable serializable;
                CIMValue cIMValue;
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                if (bl) {
                    this.testCache.add(cIMInstance);
                }
                CIM_DiagnosticTestForMSE cIM_DiagnosticTestForMSE = new CIM_DiagnosticTestForMSE();
                cIM_DiagnosticTestForMSE.readCIMInstance(cIMInstance);
                CIMObjectPath cIMObjectPath2 = null;
                CIMProperty cIMProperty = cIMInstance.getProperty("Dependent");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    cIMObjectPath2 = (CIMObjectPath)cIMValue.getValue();
                }
                if (!this.isInSystem(cIMObjectPath2)) continue;
                CIMObjectPath cIMObjectPath3 = cIM_DiagnosticTestForMSE.getAntecedent();
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath();
                cIMObjectPath4.setObjectName(cIMObjectPath3.getObjectName());
                cIMObjectPath4.setKeys(cIMObjectPath3.getKeys());
                CIMInstance cIMInstance2 = cIMClient.getInstance(cIMObjectPath4, false, false, false, null);
                CIM_DiagnosticTest cIM_DiagnosticTest = new CIM_DiagnosticTest();
                cIM_DiagnosticTest.readCIMInstance(cIMInstance2);
                CIMClass cIMClass = null;
                Report.debug.log("get setting class");
                cIMClass = this.getSettingClassFromName(cIMClient, cIM_DiagnosticTest);
                if (cIMClass == null) {
                    cIMClass = this.getSettingClassFromInst(cIMClient, cIM_DiagnosticTest);
                }
                if (cIMClass != null) {
                    Object object;
                    Report.debug.log("Setting class = \n" + cIMClass);
                    serializable = cIMClass.getProperties();
                    diagnosticSetting = new DiagnosticSetting(cIMClass.getName());
                    int n = 0;
                    while (n < ((Vector)serializable).size()) {
                        block15: {
                            object = new TestParameter();
                            Report.debug.log("Adding param " + n + " = \n" + ((Vector)serializable).get(n));
                            try {
                                ((TestParameter)object).readCIMProperty((CIMProperty)((Vector)serializable).get(n));
                            }
                            catch (Exception exception) {
                                Report.error.log("Error adding param" + exception.toString());
                                break block15;
                            }
                            diagnosticSetting.addParameter((TestParameter)object);
                        }
                        ++n;
                    }
                    object = cIMClass.newInstance();
                    diagnosticSetting.readCIMInstance((CIMInstance)object);
                    diagnosticSetting.setCreationClassName(object.getClassName());
                    Report.debug.log(cIMClass);
                    Report.debug.log(cIMClass.newInstance());
                } else {
                    diagnosticSetting = new DiagnosticSetting();
                    diagnosticSetting.setSettingID(cIM_DiagnosticTest.getCreationClassName() + ":" + cIM_DiagnosticTest.getName());
                }
                diagnosticSetting.pruneUnsupportedSettings(cIM_DiagnosticTest.getCharacteristics());
                serializable = new DiagnosticTestInfo(cIM_DiagnosticTest, cIMObjectPath2, diagnosticSetting);
                vector.add(serializable);
            }
            this.closeCIMClient(cIMClient);
        }
        catch (CIMException cIMException) {
            if (cIMClient != null) {
                this.closeCIMClient(cIMClient);
            }
            Report.error.log((Object)cIMException);
            throw new DiagnosticException((Exception)((Object)cIMException), "DIAG_ERR_FAILED");
        }
        diagnosticTestInfoArray = new DiagnosticTestInfo[vector.size()];
        vector.toArray(diagnosticTestInfoArray);
        vector.toArray(diagnosticTestInfoArray);
        return diagnosticTestInfoArray;
    }

    private CIMClass getSettingClassFromName(CIMClient cIMClient, CIM_DiagnosticTest cIM_DiagnosticTest) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_DiagnosticSetting");
        Enumeration enumeration = cIMClient.enumerateClassNames(cIMObjectPath, true);
        String string = cIM_DiagnosticTest.getName() + "Setting";
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
            if (!string.equals(cIMObjectPath2.getObjectName())) continue;
            return cIMClient.getClass(cIMObjectPath2, true, true, false, null);
        }
        return null;
    }

    private CIMClass getSettingClassFromInst(CIMClient cIMClient, CIM_DiagnosticTest cIM_DiagnosticTest) throws CIMException {
        String string = cIM_DiagnosticTest.getCreationClassName() + ":" + cIM_DiagnosticTest.getName();
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_DiagnosticSetting");
        return null;
    }

    public boolean validateTest(DiagnosticTestInfo diagnosticTestInfo) throws RemoteException {
        DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest();
        Vector vector = diagnosticSetting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            if (!((TestParameter)vector.get(n)).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized DiagnosticResult runTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResultListener diagnosticResultListener) throws RemoteException, DiagnosticException {
        Object object;
        Object object2;
        if (diagnosticTestInfo == null || diagnosticResultListener == null) {
            throw new DiagnosticException();
        }
        CIMObjectPath cIMObjectPath = diagnosticTestInfo.getMSE();
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        CIMClient cIMClient = null;
        diagnosticResult.setMse(new ReferenceForMSE(cIMObjectPath));
        try {
            cIMClient = this.createCIMClient();
            if (cIMClient == null) {
                throw new DiagnosticException("DIAG_ERR_OUT_OF_RESOURCES");
            }
            object2 = new CIMObjectPath(diagnosticTestInfo.getTestClassName());
            object2.addKey("Name", new CIMValue((Object)diagnosticTestInfo.getTestName()));
            object2.addKey("CreationClassName", new CIMValue((Object)diagnosticTestInfo.getTestClassName()));
            object = diagnosticTestInfo.getSettingsForTest();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(object.getCreationClassName());
            String string = diagnosticTestInfo.getTestClassName() + ":" + diagnosticTestInfo.getTestName();
            cIMObjectPath2.addKey("SettingID", new CIMValue((Object)string));
            object.setSettingID(string);
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(object.getCreationClassName());
            System.out.println("Setting class = " + cIMObjectPath3);
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath3, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            ((DiagnosticSetting)((Object)object)).writeCIMInstance(cIMInstance);
            Report.debug.log(cIMInstance);
            Report.debug.log(cIMObjectPath2);
            System.out.println("Setting=" + cIMInstance);
            try {
                cIMClient.setInstance(cIMObjectPath2, cIMInstance);
            }
            catch (CIMException cIMException) {
                cIMClient.createInstance(cIMObjectPath2, cIMInstance);
            }
            Vector<CIMValue> vector = new Vector<CIMValue>(2);
            Vector vector2 = new Vector(1);
            CIMValue cIMValue = new CIMValue((Object)cIMObjectPath);
            vector.add(cIMValue);
            cIMValue = new CIMValue((Object)cIMObjectPath2);
            vector.add(cIMValue);
            Report.debug.log("runTest: invoke method:");
            Report.debug.log("   copTest= " + object2);
            Report.debug.log("   name   = RunTest");
            Report.debug.log("   inParams = " + vector);
            Report.debug.log("   outParams = " + vector2);
            CIMValue cIMValue2 = cIMClient.invokeMethod(object2, "RunTest", vector, vector2);
            if (vector2.size() != 1) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            CIMValue cIMValue3 = (CIMValue)vector2.get(0);
            CIMObjectPath cIMObjectPath4 = (CIMObjectPath)cIMValue3.getValue();
            CIMInstance cIMInstance2 = cIMClient.getInstance(cIMObjectPath4, false, false, false, null);
            Report.debug.log("Result = " + cIMObjectPath4);
            if (cIMInstance2 != null) {
                diagnosticResult.readCIMInstance(cIMClient.getInstance(cIMObjectPath4, false, false, false, null));
                this.addTestData(diagnosticResult.getExecutionID(), (CIMObjectPath)object2, cIMObjectPath4, cIMObjectPath);
            } else {
                diagnosticResult.setTestState(TestState.FAILED);
            }
            this.closeCIMClient(cIMClient);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            Report.error.log((Object)cIMException);
            if (cIMClient != null) {
                this.closeCIMClient(cIMClient);
            }
            diagnosticResult.setTestState(TestState.FAILED);
            return diagnosticResult;
        }
        object2 = new MonitorTest(diagnosticTestInfo, this, new ElementKey(diagnosticResult.getExecutionID()), diagnosticResultListener);
        object = new Thread((Runnable)object2);
        ((Thread)object).start();
        return diagnosticResult;
    }

    public synchronized DiagnosticResult getTestResults(ElementKey elementKey) throws RemoteException, DiagnosticException {
        if (elementKey == null) {
            throw new DiagnosticException();
        }
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        CIMClient cIMClient = null;
        try {
            cIMClient = this.createCIMClient();
            if (cIMClient == null) {
                throw new DiagnosticException("DIAG_ERR_OUT_OF_RESOURCES");
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_DiagnosticResult");
            cIMObjectPath.addKey("ExecutionID", new CIMValue((Object)elementKey.toString()));
            Report.debug.log("Getting result " + cIMObjectPath);
            CIMInstance cIMInstance = cIMClient.getInstance(cIMObjectPath, false, false, false, null);
            if (cIMInstance != null) {
                diagnosticResult.readCIMInstance(cIMInstance);
                Report.debug.log("Result = " + diagnosticResult);
            } else {
                Report.debug.log("NO RESULT FOUND");
                diagnosticResult.setTestState(TestState.FAILED);
            }
            if (diagnosticResult.getIsPackageValue()) {
                this.getPackageResults(cIMClient, diagnosticResult);
            }
            this.closeCIMClient(cIMClient);
        }
        catch (CIMException cIMException) {
            if (cIMClient != null) {
                this.closeCIMClient(cIMClient);
            }
            Report.error.log((Object)cIMException);
            throw new DiagnosticException((Exception)((Object)cIMException), "DIAG_ERR_FAILED");
        }
        return diagnosticResult;
    }

    public synchronized boolean abortTest(ElementKey elementKey) throws RemoteException, DiagnosticException {
        boolean bl = false;
        try {
            CIMClient cIMClient = this.createCIMClient();
            CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_DiagnosticResultForTest");
            TestData testData = (TestData)this.map.get(elementKey.toString());
            if (testData == null) {
                Report.debug.log("No test for id = " + elementKey);
                throw new CIMException("CIM_ERR_FAILED");
            }
            CIMObjectPath cIMObjectPath2 = testData.test;
            CIMObjectPath cIMObjectPath3 = testData.result;
            CIMObjectPath cIMObjectPath4 = testData.mse;
            Report.debug.log("abortTest:" + cIMObjectPath2 + "\n" + cIMObjectPath4 + "\n" + cIMObjectPath3);
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMValue cIMValue = new CIMValue((Object)cIMObjectPath4);
            vector.add(cIMValue);
            cIMValue = new CIMValue((Object)cIMObjectPath3);
            vector.add(cIMValue);
            Report.debug.log("abortTest: invoke method:");
            Report.debug.log("   copTest= " + cIMObjectPath2);
            Report.debug.log("   name   = DiscontinueTest");
            Report.debug.log("   inParams = " + vector);
            Report.debug.log("   outParams = " + vector2);
            CIMValue cIMValue2 = cIMClient.invokeMethod(cIMObjectPath2, "DiscontinueTest", vector, vector2);
            switch (((UnsignedInt32)cIMValue2.getValue()).intValue()) {
                case 0: {
                    if (vector2.size() == 1) break;
                    Report.debug.log("No value returned from abort method.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 1: {
                    Report.debug.log("ERROR aborting test.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 2: {
                    Report.debug.log("Abort Test not implemented for this test.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 3: {
                    Report.debug.log("Abort failed: out of resources.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                default: {
                    Report.debug.log("Abort : Unknown return code.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
            }
            CIMValue cIMValue3 = (CIMValue)vector2.get(0);
            bl = (Boolean)cIMValue3.getValue();
        }
        catch (CIMException cIMException) {
            Report.error.log((Object)cIMException);
            throw new DiagnosticException((Exception)((Object)cIMException), "DIAG_ERR_FAILED");
        }
        return bl;
    }

    private boolean isInSystem(CIMObjectPath cIMObjectPath) {
        return true;
    }

    private void getPackageResults(CIMClient cIMClient, DiagnosticResult diagnosticResult) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_DiagnosticResultInPackage");
        Enumeration enumeration = cIMClient.enumerateInstances(cIMObjectPath, true, true, false, false, null);
        Report.debug.log("DiagnosableHelper.getPackageResults");
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath2;
            CIMValue cIMValue;
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            CIMProperty cIMProperty = cIMInstance.getProperty("PackageResult");
            if (cIMProperty == null || (cIMValue = cIMProperty.getValue()) == null || !this.resultMatchesPath(diagnosticResult, cIMObjectPath2 = (CIMObjectPath)cIMValue.getValue()) || (cIMProperty = cIMInstance.getProperty("Result")) == null || (cIMValue = cIMProperty.getValue()) == null) continue;
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMValue.getValue();
            Report.debug.log("DiagnosableHelper.getPackageResults path = " + cIMObjectPath3);
            CIMInstance cIMInstance2 = cIMClient.getInstance(cIMObjectPath3, false, false, false, null);
            if (cIMInstance2 == null) continue;
            DiagnosticResult diagnosticResult2 = new DiagnosticResult();
            diagnosticResult2.readCIMInstance(cIMInstance2);
            diagnosticResult.add(diagnosticResult2);
            Report.debug.log("add sub result = " + cIMInstance2);
        }
    }

    private boolean resultMatchesPath(DiagnosticResult diagnosticResult, CIMObjectPath cIMObjectPath) {
        if (diagnosticResult == null) {
            return false;
        }
        if (cIMObjectPath == null) {
            return false;
        }
        String string = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("ExecutionID") || (cIMValue = cIMProperty.getValue()) == null || !(string = (String)cIMValue.getValue()).equals(diagnosticResult.getExecutionID())) continue;
            return true;
        }
        return false;
    }

    private CIMClient createCIMClient() throws CIMException {
        if (this.ccu == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return this.ccu.getCIMClient();
    }

    private void closeCIMClient(CIMClient cIMClient) {
        this.ccu.finished(cIMClient);
    }

    private synchronized void addTestData(String string, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMObjectPath cIMObjectPath3) {
        this.map.put(string, new TestData(cIMObjectPath, cIMObjectPath2, cIMObjectPath3));
    }

    synchronized void testFinished(ElementKey elementKey) {
        this.map.remove(elementKey.toString());
    }

    class TestData {
        CIMObjectPath test;
        CIMObjectPath result;
        CIMObjectPath mse;

        TestData(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMObjectPath cIMObjectPath3) {
            this.test = cIMObjectPath;
            this.result = cIMObjectPath2;
            this.mse = cIMObjectPath3;
        }
    }

    public static class Test
    extends UnitTest {
        public void testErrors() throws Exception {
            Report.error.disableLogging();
            DiagnosableHelperImpl diagnosableHelperImpl = new DiagnosableHelperImpl();
            try {
                diagnosableHelperImpl.getDiagnosticTests();
                this.fail("Should throw Exception");
            }
            catch (DiagnosticException diagnosticException) {
                // empty catch block
            }
            try {
                diagnosableHelperImpl.runTest(null, null);
                this.fail("Should throw Exception");
            }
            catch (DiagnosticException diagnosticException) {
                // empty catch block
            }
            try {
                diagnosableHelperImpl.getTestResults(new ElementKey());
                this.fail("Should throw Exception");
            }
            catch (DiagnosticException diagnosticException) {
                // empty catch block
            }
            try {
                diagnosableHelperImpl.abortTest(new ElementKey());
                this.fail("Should throw Exception");
            }
            catch (DiagnosticException diagnosticException) {
                // empty catch block
            }
            Report.error.enableLogging();
        }
    }
}

