/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.discovery;

import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.NWS_Agent;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DefinitionEventGenerator;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class AgentInstallEvent {
    private static final String MESSAGE_CODE_BASE = "event.agent.sade3.definition";
    private static final int AGENT_INSTALL_CODE = 1;
    private static final int HEARTBEAT_CODE = 2;
    private static final int AGENT_BOOT_CODE = 12;
    private static final String TAG = "Installer";
    public static final String sccs_id = "@(#)AgentInstallEvent.java\t1.9 01/30/03 SMI";

    static void postBootEvent(NWS_Agent nWS_Agent) {
        try {
            int n = 2;
            String string = EventConstants.SOURCE_PREFIX + TAG;
            String string2 = nWS_Agent.getCIMObjectPath().toString();
            String string3 = ".action.end.boot.software.agent";
            String string4 = "Boot";
            DefinitionEventData definitionEventData = new DefinitionEventData(n, string, string2, string3, string4, "definition", new CIMBean[]{nWS_Agent});
            MessageCode messageCode = new MessageCode(MESSAGE_CODE_BASE, 12);
            definitionEventData.setEventCode(messageCode.getMessageCode());
            definitionEventData.setDescription(messageCode.getLocalizedStringMessage());
            EventGenerator.generateEvent(definitionEventData);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Boot event not generated");
        }
    }

    static void postStorADEInstalledEvent() {
        NWS_Agent nWS_Agent = null;
        try {
            Object object;
            nWS_Agent = AgentInstallEvent.getPersistedAgent(StoradeEnvironment.getAgentBean());
            DeviceConfig deviceConfig = StoradeEnvironment.getDeviceConfig();
            String string = deviceConfig.getProperty("ran");
            if ("Y".equals(string)) {
                AgentInstallEvent.postBootEvent(nWS_Agent);
                return;
            }
            String string2 = nWS_Agent.getResidentHostID() + "/" + nWS_Agent.getCaption() + "/" + TAG;
            DefinitionEventData definitionEventData = new DefinitionEventData(2, string2, nWS_Agent.getCIMObjectPath().toString(), ".definition.create.platform.agent", "AgentDiscovery", "definition", new CIMBean[]{nWS_Agent});
            try {
                object = InetAddress.getLocalHost();
                definitionEventData.setSubjectEnclosureIP(((InetAddress)object).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            object = new MessageCode(MESSAGE_CODE_BASE, 1);
            definitionEventData.setEventCode(((MessageCode)object).getMessageCode());
            definitionEventData.setDescription(((MessageCode)object).getLocalizedStringMessage());
            EventGenerator.generateEvent(definitionEventData);
            deviceConfig.setProperty("ran", "Y");
            deviceConfig.store();
            AgentInstallEvent.postBootEvent(nWS_Agent);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in posting StorADE discovery Event");
        }
        Report.debug.log(TAG, (Object)("Install Event sent:" + nWS_Agent == null ? "null" : nWS_Agent.toBeanXML()));
    }

    static NWS_Agent getPersistedAgent(NWS_Agent nWS_Agent) {
        CIMBean cIMBean = null;
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceService.getService().getCIMBeanPersistence();
            try {
                cIMBean = cIMBeanPersistence.retrieveBean((CIMBean)nWS_Agent);
            }
            catch (Exception exception) {
                cIMBeanPersistence.storeCIMBean((CIMBean)nWS_Agent);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Error Finding Persistence");
        }
        if (cIMBean != null && cIMBean instanceof NWS_Agent) {
            return (NWS_Agent)cIMBean;
        }
        return nWS_Agent;
    }

    static void initStorADEHeartbeat(Properties properties) {
        Object object;
        Object object2;
        Timer timer = new Timer();
        String string = properties.getProperty("InstallerService.heartbeatInterval");
        String string2 = properties.getProperty("InstallerService.heartbeatHourOfDay");
        long l = 86400000L;
        try {
            l = Long.valueOf(string) * 60L * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            object2 = "Unable to  get StorADE Heartbeat Event interval from heartbeatInterval  property: " + string + ".  Using default interval of 24 hours.";
            Report.error.log(numberFormatException, object2);
        }
        int n = 24;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = "Unable to  get StorADE Heartbeat Hour of Post from heartbeatHourOfDay  property: " + string2 + ".  Using default hour of 24.";
            Report.error.log(numberFormatException, object);
        }
        object2 = Calendar.getInstance();
        object = new GregorianCalendar(((Calendar)object2).get(1), ((Calendar)object2).get(2), ((Calendar)object2).get(5), n, 0, 0);
        Date date = ((Calendar)object).getTime();
        StorADEHeartbeatTask storADEHeartbeatTask = new StorADEHeartbeatTask();
        timer.scheduleAtFixedRate((TimerTask)storADEHeartbeatTask, date, l);
    }

    public static void postHeartbeatEvent() {
        Object object;
        int n = 2;
        String string = ".definition.audit.platform.agent";
        String string2 = "Heartbeat";
        NWS_Agent nWS_Agent = StoradeEnvironment.getAgentBean();
        nWS_Agent = AgentInstallEvent.getPersistedAgent(nWS_Agent);
        String string3 = nWS_Agent.getCIMObjectPath().toString();
        String string4 = nWS_Agent.getResidentHostID() + "/" + nWS_Agent.getCaption() + "/" + TAG;
        DefinitionEventData definitionEventData = new DefinitionEventData(n, string4, string3, string, string2, "Heartbeat", new CIMBean[]{nWS_Agent});
        try {
            object = InetAddress.getLocalHost();
            definitionEventData.setSubjectEnclosureIP(((InetAddress)object).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        object = new MessageCode(MESSAGE_CODE_BASE, 2);
        definitionEventData.setEventCode(((MessageCode)object).getMessageCode());
        definitionEventData.setDescription(((MessageCode)object).getLocalizedStringMessage());
        EventGenerator.generateEvent(definitionEventData);
    }

    static void initStorADEAuditEvents(Properties properties) {
        Object object;
        Timer timer = new Timer();
        String string = properties.getProperty("InstallerService.auditInterval");
        String string2 = properties.getProperty("InstallerService.auditHourOfDay");
        long l = 604800000L;
        try {
            l = Long.valueOf(string) * 24L * 60L * 60L * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            object = "Unable to  get StorADE Heartbeat Event interval from heartbeatInterval  property: " + string + ".  Using default interval of 7 days.";
            Report.error.log(numberFormatException, object);
        }
        int n = 0;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = " Unable to  get StorADE Heartbeat Hour of Post from heartbeatHourOfDay  property: " + string2 + ".  Using default hour of 13.";
            Report.error.log(numberFormatException, (Object)string3);
        }
        object = Calendar.getInstance();
        int n2 = ((Calendar)object).get(11);
        n = n >= 0 && n < 23 ? ++n : 1;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(((Calendar)object).get(1), ((Calendar)object).get(2), ((Calendar)object).get(5), n, 0, 0);
        Date date = gregorianCalendar.getTime();
        StorADEAuditTask storADEAuditTask = new StorADEAuditTask();
        timer.scheduleAtFixedRate((TimerTask)storADEAuditTask, date, l);
    }

    public static void postAuditEvent() {
        MF[] mFArray = InstallerServiceFinder.getInstallerService().getInstalledSystems();
        if (mFArray != null) {
            int n = 0;
            while (n < mFArray.length) {
                MF mF = mFArray[n];
                if (mF != null) {
                    Properties properties = DevInfo.getDeviceProperties(mF);
                    if ("host".equalsIgnoreCase(properties.getProperty("RESOURCE_TYPE"))) {
                        DefinitionEventGenerator.generateHostEvent(mF, 5);
                    } else {
                        DefinitionEventGenerator.generateDeviceEvent(mF, 0);
                    }
                }
                ++n;
            }
        }
    }

    private static String getName() {
        return StoradeEnvironment.getHostID();
    }

    protected static class StorADEAuditTask
    extends TimerTask {
        protected StorADEAuditTask() {
        }

        public void run() {
            AgentInstallEvent.postAuditEvent();
        }
    }

    protected static class StorADEHeartbeatTask
    extends TimerTask {
        protected StorADEHeartbeatTask() {
        }

        public void run() {
            AgentInstallEvent.postHeartbeatEvent();
        }
    }
}

