/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.CIMBeanHelper;
import com.sun.jade.apps.persistence.service.CIMBeanPersistenceImpl;
import com.sun.jade.apps.persistence.service.CIMTableUtil;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;

public abstract class AbstractCIMBeanHelper
implements CIMBeanHelper {
    protected PreparedStatement existsSelectStmt = null;
    protected PreparedStatement updateStmt = null;
    protected PreparedStatement insertStmt = null;
    protected PreparedStatement selectStmt = null;
    protected PreparedStatement meInsertStmt = null;
    protected String[] columnNames;
    protected String tableName;
    protected String[] keys;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getBeanID(CIMBean cIMBean) throws ConnectionException {
        long l = -1L;
        if (cIMBean == null) return l;
        Connection connection = PersistenceService.getConnection();
        try {
            try {
                ResultSet resultSet;
                this.existsSelectStmt = connection.prepareStatement(CIMTableUtil.getExistsSelectStmt(this.tableName, this.keys));
                if (this.keys != null) {
                    this.setExistsSelectKeyValues(cIMBean);
                }
                if ((resultSet = this.existsSelectStmt.executeQuery()).next()) {
                    l = resultSet.getLong(1);
                }
                l = -1L;
            }
            catch (SQLException sQLException) {
                String string = "Unable to determine if CIM Bean already exists in the database.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return l;
    }

    public synchronized void update(CIMBean cIMBean, long l) throws ConnectionException {
        Connection connection = PersistenceService.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                this.updateStmt = connection.prepareStatement(CIMTableUtil.getUpdateStmt(this.tableName, this.columnNames, this.keys));
                this.updateStmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                this.setUpdateStmtValues(cIMBean);
                this.updateStmt.setLong(this.columnNames.length + 2, l);
                this.updateStmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string = "Unable to store CIM Bean.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public synchronized void insert(CIMBean cIMBean) throws ConnectionException {
        Connection connection = PersistenceService.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                this.insertStmt = connection.prepareStatement(CIMTableUtil.getInsertStmt(this.tableName, this.columnNames));
                this.setInsertStmtValues(cIMBean);
                this.insertStmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                this.insertStmt.executeUpdate();
                String string = "com.sun.jade.cim.bean.CIM_ManagedElement";
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string2 = "Unable to store bean.  Can't find " + string + ".";
                    Report.error.log(string2);
                    throw new ConnectionException(string2);
                }
                if (clazz.isAssignableFrom(cIMBean.getClass())) {
                    long l = this.getBeanID(cIMBean);
                    this.meInsertStmt = connection.prepareStatement("INSERT INTO ManagedElementSubjectLookup( meID, meType, subject, creationClassName, deviceCreationClassName, deviceID, fruNumber, identifyingNumber, name, systemCreationClassName, systemName, tag, vendor) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    this.meInsertStmt.setLong(1, l);
                    this.meInsertStmt.setString(2, this.tableName);
                    this.meInsertStmt.setString(3, cIMBean.getCIMObjectPath().toString());
                    this.setMEInsertStmtValues(cIMBean);
                    this.meInsertStmt.executeUpdate();
                }
                String string3 = "com.sun.jade.cim.util.CIMAssociationBean";
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string4 = "Unable to store bean.  Can't find " + string3 + ".";
                    Report.error.log(string4);
                    throw new ConnectionException(string4);
                }
                if (clazz2.isAssignableFrom(cIMBean.getClass())) {
                    Statement statement = connection.createStatement();
                    long l = this.getBeanID(cIMBean);
                    ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tableName + " WHERE id = " + l);
                    if (resultSet.next()) {
                        Object object;
                        Object object2;
                        Class<?> clazz3;
                        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO CIMAssociationLookup (assocID, assocType, beanID1, beanType1, beanID2, beanType2, startDate, parentBeanID)  VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
                        long l2 = resultSet.getLong(this.keys[0]);
                        long l3 = resultSet.getLong(this.keys[1]);
                        String string5 = resultSet.getString(this.keys[0] + "Class");
                        String string6 = resultSet.getString(this.keys[1] + "Class");
                        preparedStatement.setLong(1, l);
                        preparedStatement.setString(2, this.tableName);
                        preparedStatement.setLong(3, l2);
                        preparedStatement.setString(4, string5);
                        preparedStatement.setLong(5, l3);
                        preparedStatement.setString(6, string6);
                        preparedStatement.setTimestamp(7, resultSet.getTimestamp("modifiedTS"));
                        preparedStatement.executeUpdate();
                        this.meInsertStmt = connection.prepareStatement("INSERT INTO ManagedElementSubjectLookup( meID, meType, subject, creationClassName, deviceCreationClassName, deviceID, fruNumber, identifyingNumber, name, systemCreationClassName, systemName, tag, vendor) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        this.meInsertStmt.setLong(1, l2);
                        this.meInsertStmt.setString(2, string5);
                        this.meInsertStmt.setString(3, cIMBean.getCIMObjectPath().toString());
                        try {
                            clazz3 = Class.forName("com.sun.jade.cim.bean." + string5);
                            object2 = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz3);
                            object = object2.select(l2);
                            this.setMEInsertStmtValues((CIMBean)object);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            String string7 = "Unable to store data in ManagedElementSubjectLookup table.";
                            Report.error.log(classNotFoundException, (Object)string7);
                            throw new ConnectionException(string7, classNotFoundException);
                        }
                        catch (NoDataFoundException noDataFoundException) {
                            String string8 = "Unable to store data in ManagedElementSubjectLookup table.";
                            Report.error.log(noDataFoundException, (Object)string8);
                            throw new ConnectionException(string8, noDataFoundException);
                        }
                        this.meInsertStmt.executeUpdate();
                        this.meInsertStmt.setLong(1, l3);
                        this.meInsertStmt.setString(2, string6);
                        this.meInsertStmt.setString(3, cIMBean.getCIMObjectPath().toString());
                        try {
                            clazz3 = Class.forName("com.sun.jade.cim.bean." + string6);
                            object2 = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz3);
                            object = object2.select(l3);
                            this.setMEInsertStmtValues((CIMBean)object);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object2 = "Unable to store data in ManagedElementSubjectLookup table.";
                            Report.error.log(classNotFoundException, object2);
                            throw new ConnectionException((String)object2, classNotFoundException);
                        }
                        catch (NoDataFoundException noDataFoundException) {
                            object = "Unable to store data in ManagedElementSubjectLookup table.";
                            Report.error.log(noDataFoundException, object);
                            throw new ConnectionException((String)object, noDataFoundException);
                        }
                        this.meInsertStmt.executeUpdate();
                    } else {
                        String string9 = "Unable to store data in CIMAssociationLookup table.  Could not retrieve association bean record after insert.";
                        Report.error.log(string9);
                        throw new ConnectionException(string9);
                    }
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string = "Unable to store CIM Bean.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var22_33 = null;
        }
        catch (Throwable throwable) {
            Object var22_34 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public CIMBean select(CIMBean cIMBean) throws NoDataFoundException, ConnectionException {
        Connection connection = PersistenceService.getConnection();
        Vector vector = new Vector();
        try {
            try {
                this.selectStmt = connection.prepareStatement(CIMTableUtil.getSelectStmt(this.tableName, this.columnNames, this.keys));
                this.setSelectKeyValues(cIMBean);
                ResultSet resultSet = this.selectStmt.executeQuery();
                vector = this.createBeansFromRS(resultSet);
            }
            catch (SQLException sQLException) {
                String string = "Unable to retrieve CMI Bean(s).";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        if (vector.isEmpty()) {
            throw new NoDataFoundException("");
        }
        return (CIMBean)vector.elementAt(0);
    }

    public CIMBean select(long l) throws NoDataFoundException, ConnectionException {
        CIMBean cIMBean = null;
        Connection connection = PersistenceService.getConnection();
        try {
            try {
                String string = "SELECT * FROM " + this.tableName + " WHERE id = " + l;
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                Vector vector = this.createBeansFromRS(resultSet);
                if (vector.size() <= 0) {
                    throw new NoDataFoundException("There were no records in " + this.tableName + " for id " + l + ".");
                }
                cIMBean = (CIMBean)vector.elementAt(0);
                Object var10_9 = null;
            }
            catch (SQLException sQLException) {
                throw new ConnectionException("Unable to select record in table " + this.tableName + " for id " + l + ".", sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return cIMBean;
    }

    public void delete(CIMBean cIMBean) throws NoDataFoundException, ConnectionException {
        Connection connection = null;
        try {
            try {
                Object object;
                long l = this.getBeanID(cIMBean);
                if (l == -1L) {
                    throw new NoDataFoundException("CIMBean cannot be deleted.  No record was found for bean: " + cIMBean.getCIMObjectPath().toString());
                }
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.executeUpdate("DELETE FROM " + this.tableName + " WHERE id = " + l);
                ResultSet resultSet = statement.executeQuery("SELECT assocID, assocType FROM CIMAssociationLookup WHERE beanID1 = " + l + " " + "AND beanType1 = '" + this.tableName + "' " + "UNION " + "SELECT assocID, assocType FROM " + "CIMAssociationLookup " + "WHERE beanID2 = " + l + " " + "AND beanType2 = '" + this.tableName + "' ");
                while (resultSet.next()) {
                    object = resultSet.getString("assocType");
                    long l2 = resultSet.getLong("assocID");
                    statement.executeUpdate("DELETE FROM " + (String)object + " " + "WHERE id = " + l2);
                    statement.executeUpdate("DELETE FROM CIMAssociationLookup WHERE assocID = " + l2 + " " + "AND assocType = '" + (String)object + "'");
                }
                object = statement.executeQuery("SELECT eventID FROM NSMEvent e, ManagedElementSubjectLookup l WHERE l.meId = " + l + " AND l.meType = '" + this.tableName + "' " + "AND e.subject = l.subject");
                Vector<String> vector = new Vector<String>();
                while (object.next()) {
                    vector.add(object.getString("eventID"));
                }
                String[] stringArray = vector.toArray(new String[0]);
                ResultSet resultSet2 = statement.executeQuery("SELECT eventID FROM Alarm e, ManagedElementSubjectLookup l WHERE l.meId = " + l + " AND l.meType = '" + this.tableName + "' " + "AND e.subject = l.subject");
                Vector<String> vector2 = new Vector<String>();
                while (resultSet2.next()) {
                    vector2.add(resultSet2.getString("eventID"));
                }
                String[] stringArray2 = vector2.toArray(new String[0]);
                statement.executeUpdate("DELETE FROM ManagedElementSubjectLookup WHERE meType = '" + this.tableName + "' AND " + "meID = " + l);
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string = "Unable to remove CIMBean and associated data.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    protected abstract void setExistsSelectKeyValues(Object var1) throws ConnectionException;

    protected abstract void setSelectKeyValues(Object var1) throws ConnectionException;

    protected abstract void setUpdateStmtValues(Object var1) throws ConnectionException;

    protected abstract void setInsertStmtValues(Object var1) throws ConnectionException;

    protected void setMEInsertStmtValues(CIMBean cIMBean) throws ConnectionException {
        CIMBeanBase cIMBeanBase = (CIMBeanBase)cIMBean;
        Properties properties = cIMBeanBase.toProperties();
        String[] stringArray = new String[]{"CreationClassName", "DeviceCreationClassName", "DeviceID", "FruNumber", "IdentifyingNumber", "Name", "SystemCreationClassName", "SystemName", "Tag", "Vendor"};
        int n = 0;
        while (n < stringArray.length) {
            String string = properties.getProperty(stringArray[n]);
            try {
                this.meInsertStmt.setString(n + 4, string);
            }
            catch (SQLException sQLException) {
                String string2 = "Unable to store bean.  Cannot store record in  ManagedElementSubjectLookup table.";
                Report.error.log(sQLException, (Object)string2);
                throw new ConnectionException(string2, sQLException);
            }
            ++n;
        }
    }

    public abstract Vector createBeansFromRS(ResultSet var1) throws ConnectionException;

    protected abstract void setColumnNames();

    protected synchronized void constructPreparedStatements() throws ConnectionException {
    }

    protected static String getCreationClassNameForCOP(CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        Vector vector = cIMObjectPath.getKeys();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
                String string2 = cIMProperty.getName();
                Object object = cIMProperty.getValue().getValue();
                if ("CreationClassName".equals(string2)) {
                    if (object == null) break;
                    string = object.toString();
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    protected static long getIDForCIMObjectPath(CIMObjectPath cIMObjectPath) throws ConnectionException {
        if (cIMObjectPath == null) {
            return -1L;
        }
        long l = -1L;
        try {
            String string = AbstractCIMBeanHelper.getCreationClassNameForCOP(cIMObjectPath);
            Class<?> clazz = Class.forName("com.sun.jade.cim.bean." + string);
            CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz);
            CIMBean cIMBean = CIMBeanUtil.createBean(cIMObjectPath);
            l = cIMBeanHelper.getBeanID(cIMBean);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.debug.log("Unable to get antecedent or dependent id for  association.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.debug.log("Unable to get antecedent or dependent id for association");
        }
        return l;
    }

    protected static CIMObjectPath getCIMObjectPathFromID(long l, String string) throws NoDataFoundException, ConnectionException {
        CIMBean cIMBean = null;
        try {
            Class<?> clazz = Class.forName("com.sun.jade.cim.bean." + string);
            CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz);
            cIMBean = cIMBeanHelper.select(l);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.debug.log("Unable to get CIMObjectPath for class " + string + " and id " + l + ".\n" + classNotFoundException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.debug.log("Unable to get CIMObjectPath for class " + string + " and id " + l + ".\n" + illegalArgumentException.toString());
        }
        return cIMBean.getCIMObjectPath();
    }
}

