/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.DataAlreadyExistsException;
import com.sun.jade.apps.persistence.service.GenericPersistenceImpl;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.TopologyPersistence;
import com.sun.jade.apps.topology.NetworkEdge;
import com.sun.jade.apps.topology.NetworkGraph;
import com.sun.jade.apps.topology.NetworkNode;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.logic.asset.AssetItem;
import com.sun.jade.logic.asset.AssetItemImpl;
import com.sun.jade.util.Item;
import com.sun.jade.util.ItemImpl;
import com.sun.jade.util.log.Report;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public final class TopologyPersistenceImpl
extends GenericPersistenceImpl
implements TopologyPersistence {
    protected TopologyPersistenceImpl() throws ConnectionException {
    }

    public synchronized void storeGraph(NetworkGraph networkGraph) throws DataAlreadyExistsException, ConnectionException {
        String string = networkGraph.getId();
        Date date = networkGraph.getDate();
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        if (string.equals(null)) {
            String string2 = "Unable to store network graph.  The NetworkGraph.id value is null.";
            Report.error.log(string2);
            throw new IllegalArgumentException(string2);
        }
        Connection connection = null;
        try {
            try {
                Object object;
                Object object2;
                String[] stringArray;
                Object object3;
                String string3;
                String string4;
                Object object4;
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO NetworkGraph(id, date) VALUES(?, ?)");
                PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT INTO NetworkNode(status, mfName, mfType, eventID, numbrAlarm, graphID) VALUES(?, ?, ?, ?, ?, ?)");
                PreparedStatement preparedStatement3 = connection.prepareStatement("INSERT INTO NetworkEdge(status, edgeType, mf1, mse1, mse1Type, mf2, mse2, mse2Type, eventID, graphID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                PreparedStatement preparedStatement4 = connection.prepareStatement("INSERT INTO AssetItem(nodeID, name, value) VALUES(?, ?, ?)");
                PreparedStatement preparedStatement5 = connection.prepareStatement("INSERT INTO ZoneForNode(nodeID, name) VALUES(?, ?)");
                PreparedStatement preparedStatement6 = connection.prepareStatement("INSERT INTO ZoneForEdge(edgeID, zoneLocation, name) VALUES(?, ?, ?)");
                PreparedStatement preparedStatement7 = connection.prepareStatement("SELECT COUNT(*) from NetworkGraph where id = ?");
                preparedStatement7.setString(1, string);
                ResultSet resultSet = preparedStatement7.executeQuery();
                resultSet.next();
                int n = resultSet.getInt(1);
                if (n != 0) {
                    String string5 = "Unable to store network graph.  The graph already exists.";
                    Report.error.log(string5);
                    throw new DataAlreadyExistsException(string5);
                }
                preparedStatement.setString(1, string);
                preparedStatement.setTimestamp(2, new Timestamp(date.getTime()));
                preparedStatement.executeUpdate();
                Statement statement = connection.createStatement();
                ResultSet resultSet2 = statement.executeQuery("CALL IDENTITY()");
                resultSet2.next();
                int n2 = resultSet2.getInt(1);
                Iterator iterator = networkGraph.getNodes();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        object4 = (NetworkNode)iterator.next();
                        int n3 = ((NetworkNode)object4).getStatus();
                        String string6 = ((NetworkNode)object4).getMfName();
                        String string7 = ((NetworkNode)object4).getMfType();
                        string4 = null;
                        if (((NetworkNode)object4).getEvent() != null) {
                            string4 = ((NetworkNode)object4).getEvent().getEventID();
                        }
                        string3 = ((NetworkNode)object4).getNumbrAlarm();
                        preparedStatement2.setInt(1, n3);
                        preparedStatement2.setString(2, string6);
                        preparedStatement2.setString(3, string7);
                        preparedStatement2.setString(4, string4);
                        preparedStatement2.setString(5, string3);
                        preparedStatement2.setInt(6, n2);
                        preparedStatement2.executeUpdate();
                        object3 = connection.createStatement().executeQuery("CALL IDENTITY()");
                        object3.next();
                        int n4 = object3.getInt(1);
                        stringArray = ((NetworkNode)object4).getZones();
                        if (stringArray != null) {
                            int n5 = 0;
                            while (n5 < stringArray.length) {
                                if (stringArray[n5] != null) {
                                    preparedStatement5.setInt(1, n4);
                                    preparedStatement5.setString(2, stringArray[n5]);
                                    preparedStatement5.executeUpdate();
                                }
                                ++n5;
                            }
                        }
                        object2 = ((NetworkNode)object4).getAssetItems();
                        while (object2.hasNext()) {
                            object = (AssetItem)object2.next();
                            preparedStatement4.setInt(1, n4);
                            preparedStatement4.setString(2, object.getName());
                            if (object.getValue() == null) {
                                preparedStatement4.setString(3, "");
                                continue;
                            }
                            preparedStatement4.setString(3, object.getValue().toString());
                            preparedStatement4.executeUpdate();
                        }
                    }
                }
                if ((object4 = networkGraph.getEdges()) != null) {
                    while (object4.hasNext()) {
                        int n6;
                        NetworkEdge networkEdge = (NetworkEdge)object4.next();
                        int n7 = networkEdge.getStatus();
                        int n8 = networkEdge.getEdgeType();
                        string4 = networkEdge.getMf1();
                        string3 = networkEdge.getMse1();
                        object3 = networkEdge.getMf2();
                        String string8 = networkEdge.getMse2();
                        stringArray = networkEdge.getMse1Type();
                        object2 = networkEdge.getMse2Type();
                        object = networkEdge.getZones1();
                        String[] stringArray2 = networkEdge.getZones2();
                        String string9 = null;
                        if (networkEdge.getEvent() != null) {
                            string9 = networkEdge.getEvent().getEventID();
                        }
                        preparedStatement3.setInt(1, n7);
                        preparedStatement3.setInt(2, n8);
                        preparedStatement3.setString(3, string4);
                        preparedStatement3.setString(4, string3);
                        preparedStatement3.setString(5, (String)stringArray);
                        preparedStatement3.setString(6, (String)object3);
                        preparedStatement3.setString(7, string8);
                        preparedStatement3.setString(8, (String)object2);
                        preparedStatement3.setString(9, string9);
                        preparedStatement3.setInt(10, n2);
                        preparedStatement3.executeUpdate();
                        ResultSet resultSet3 = connection.createStatement().executeQuery("CALL IDENTITY()");
                        resultSet3.next();
                        int n9 = resultSet3.getInt(1);
                        if (object != null) {
                            n6 = 0;
                            while (n6 < ((Object)object).length) {
                                if (object[n6] != null) {
                                    preparedStatement6.setInt(1, n9);
                                    preparedStatement6.setString(2, "1");
                                    preparedStatement6.setString(3, (String)object[n6]);
                                    preparedStatement6.executeUpdate();
                                }
                                ++n6;
                            }
                        }
                        if (stringArray2 == null) continue;
                        n6 = 0;
                        while (n6 < stringArray2.length) {
                            if (stringArray2[n6] != null) {
                                preparedStatement6.setInt(1, n9);
                                preparedStatement6.setString(2, "2");
                                preparedStatement6.setString(3, stringArray2[n6]);
                                preparedStatement6.executeUpdate();
                            }
                            ++n6;
                        }
                    }
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string10 = "Unable to store network graph.  Error occurred during record insert.";
                Report.error.log(sQLException, (Object)string10);
                throw new ConnectionException(string10, sQLException);
            }
            Object var35_44 = null;
        }
        catch (Throwable throwable) {
            Object var35_45 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public void removeGraph(String string) throws NoDataFoundException, ConnectionException {
        if (string == null) {
            String string2 = "Unable to remove network graph.  The id parameter is null.";
            Report.error.log(string2);
            throw new IllegalArgumentException(string2);
        }
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM NetworkGraph where graphID = ?");
                PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM NetworkNode where graphID = ?");
                PreparedStatement preparedStatement3 = connection.prepareStatement("DELETE FROM NetworkEdge where graphID = ?");
                PreparedStatement preparedStatement4 = connection.prepareStatement("DELETE FROM AssetItem where nodeID = ?");
                PreparedStatement preparedStatement5 = connection.prepareStatement("DELETE FROM ZoneForNode where nodeID = ?");
                PreparedStatement preparedStatement6 = connection.prepareStatement("DELETE FROM ZoneForEdge where edgeID = ?");
                PreparedStatement preparedStatement7 = connection.prepareStatement("SELECT * FROM NetworkGraph WHERE id = ? ORDER BY date DESC");
                PreparedStatement preparedStatement8 = connection.prepareStatement("SELECT * FROM NetworkNode WHERE graphID = ?");
                PreparedStatement preparedStatement9 = connection.prepareStatement("SELECT * FROM NetworkEdge WHERE graphID = ?");
                preparedStatement7.setString(1, string);
                ResultSet resultSet = preparedStatement7.executeQuery();
                if (!resultSet.next()) {
                    String string3 = "Unable to remove graph for id " + string + ".  No data found.";
                    Report.error.log(string3);
                    throw new NoDataFoundException(string3);
                }
                do {
                    int n = resultSet.getInt(1);
                    preparedStatement8.setInt(1, n);
                    ResultSet resultSet2 = preparedStatement8.executeQuery();
                    while (resultSet2.next()) {
                        int n2 = resultSet2.getInt(1);
                        preparedStatement5.setInt(1, n2);
                        preparedStatement5.executeUpdate();
                        preparedStatement4.setInt(1, n2);
                        preparedStatement4.executeUpdate();
                    }
                    preparedStatement9.setInt(1, n);
                    ResultSet resultSet3 = preparedStatement9.executeQuery();
                    while (resultSet3.next()) {
                        int n3 = resultSet3.getInt(1);
                        preparedStatement6.setInt(1, n3);
                        preparedStatement6.executeUpdate();
                    }
                    preparedStatement2.setInt(1, n);
                    preparedStatement2.executeUpdate();
                    preparedStatement3.setInt(1, n);
                    preparedStatement3.executeUpdate();
                    preparedStatement.setInt(1, n);
                    preparedStatement.executeUpdate();
                } while (resultSet.next());
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string4 = "Unable to remove Network Graph.";
                Report.error.log(sQLException, (Object)string4);
                throw new ConnectionException(string4, sQLException);
            }
            Object var18_23 = null;
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public NetworkGraph retrieveGraph(String string) throws NoDataFoundException, ConnectionException {
        if (string == null) {
            String string2 = "Unable to retrieve network graph.  The id parameter is null.";
            Report.error.log(string2);
            throw new IllegalArgumentException(string2);
        }
        NetworkGraph networkGraph = null;
        Connection connection = null;
        try {
            try {
                Object object;
                Object object2;
                String string3;
                String string4;
                String string5;
                String string6;
                int n;
                Object object3;
                Vector<Object> vector;
                ResultSet resultSet;
                int n2;
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM NetworkGraph WHERE id = ? ORDER BY date DESC");
                PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT * FROM NetworkNode WHERE graphID = ?");
                PreparedStatement preparedStatement3 = connection.prepareStatement("SELECT * FROM NetworkEdge WHERE graphID = ?");
                PreparedStatement preparedStatement4 = connection.prepareStatement("SELECT * FROM AssetItem WHERE nodeID = ?");
                PreparedStatement preparedStatement5 = connection.prepareStatement("SELECT * FROM ZoneForNode WHERE nodeID = ?");
                PreparedStatement preparedStatement6 = connection.prepareStatement("SELECT * FROM ZoneForEdge WHERE edgeID = ?");
                PreparedStatement preparedStatement7 = connection.prepareStatement("SELECT * FROM ALARM WHERE eventID = ?");
                preparedStatement.setString(1, string);
                ResultSet resultSet2 = preparedStatement.executeQuery();
                int n3 = 0;
                Timestamp timestamp = null;
                if (!resultSet2.next()) {
                    String string7 = "Unable to retrieve network graph.  No graph for id " + string + ".";
                    Report.error.log(string7);
                    throw new NoDataFoundException(string7);
                }
                n3 = resultSet2.getInt(1);
                timestamp = resultSet2.getTimestamp(3);
                preparedStatement2.setInt(1, n3);
                ResultSet resultSet3 = preparedStatement2.executeQuery();
                preparedStatement3.setInt(1, n3);
                ResultSet resultSet4 = preparedStatement3.executeQuery();
                Vector<Object> vector2 = new Vector<Object>();
                Vector<Object> vector3 = new Vector<Object>();
                while (resultSet3.next()) {
                    Object object4;
                    Object object5;
                    n2 = resultSet3.getInt(1);
                    preparedStatement4.setInt(1, n2);
                    resultSet = preparedStatement4.executeQuery();
                    vector = new Vector<Object>();
                    while (resultSet.next()) {
                        object3 = resultSet.getString(2);
                        object5 = resultSet.getString(3);
                        object4 = new AssetItemImpl((String)object3, object5);
                        vector.add(object4);
                    }
                    preparedStatement5.setInt(1, n2);
                    object3 = preparedStatement5.executeQuery();
                    object5 = new Vector();
                    while (object3.next()) {
                        object4 = object3.getString(2);
                        ((Vector)object5).add(object4);
                    }
                    n = resultSet3.getInt(2);
                    string6 = resultSet3.getString(3);
                    string5 = resultSet3.getString(4);
                    string4 = resultSet3.getString(5);
                    string3 = resultSet3.getString(6);
                    object2 = null;
                    if (string4 != null && !"".equals(string4.trim())) {
                        preparedStatement7.setString(1, string4);
                        object = preparedStatement7.executeQuery();
                        object2 = this.createEvent((ResultSet)object);
                    }
                    object = new NetworkNode(n, string6, string5, vector, (NSMEvent)object2, string3);
                    ((NetworkNode)object).setZones((Collection)object5);
                    vector2.add(object);
                }
                while (resultSet4.next()) {
                    Object object6;
                    n2 = resultSet4.getInt(1);
                    preparedStatement6.setInt(1, n2);
                    resultSet = preparedStatement6.executeQuery();
                    vector = new Vector();
                    object3 = new Vector();
                    while (resultSet.next()) {
                        String string8 = resultSet.getString(2);
                        String string9 = resultSet.getString(3);
                        if ("1".equals(string8)) {
                            vector.add(string9);
                            continue;
                        }
                        ((Vector)object3).add(string9);
                    }
                    int n4 = resultSet4.getInt(2);
                    n = resultSet4.getInt(3);
                    string6 = resultSet4.getString(4);
                    string5 = resultSet4.getString(5);
                    string4 = resultSet4.getString(6);
                    string3 = resultSet4.getString(7);
                    object2 = resultSet4.getString(8);
                    object = resultSet4.getString(9);
                    String string10 = resultSet4.getString(10);
                    NSMEvent nSMEvent = null;
                    if (string10 != null && !"".equals(string10.trim())) {
                        preparedStatement7.setString(1, string10);
                        object6 = preparedStatement7.executeQuery();
                        nSMEvent = this.createEvent((ResultSet)object6);
                    }
                    object6 = new NetworkEdge(n4, n, string6, string5, string4, string3, (String)object2, (String)object, nSMEvent);
                    ((NetworkEdge)object6).setZones1(vector);
                    ((NetworkEdge)object6).setZones2((Collection)object3);
                    vector3.add(object6);
                }
                networkGraph = new NetworkGraph(string, timestamp, vector2, vector3);
            }
            catch (SQLException sQLException) {
                String string11 = "Unable to retrieve network graph.";
                Report.error.log(sQLException, (Object)string11);
                throw new ConnectionException(string11, sQLException);
            }
            Object var34_42 = null;
        }
        catch (Throwable throwable) {
            Object var34_43 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return networkGraph;
    }

    public Iterator getGraphList() throws ConnectionException {
        Vector<ItemImpl> vector = new Vector<ItemImpl>();
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT id, date FROM NetworkGraph ORDER BY date DESC");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    Timestamp timestamp = resultSet.getTimestamp(2);
                    ItemImpl itemImpl = new ItemImpl(string, timestamp);
                    vector.add(itemImpl);
                }
            }
            catch (SQLException sQLException) {
                String string = "Unable to get network graph list for all graphs.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector.iterator();
    }

    public Iterator getGraphList(int n) throws ConnectionException {
        Iterator iterator = this.getGraphList();
        Vector<Item> vector = new Vector<Item>();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (iterator.hasNext()) {
                vector.add((Item)iterator.next());
            }
            ++n2;
        }
        return vector.iterator();
    }

    public Iterator getGraphList(Date date, Date date2) throws ConnectionException {
        if (date.getTime() > date2.getTime()) {
            String string = "Unable to get Network Graph List.The startDate must be earlier than endDate.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        if (date == null) {
            String string = "Unable to get Network Graph List.The startDate value was null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        if (date2 == null) {
            String string = "Unable to get Network Graph List.The endDate attribute was null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        Vector<ItemImpl> vector = new Vector<ItemImpl>();
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT id, date FROM NetworkGraph WHERE date >= ? AND date <= ? ORDER BY date DESC");
                preparedStatement.setTimestamp(1, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(2, new Timestamp(date2.getTime()));
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    Timestamp timestamp = resultSet.getTimestamp(2);
                    ItemImpl itemImpl = new ItemImpl(string, timestamp);
                    vector.add(itemImpl);
                }
            }
            catch (SQLException sQLException) {
                String string = "Unable to get Network Graph List.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector.iterator();
    }

    private NSMEvent createEvent(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                String string = resultSet.getString("eventID");
                if (string == null) continue;
                NSMEvent nSMEvent = new NSMEvent();
                nSMEvent.setSource(resultSet.getString("source"));
                nSMEvent.setSubject(resultSet.getString("subject"));
                nSMEvent.setTopic(resultSet.getString("topic"));
                nSMEvent.setSeverity(resultSet.getInt("severity"));
                nSMEvent.setSourceSequenceNumber(resultSet.getLong("sourceSequenceNumber"));
                nSMEvent.setSubjectTime(resultSet.getLong("subjectTime"));
                nSMEvent.setType(resultSet.getString("type"));
                nSMEvent.setEventID(resultSet.getString("eventID"));
                nSMEvent.setSourceTime(resultSet.getTimestamp("sourceTime").getTime());
                nSMEvent.setCorrelatedEvents((String[])resultSet.getObject("correlatedEvents"));
                nSMEvent.setPayloadType(resultSet.getString("payloadType"));
                nSMEvent.setPayload(resultSet.getObject("payload"));
                return nSMEvent;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

