/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.View;
import com.sun.jade.apps.persistence.service.ViewResult;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.Util;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

public class ViewManager {
    private static final String TAG = "ViewManager";
    private static final String MY_PROPS_FILE = "ViewManager.properties";
    private static final String VIEW_PROPS_DIR_PROP = "ViewManager.viewPropsDir";
    private static final String STORADE_PROPS_DIR_PROP = "storade.propsSaveDir";
    public static final String VIEW_NAME_PROP = "View.name";
    public static final String VIEW_CLASSNAME_PROP = "View.classname";
    private Properties props;
    private Hashtable views = new Hashtable();
    public static final String sccs_id = "@(#)ViewManager.java\t1.6 03/15/02 SMI";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public ViewManager() {
        try {
            this.props = PropertiesPersister.restoreProperties(MY_PROPS_FILE);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(TAG, propertiesPersistenceException, "Failed to load properties from file: ViewManager.properties");
        }
        String string = this.props.getProperty(VIEW_PROPS_DIR_PROP);
        if (string == null) {
            Report.error.log(TAG, (Object)"ViewManager.viewPropsDir property not set.");
        }
        String string2 = System.getProperty(STORADE_PROPS_DIR_PROP) + "/" + string;
        File file = new File(string2);
        Report.trace.log(TAG, (Object)("View properties directory: " + string2));
        if (!file.exists() || !file.isDirectory()) {
            Report.error.log(TAG, (Object)("Could not find directory " + string2));
        }
        Collection collection = Util.getPropsFiles(file, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Report.trace.log(TAG, (Object)("Reading properties file: " + string3));
            View view = this.createView(string3);
            if (view == null) {
                Report.error.log(TAG, (Object)("Could not create file using properties file " + string3));
                continue;
            }
            if (this.views.containsKey(view.getName())) {
                Report.error.log(TAG, (Object)("A view with the name " + view.getName() + " already exists.  Will not add view from " + string3));
                continue;
            }
            this.views.put(view.getName(), view);
        }
    }

    private View createView(String string) {
        Properties properties = null;
        try {
            properties = PropertiesPersister.restoreProperties(string);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(TAG, propertiesPersistenceException, "Error while loading view from properties file " + string);
            return null;
        }
        String string2 = properties.getProperty(VIEW_NAME_PROP);
        String string3 = properties.getProperty(VIEW_CLASSNAME_PROP);
        if (string2 == null || string3 == null) {
            Report.error.log(TAG, (Object)("Property not defined (View.name or View.classname) for view from file " + string));
            return null;
        }
        View view = null;
        try {
            Class<?> clazz = Class.forName(string3);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ViewManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ViewManager.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = ViewManager.class$("java.util.Properties")) : class$java$util$Properties);
            view = (View)constructor.newInstance(string2, string3, properties);
        }
        catch (Exception exception) {
            Report.error.log(TAG, exception, "Failed to create instance of view " + string2 + " from class " + string3);
            return null;
        }
        return view;
    }

    public ViewResult retrieveView(String string, Object[] objectArray) throws IllegalArgumentException {
        return this.retrieveView(string, objectArray, Locale.getDefault());
    }

    public ViewResult retrieveView(String string, Object[] objectArray, Locale locale) throws IllegalArgumentException {
        View view = (View)this.views.get(string);
        if (view == null) {
            throw new IllegalArgumentException("View " + string + " does not exist.");
        }
        return view.retrieveView(objectArray, locale);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

