/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.util.db;

import com.sun.jade.apps.persistence.util.db.ConnectionHolder;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class ConnectionPool {
    public static String jdbcDriver;
    public static String jdbcURL;
    public static String jdbcUser;
    public static String jdbcPassword;
    public static String dateFormat;
    public static String uniqueIDSQL;
    static int maxConnections;
    static int conIdx;
    static ConnectionHolder[] conH;
    static boolean madeConnections;
    static boolean debug;
    static Connection[] conns;
    static long lastReSync;
    static final long RESYNC_PERIOD = 900000L;

    private static synchronized void makeConnection() throws SQLException {
        if (madeConnections) {
            return;
        }
        conH = new ConnectionHolder[maxConnections];
        conns = new Connection[maxConnections];
        try {
            Class.forName(jdbcDriver);
            int n = 0;
            while (n < conH.length) {
                Connection connection = DriverManager.getConnection(jdbcURL, jdbcUser, jdbcPassword);
                ConnectionPool.conH[n] = new ConnectionHolder(connection);
                ConnectionPool.conns[n] = connection;
                ++n;
            }
            madeConnections = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Cant find JDBC Driver: " + jdbcDriver + "\n" + classNotFoundException.getMessage());
        }
    }

    public static synchronized Connection getConnection() throws SQLException {
        if (!madeConnections) {
            ConnectionPool.makeConnection();
        }
        Connection connection = null;
        int n = 0;
        while (n < conH.length) {
            ConnectionHolder connectionHolder = conH[n];
            connection = connectionHolder.checkOut("PersistenceService");
            if (connection != null) break;
            ++n;
        }
        if (connection == null) {
            throw new SQLException("ConnectionPool: No more connections available. \nStatus:\n" + ConnectionPool.getStatus());
        }
        if (debug) {
            System.err.println("ConnectionPool Status:\n" + ConnectionPool.getStatus());
        }
        return connection;
    }

    public static synchronized void closeConnections() {
        int n = 0;
        while (n < conH.length) {
            if (conH[n] != null) {
                try {
                    ConnectionHolder connectionHolder = conH[n];
                    if (!connectionHolder.isCheckedOut()) {
                        Connection connection = connectionHolder.checkOut("ConnectionPool");
                        if (connection != null) {
                            connection.close();
                        }
                        connectionHolder.checkIn(connection);
                        connection = null;
                    }
                }
                catch (SQLException sQLException) {
                    Report.error.log(sQLException, (Object)"Error closing all open connections");
                }
            }
            ++n;
        }
    }

    public static synchronized void returnConnection(Connection connection) {
        int n = 0;
        while (n < conH.length) {
            if (conH[n].checkIn(connection)) break;
            ++n;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < conH.length) {
            if (conH[n2].isCheckedOut()) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl && System.currentTimeMillis() - lastReSync > 900000L) {
            lastReSync = System.currentTimeMillis();
            ConnectionPool.closeConnections();
            madeConnections = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUID() throws SQLException {
        long l = 0L;
        Connection connection = null;
        try {
            connection = ConnectionPool.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(uniqueIDSQL);
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ConnectionPool.returnConnection(connection);
            throw throwable;
        }
        ConnectionPool.returnConnection(connection);
        return l;
    }

    public static String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < conH.length) {
            boolean bl = conH[n].isCheckedOut();
            if (!bl) {
                stringBuffer.append("connection[" + n + "] is available.\n");
            } else {
                stringBuffer.append("connection[" + n + "] is checked out " + conH[n].getOwner() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        conIdx = 0;
        madeConnections = false;
        lastReSync = System.currentTimeMillis();
        try {
            String string = "PersistenceService.properties";
            Properties properties = PropertiesPersister.restoreProperties(string);
            jdbcDriver = properties.getProperty("ConnectionPool.jdbcDriver");
            jdbcURL = properties.getProperty("ConnectionPool.jdbcURL");
            jdbcUser = properties.getProperty("ConnectionPool.jdbcUser");
            jdbcPassword = properties.getProperty("ConnectionPool.jdbcPassword");
            dateFormat = properties.getProperty("ConnectionPool.dateFormat");
            uniqueIDSQL = properties.getProperty("ConnectionPool.uniqueIDSQL");
            maxConnections = new Integer(properties.getProperty("ConnectionPool.maxConnections"));
            debug = new Boolean(properties.getProperty("ConnectionPool.debug"));
            while (jdbcURL.indexOf("<-D") != -1) {
                int n = jdbcURL.indexOf("<-D");
                int n2 = jdbcURL.indexOf("/>");
                if (n2 < n) {
                    System.err.println("DatabaseInitializer Error:  ConnectionPool.jdbcURL is not formatted correctly.");
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer(jdbcURL);
                String string2 = System.getProperty(jdbcURL.substring(n + 3, n2));
                jdbcURL = string2 != null ? stringBuffer.replace(n, n2 + 2, string2).toString() : stringBuffer.replace(n, n2 + 2, "").toString();
            }
            ConnectionPool.makeConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

