/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.topology;

import com.sun.jade.apps.command.CommandRunner;
import com.sun.jade.apps.discovery.BaseServiceFinder;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.apps.topology.graph.model.BasicCompositeNode;
import com.sun.jade.apps.topology.graph.model.BasicNode;
import com.sun.jade.apps.topology.graph.model.Graph;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class TopologyCommand
implements CommandRunner {
    private String[] cmdList = new String[]{"INFO", "LIST"};
    private static final String sccs_id = "@(#)TopologyCommand.java\t1.6 05/02/02 SMI";

    public String getRoot() {
        return "/TOP";
    }

    public String[] getCommands() {
        return this.cmdList;
    }

    public int execute(String string, String string2, Writer writer) {
        try {
            if (string.equals("INFO")) {
                return this.info(writer);
            }
            if (string.equals("LIST")) {
                return this.list(writer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(new PrintWriter(writer));
            return 2;
        }
        return 3;
    }

    private int list(Writer writer) throws Exception {
        InstallerService installerService = BaseServiceFinder.getInstallerService();
        if (installerService == null) {
            writer.write("Installer Service not found.");
            return 1;
        }
        writer.write("Domain = " + installerService.getDomain() + "\n");
        MF[] mFArray = installerService.getInstalledSystems();
        Object[] objectArray = installerService.getInstalledServices();
        writer.write("Services:\n");
        int n = 0;
        while (n < objectArray.length) {
            writer.write("\t" + objectArray[n] + "\n");
            ++n;
        }
        writer.write("Devices:\n");
        int n2 = 0;
        while (n2 < mFArray.length) {
            writer.write("\t" + mFArray[n2] + "\n");
            ++n2;
        }
        return 0;
    }

    private int info(Writer writer) throws Exception {
        TopologyService topologyService = BaseServiceFinder.getTopologyService();
        if (topologyService == null) {
            writer.write("Topology Service not found.");
            return 1;
        }
        writer.write("Found Topology Service.\n");
        writer.write("Name=" + topologyService.getServiceName() + "\n");
        Graph graph = topologyService.getGraph();
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            BasicNode basicNode = (BasicNode)iterator.next();
            Object object = basicNode.getUserObject();
            if (object instanceof MF) {
                MF mF = (MF)object;
                writer.write(mF.getClassName() + "\n");
                writer.write(mF.getName() + "\n");
                if (basicNode instanceof BasicCompositeNode) {
                    Iterator iterator2 = ((BasicCompositeNode)basicNode).nodes();
                    while (iterator2.hasNext()) {
                        BasicNode basicNode2 = (BasicNode)iterator2.next();
                        ReferenceForMSE referenceForMSE = (ReferenceForMSE)basicNode2.getUserObject();
                        writer.write("\t" + referenceForMSE + "\n");
                    }
                }
            } else {
                writer.write("Node=" + object.toString() + "\n");
            }
            writer.write("\n");
        }
        return 0;
    }
}

