/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.topology.graph.model;

import com.sun.jade.apps.topology.graph.model.GraphEvent;
import com.sun.jade.apps.topology.graph.model.GraphListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GraphEventMulticaster
implements GraphListener {
    private List listeners = new LinkedList();

    public void add(GraphListener graphListener) {
        this.listeners.add(graphListener);
    }

    public Iterator listeners() {
        return this.listeners.iterator();
    }

    public void dispatchEvent(GraphEvent graphEvent) {
        switch (graphEvent.getID()) {
            case 11: {
                this.edgeHeadChanged(graphEvent);
                break;
            }
            case 12: {
                this.edgeTailChanged(graphEvent);
                break;
            }
            case 20: {
                this.nodeAdded(graphEvent);
                break;
            }
            case 21: {
                this.nodeRemoved(graphEvent);
                break;
            }
            case 30: {
                this.structureChanged(graphEvent);
            }
        }
    }

    public void remove(GraphListener graphListener) {
        this.listeners.remove(graphListener);
    }

    public void nodeAdded(GraphEvent graphEvent) {
        Iterator iterator = this.listeners();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            graphListener.nodeAdded(graphEvent);
        }
    }

    public void nodeRemoved(GraphEvent graphEvent) {
        Iterator iterator = this.listeners();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            graphListener.nodeRemoved(graphEvent);
        }
    }

    public void structureChanged(GraphEvent graphEvent) {
        Iterator iterator = this.listeners();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            graphListener.structureChanged(graphEvent);
        }
    }

    public void edgeHeadChanged(GraphEvent graphEvent) {
        Iterator iterator = this.listeners();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            graphListener.edgeHeadChanged(graphEvent);
        }
    }

    public void edgeTailChanged(GraphEvent graphEvent) {
        Iterator iterator = this.listeners();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            graphListener.edgeTailChanged(graphEvent);
        }
    }
}

