/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticResultEvent;
import com.sun.jade.cim.diag.DiagnosticResultListener;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.DiagnosticTestInfo;
import com.sun.jade.cim.diag.TestException;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.jade.cim.mse.Diagnosable;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class DiagnosableImpl
implements Diagnosable {
    private Map runMap = new HashMap();
    private LinkedList runList = new LinkedList();
    private ReferenceForMSE mse;
    private TestTemplate[] tests;
    private boolean testRunning = false;
    private static int testExecID = 0;
    private static final String sccs_id = "@(#)DiagnosableImpl.java\t1.10 02/20/03 SMI";

    public DiagnosableImpl() throws RemoteException {
    }

    public DiagnosableImpl(ReferenceForMSE referenceForMSE, TestTemplate[] testTemplateArray) {
        Report.trace.log("DiagnosableImpl:mse=" + referenceForMSE);
        Report.trace.log("DiagnosableImpl:tests=" + testTemplateArray.length);
        this.mse = referenceForMSE;
        this.tests = testTemplateArray;
    }

    public DiagnosableImpl(ReferenceForMSE referenceForMSE, String[] stringArray) {
        Report.trace.log("DiagnosableImpl:mse=" + referenceForMSE);
        this.mse = referenceForMSE;
        this.tests = new TestTemplate[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                Class<?> clazz;
                Report.trace.log("DiagnosableImpl:test=" + stringArray[n]);
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    clazz = classLoader.loadClass(stringArray[n]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Report.warning.log(classNotFoundException.toString());
                    break block6;
                }
                try {
                    this.tests[n] = (TestTemplate)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Report.warning.log(illegalAccessException.toString());
                }
                catch (InstantiationException instantiationException) {
                    Report.warning.log(instantiationException.toString());
                }
            }
            ++n;
        }
    }

    public String getClassName() throws RemoteException {
        if (this.mse == null) {
            return null;
        }
        return this.mse.getCreationClassName();
    }

    public String getKeyValue() throws RemoteException {
        if (this.mse == null) {
            return null;
        }
        return this.mse.getKeyValue();
    }

    public String getKeyName() throws RemoteException {
        if (this.mse == null) {
            return null;
        }
        return this.mse.getKeyName();
    }

    public DiagnosticTestInfo[] getDiagnosticTests() throws RemoteException {
        if (this.tests == null) {
            return new DiagnosticTestInfo[0];
        }
        DiagnosticTestInfo[] diagnosticTestInfoArray = new DiagnosticTestInfo[this.tests.length];
        int n = 0;
        while (n < this.tests.length) {
            diagnosticTestInfoArray[n] = new DiagnosticTestInfo(this.tests[n]);
            ++n;
        }
        return diagnosticTestInfoArray;
    }

    public boolean validateTest(DiagnosticTestInfo diagnosticTestInfo) throws RemoteException {
        if (diagnosticTestInfo == null) {
            return false;
        }
        DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest();
        Vector vector = diagnosticSetting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            if (!((TestParameter)vector.get(n)).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized DiagnosticResult runTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResultListener diagnosticResultListener) throws RemoteException {
        TestTemplate testTemplate = null;
        int n = 0;
        while (n < this.tests.length) {
            if (this.tests[n].getTestName().equals(diagnosticTestInfo.getTestClassName())) {
                testTemplate = this.tests[n];
                break;
            }
            ++n;
        }
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        diagnosticResult.setExecutionID(diagnosticTestInfo.getTestClassName() + ":" + ++testExecID);
        if (testTemplate == null) {
            diagnosticResult.setFinalResults(TestState.FAILED, "Unknown Test");
            return diagnosticResult;
        }
        try {
            TestExecutable testExecutable = testTemplate.getTestExec(this.mse, diagnosticTestInfo.getSettingsForTest());
            if (testExecutable == null) {
                diagnosticResult.setFinalResults(TestState.FAILED, "Test failed to Execute");
                return diagnosticResult;
            }
            int[] nArray = testTemplate.getTestCharacteristics();
            boolean bl = false;
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == 2) {
                    bl = true;
                }
                ++n2;
            }
            boolean bl2 = true;
            TestableElement[] testableElementArray = testTemplate.getTestableElements();
            int n3 = 0;
            while (n3 < testableElementArray.length) {
                if (testableElementArray[n3].getCreationClassName().equals(this.mse.getCreationClassName())) {
                    bl2 = testableElementArray[n3].getIsExclusiveForDevice();
                }
                ++n3;
            }
            TestRunner testRunner = new TestRunner(this, testExecutable, diagnosticResult, diagnosticResultListener);
            this.runList.add(testRunner);
            if (bl2) {
                this.startNextTest();
            } else {
                testRunner.start();
            }
        }
        catch (Exception exception) {
            diagnosticResult.setFinalResults(TestState.FAILED, "Test failed to Execute");
            return diagnosticResult;
        }
        return diagnosticResult;
    }

    private void startNextTest() {
        if (this.testRunning) {
            return;
        }
        this.testRunning = true;
        Iterator iterator = this.runList.iterator();
        while (iterator.hasNext()) {
            TestRunner testRunner = (TestRunner)iterator.next();
            if (testRunner.getRunState() != 0) continue;
            testRunner.start();
            return;
        }
    }

    public synchronized DiagnosticResult getTestResults(ElementKey elementKey) throws RemoteException {
        Iterator iterator = this.runList.iterator();
        while (iterator.hasNext()) {
            TestRunner testRunner = (TestRunner)iterator.next();
            DiagnosticResult diagnosticResult = testRunner.getResult();
            if (!diagnosticResult.getElementKey().equals(elementKey)) continue;
            return diagnosticResult;
        }
        return null;
    }

    synchronized void testDone() {
        this.testRunning = false;
        this.runList.removeFirst();
        this.startNextTest();
    }

    public synchronized boolean abortTest(ElementKey elementKey) throws RemoteException {
        boolean bl = false;
        Iterator iterator = this.runList.iterator();
        while (iterator.hasNext()) {
            TestRunner testRunner = (TestRunner)iterator.next();
            DiagnosticResult diagnosticResult = testRunner.getResult();
            if (!diagnosticResult.getElementKey().equals(elementKey)) continue;
            TestExecutable testExecutable = testRunner.getTestExecutable();
            try {
                bl = testExecutable.abortTest();
            }
            catch (TestException testException) {
                diagnosticResult.addTestResults(testException.getLocalizedMessage());
                return false;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            System.out.println("usage DiagnosableImpl <test> <system> <key> <value> [param=value]");
            System.exit(1);
        }
        String[] stringArray2 = new String[]{stringArray[0]};
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(stringArray[1], stringArray[2], stringArray[3]);
        DiagnosableImpl diagnosableImpl = new DiagnosableImpl(referenceForMSE, stringArray2);
        DiagnosticTestInfo[] diagnosticTestInfoArray = diagnosableImpl.getDiagnosticTests();
        DiagnosticSetting diagnosticSetting = diagnosticTestInfoArray[0].getSettingsForTest();
        int n = 4;
        while (n < stringArray.length) {
            String string;
            int n2 = stringArray[n].indexOf("=");
            String string2 = stringArray[n].substring(0, n2);
            Object object = diagnosticSetting.setTestParameter(string2, string = stringArray[n].substring(n2 + 1));
            if (object == null) {
                System.out.println(string2 + " NOT SET");
            } else {
                System.out.println(string2 + " Set To " + object);
            }
            ++n;
        }
        System.out.println("--------\nSettings\n--------\n" + (Object)((Object)diagnosticSetting));
        diagnosableImpl.runTest(diagnosticTestInfoArray[0], null);
    }

    public static class Test
    extends UnitTest {
        public void testDefault() throws RemoteException {
            DiagnosableImpl diagnosableImpl = new DiagnosableImpl();
            this.assertNull(diagnosableImpl.getClassName());
            this.assertNull(diagnosableImpl.getKeyValue());
            this.assertNull(diagnosableImpl.getKeyName());
            this.assertCondition(diagnosableImpl.getDiagnosticTests().length == 0);
            this.assertNull(diagnosableImpl.getTestResults(null));
            this.assertCondition(!diagnosableImpl.abortTest(null));
            this.assertCondition(!diagnosableImpl.validateTest(null));
        }

        private class TestExecUnitTest
        implements TestExecutable {
            boolean running = false;
            ReferenceForMSE mse;
            DiagnosticSetting s;

            TestExecUnitTest(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
                this.mse = referenceForMSE;
                this.s = diagnosticSetting;
            }

            public DiagnosticSetting getDiagnosticSetting() {
                return this.s;
            }

            public ReferenceForMSE getMSE() {
                return this.mse;
            }

            public ReferenceForMSE getExclusiveMSE() {
                return this.mse;
            }

            public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
                Thread thread = Thread.currentThread();
                this.running = true;
                short s = 1;
                while (this.running & s < 100) {
                    diagnosticResult.setPercentComplete(s);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    s = (short)(s + 1);
                }
                diagnosticResult.setFinalResults(TestState.STOPPED);
            }

            public boolean abortTest() throws DiagnosticException {
                this.running = false;
                return true;
            }

            public boolean pauseTest() throws DiagnosticException {
                return false;
            }

            public boolean continueTest() throws DiagnosticException {
                return false;
            }
        }

        private class TestTemplateUnitTest
        implements TestTemplate {
            private TestTemplateUnitTest() {
            }

            public String getTestName() {
                return "TestTemplateUnitTest";
            }

            public String getTestCaption(Locale locale) {
                return "Unit Test Template";
            }

            public String getTestDescription(Locale locale) {
                return "Desc";
            }

            public String[] getTestPackageNames() {
                return new String[0];
            }

            public DiagnosticSetting getDefaultSetting(Locale locale) {
                return new DiagnosticSetting();
            }

            public String[] getDependancies() {
                return new String[0];
            }

            public int[] getSymptoms() {
                return new int[0];
            }

            public int[] getTestCharacteristics() {
                int[] nArray = new int[]{101, 2};
                return nArray;
            }

            public int[] getTestResources() {
                return new int[0];
            }

            public TestableElement[] getTestableElements() {
                TestableElement[] testableElementArray = new TestableElement[]{new TestableElement("Class", 10, true)};
                return testableElementArray;
            }

            public TestExecutable getTestExec(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) throws DiagnosticException {
                return new TestExecUnitTest(referenceForMSE, diagnosticSetting);
            }
        }
    }

    private class TestRunner
    extends Thread {
        public static final int QUEUED = 0;
        public static final int RUNNING = 1;
        public static final int DONE = 2;
        private ResultMonitor monitor;
        private TestExecutable testExec;
        private DiagnosticResult result;
        private int runState = 0;

        TestRunner(DiagnosableImpl diagnosableImpl2, TestExecutable testExecutable, DiagnosticResult diagnosticResult, DiagnosticResultListener diagnosticResultListener) {
            this.testExec = testExecutable;
            this.result = diagnosticResult;
            this.monitor = new ResultMonitor(diagnosableImpl2, diagnosticResult, diagnosticResultListener);
        }

        public void run() {
            try {
                this.monitor.start();
                this.runState = 1;
                this.testExec.runTest(this.result);
            }
            catch (Exception exception) {
                this.result.setFinalResults(TestState.FAILED, exception.getLocalizedMessage());
                Report.warning.log("Test Failed: " + exception.toString());
            }
            this.runState = 2;
        }

        public int getRunState() {
            return this.runState;
        }

        public DiagnosticResult getResult() {
            return this.result;
        }

        public TestExecutable getTestExecutable() {
            return this.testExec;
        }

        private class ResultMonitor
        extends Thread {
            private DiagnosticResult result;
            private DiagnosticResultListener listener;
            private DiagnosableImpl parent;

            ResultMonitor(DiagnosableImpl diagnosableImpl, DiagnosticResult diagnosticResult, DiagnosticResultListener diagnosticResultListener) {
                this.parent = diagnosableImpl;
                this.result = diagnosticResult;
                this.listener = diagnosticResultListener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        int n;
                        do {
                            this.result.waitForUpdate();
                            n = this.result.getPercentCompleteValue();
                            DiagnosticResultEvent diagnosticResultEvent = new DiagnosticResultEvent(this.result);
                            if (this.listener != null) {
                                this.listener.notify(diagnosticResultEvent);
                                continue;
                            }
                            System.out.println("Updated Result =" + this.result);
                        } while (100 > n);
                    }
                    catch (Exception exception) {
                        Report.warning.log(exception.toString());
                        Object var5_5 = null;
                        this.parent.testDone();
                    }
                    Object var5_4 = null;
                    this.parent.testDone();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.parent.testDone();
                    throw throwable;
                }
            }
        }
    }
}

