/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.bean.SADE_DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.Messages;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.EmbeddedObject;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt8;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class DiagnosticResult
extends SADE_DiagnosticResult
implements Serializable {
    private static final String sccs_id = "@(#)DiagnosticResult.java\t1.35 02/21/03 SMI";
    private ElementKey key;
    private ReferenceForMSE mse;
    private Vector resultList;
    private static Localizer msgs = Messages.getLocalizer();
    public static final String DIAGNOSTIC_CLASS_KEY_NAME = "DiagnosticCreationClassName";
    public static final String DIAGNOSTIC_KEY_NAME = "DiagnosticName";
    public static final String KEY_NAME = "ExecutionID";
    public static final String NullExecutionID = "0";
    private Vector testResults;

    public DiagnosticResult() {
        this.key = new ElementKey();
    }

    public DiagnosticResult(String string, String string2) {
        this.setDiagnosticCreationClassName(string);
        this.setDiagnosticName(string2);
        this.key = new ElementKey();
        this.setTestState(TestState.UNKNOWN);
    }

    public DiagnosticResult(SADE_DiagnosticResult sADE_DiagnosticResult) {
        this.setDiagnosticCreationClassName(sADE_DiagnosticResult.getDiagnosticCreationClassName());
        this.setDiagnosticName(sADE_DiagnosticResult.getDiagnosticName());
        this.setExecutionID(sADE_DiagnosticResult.getExecutionID());
        this.setDiagSystemCreationClassName(sADE_DiagnosticResult.getDiagSystemCreationClassName());
        this.setDiagSystemName(sADE_DiagnosticResult.getDiagSystemName());
        this.setTimeStamp(sADE_DiagnosticResult.getTimeStamp());
        this.setMSEInstance(sADE_DiagnosticResult.getMSEInstance());
        this.setIsPackage(sADE_DiagnosticResult.getIsPackage());
        this.setTestStartTime(sADE_DiagnosticResult.getTestStartTime());
        this.setTestCompletionTime(sADE_DiagnosticResult.getTestCompletionTime());
        this.setTestState(sADE_DiagnosticResult.getTestState());
        this.setOtherStateDescription(sADE_DiagnosticResult.getOtherStateDescription());
        this.setEstimatedTimeOfPerforming(sADE_DiagnosticResult.getEstimatedTimeOfPerforming());
        this.setTestResults(sADE_DiagnosticResult.getTestResults());
        this.setPercentComplete(sADE_DiagnosticResult.getPercentComplete());
        this.setTestWarningLevel(sADE_DiagnosticResult.getTestWarningLevel());
        this.setReportSoftErrors(sADE_DiagnosticResult.getReportSoftErrors());
        this.setReportStatusMessages(sADE_DiagnosticResult.getReportStatusMessages());
        this.setHaltOnError(sADE_DiagnosticResult.getHaltOnError());
        this.setQuickMode(sADE_DiagnosticResult.getQuickMode());
        this.setPercentOfTestCoverage(sADE_DiagnosticResult.getPercentOfTestCoverage());
        this.setSettingsInstance(sADE_DiagnosticResult.getSettingsInstance());
        this.setMSEInstance(sADE_DiagnosticResult.getMSEInstance());
        this.setUserID(sADE_DiagnosticResult.getUserID());
    }

    public ElementKey getElementKey() {
        return this.key;
    }

    public void setElementKey(ElementKey elementKey) {
        this.key = elementKey;
        this.setExecutionID(elementKey.toString());
    }

    public ReferenceForMSE getMse() {
        return this.mse;
    }

    public void setMse(ReferenceForMSE referenceForMSE) {
        this.mse = referenceForMSE;
        super.setMSEInstance(referenceForMSE.toMof());
    }

    public void setSettings(DiagnosticSetting diagnosticSetting) {
        super.setSettingsInstance(diagnosticSetting.toMof());
    }

    public void setMSEInstance(String string) {
        super.setMSEInstance(string);
        if (string == null) {
            this.mse = null;
            return;
        }
        try {
            EmbeddedObject embeddedObject = new EmbeddedObject(string);
            this.mse = new ReferenceForMSE(embeddedObject.getBean().getCIMObjectPath());
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Bad MSE");
            this.mse = null;
        }
    }

    public void setTestState(int n) {
        this.setTestState(new UnsignedInt16(n));
    }

    public void setTestState(TestState testState) {
        if (testState == null) {
            this.setTestState(null);
        } else {
            this.setTestState(new UnsignedInt16(testState.toInteger().intValue()));
        }
    }

    public TestState getTestStateValueMap() {
        UnsignedInt16 unsignedInt16 = this.getTestState();
        if (unsignedInt16 == null) {
            return null;
        }
        return TestState.toTestState(new Integer(unsignedInt16.intValue()));
    }

    public int getTestStateValue() {
        UnsignedInt16 unsignedInt16 = this.getTestState();
        if (unsignedInt16 == null) {
            return 0;
        }
        return unsignedInt16.intValue();
    }

    public String getLocalizedTestState(Locale locale) {
        msgs.setLocale(locale);
        msgs.setDeferLocalization(false);
        int n = this.getTestStateValue();
        return msgs.getString("result.testState." + n);
    }

    public void setEstimatedTimeOfPerforming(int n) {
        this.setEstimatedTimeOfPerforming(new UnsignedInt32((long)n));
    }

    public int getPercentCompleteValue() {
        UnsignedInt8 unsignedInt8 = this.getPercentComplete();
        if (unsignedInt8 == null) {
            return 0;
        }
        return unsignedInt8.intValue();
    }

    public int getEstimatedTimeOfPerformingValue() {
        UnsignedInt32 unsignedInt32 = this.getEstimatedTimeOfPerforming();
        if (unsignedInt32 == null) {
            return 0;
        }
        return unsignedInt32.intValue();
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        int n;
        msgs.setLocale(locale);
        msgs.setDeferLocalization(false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(msgs.getFormattedString("result.id", this.getExecutionID()));
        CIMDateTime cIMDateTime = this.getTestStartTime();
        if (cIMDateTime != null) {
            stringBuffer.append("\n");
            stringBuffer.append(msgs.getFormattedString("result.startedTime", cIMDateTime.getCalendar().getTime()));
        }
        if ((cIMDateTime = this.getTestCompletionTime()) != null) {
            stringBuffer.append("\n");
            stringBuffer.append(msgs.getFormattedString("result.finishedTime", cIMDateTime.getCalendar().getTime()));
        }
        if ((n = this.getPercentCompleteValue()) != 100) {
            cIMDateTime = this.getTimeStamp();
            if (cIMDateTime != null) {
                stringBuffer.append("\n");
                stringBuffer.append(msgs.getFormattedString("result.updatedTime", cIMDateTime.getCalendar().getTime()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(msgs.getFormattedString("result.percentComplete", new Integer(n)));
        }
        int n2 = this.getTestStateValue();
        stringBuffer.append("\n");
        stringBuffer.append(msgs.getString("result.testState." + n2));
        String[] stringArray = this.getTestResults();
        if (stringArray.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(msgs.getString("result.details"));
            stringBuffer.append("\n");
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string = LocalizedString.localize(stringArray[n3], locale);
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n3;
            }
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getResultsString() {
        String[] stringArray = this.getTestResults();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n] + ",");
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public boolean getIsPackageValue() {
        Boolean bl = this.getIsPackage();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public int getIsPackageInt() {
        Boolean bl = this.getIsPackage();
        if (bl == null) {
            return 0;
        }
        String string = bl.toString();
        if (string.equals("true")) {
            return 1;
        }
        return 0;
    }

    public void setIsPackage(boolean bl) {
        this.setIsPackage(new Boolean(bl));
    }

    public String toMOF() {
        StringBuffer stringBuffer = new StringBuffer("instance of CIM_DiagnosticResult { ");
        stringBuffer.append("\n\tExecutionID = ");
        stringBuffer.append(this.getExecutionID());
        stringBuffer.append(";\n\tTimeStamp = ");
        stringBuffer.append(this.getTimeStamp());
        stringBuffer.append(";\n\tIsPackage = ");
        stringBuffer.append(this.getIsPackage());
        stringBuffer.append(";\n\tTestStartTime = ");
        stringBuffer.append(this.getTestStartTime());
        stringBuffer.append(";\n\tTestCompletionTime = ");
        stringBuffer.append(this.getTestCompletionTime());
        stringBuffer.append(";\n\tTestState = \"");
        stringBuffer.append(this.getTestState());
        stringBuffer.append("\";\n\tEstimatedTimeOfPerforming = ");
        stringBuffer.append(this.getEstimatedTimeOfPerforming());
        stringBuffer.append(";\n\tTestResults = {");
        String[] stringArray = this.getTestResults();
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string = LocalizedString.localize(stringArray[n]);
                stringBuffer.append("\n\t\t\"");
                stringBuffer.append(string);
                if (n == stringArray.length - 1) {
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append("\",");
                }
                ++n;
            }
            stringBuffer.append("\n\t}");
        } else {
            stringBuffer.append(" }");
        }
        stringBuffer.append(";\n\tPercentComplete = ");
        stringBuffer.append(this.getPercentComplete());
        stringBuffer.append(";\n};\n");
        return stringBuffer.toString();
    }

    public synchronized void setExecutionID(String string) {
        super.setExecutionID(string);
        this.key = new ElementKey(string);
    }

    public Vector getResultList() {
        return this.resultList;
    }

    public void add(DiagnosticResult diagnosticResult) {
        if (this.resultList == null) {
            this.resultList = new Vector();
        }
        this.resultList.add(diagnosticResult);
    }

    public DiagnosticResult get(int n) {
        if (this.resultList == null) {
            return null;
        }
        return (DiagnosticResult)this.resultList.get(n);
    }

    public synchronized void setFinalResults(TestState testState) {
        this.setTestState(testState);
        CIMDateTime cIMDateTime = new CIMDateTime();
        this.setTimeStamp(cIMDateTime);
        this.setTestCompletionTime(cIMDateTime);
        this.setPercentComplete(new UnsignedInt8(100));
        this.notifyAll();
    }

    public boolean isTestCompleted() {
        return this.getTestCompletionTime() != null;
    }

    public void setFinalResults(TestState testState, String string) {
        this.addTestResults(string);
        this.setFinalResults(testState);
    }

    public void setResultsToAborted() {
        this.setFinalResults(TestState.STOPPED);
    }

    public synchronized void setPercentComplete(short s) {
        super.setPercentComplete(new UnsignedInt8(s));
        this.setTimeStamp(new CIMDateTime());
        this.notifyAll();
    }

    public synchronized void update() {
        this.setTimeStamp(new CIMDateTime());
        this.notifyAll();
    }

    public synchronized void waitForUpdate() {
        if (this.getTestCompletionTime() != null) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized String[] getTestResults() {
        if (this.testResults == null) {
            return new String[0];
        }
        Object[] objectArray = new String[this.testResults.size()];
        this.testResults.copyInto(objectArray);
        return objectArray;
    }

    public synchronized String[] getTestResults(Locale locale) {
        if (this.testResults == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.testResults.size()];
        int n = 0;
        while (n < this.testResults.size()) {
            LocalizedString localizedString = new LocalizedString((String)this.testResults.get(n));
            stringArray[n] = localizedString.getString(locale);
            ++n;
        }
        return stringArray;
    }

    public synchronized void setTestResults(String[] stringArray) {
        if (this.testResults == null) {
            this.testResults = new Vector();
        } else {
            this.testResults.clear();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.testResults.add(stringArray[n]);
            ++n;
        }
    }

    public synchronized void addTestResults(String string) {
        if (this.testResults == null) {
            this.testResults = new Vector();
        }
        this.testResults.add(string);
    }

    public synchronized void replacelastTestResults(String string) {
        if (this.testResults == null) {
            this.testResults = new Vector();
            this.testResults.add(string);
            return;
        }
        this.testResults.setElementAt(string, this.testResults.size() - 1);
    }

    public Object clone() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            DiagnosticResult diagnosticResult = new DiagnosticResult();
            ElementKey elementKey = diagnosticResult.getElementKey();
            this.assertNotNull(elementKey);
            diagnosticResult.setElementKey(elementKey);
            this.assertEquals(elementKey.toString(), diagnosticResult.getExecutionID());
            Object object = diagnosticResult.clone();
            diagnosticResult = new DiagnosticResult("a", "b");
            diagnosticResult.toString();
            diagnosticResult.setTestStartTime(new CIMDateTime());
            int n = 5;
        }
    }
}

