/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.wbem.cim.CIMDateTime;
import java.util.Vector;

public class SuiteExecutable
implements TestExecutable {
    private static final String sccs_id = "@(#)SuiteExecutable.java\t1.2 05/22/01 SMI";
    private ReferenceForMSE mse;
    private DiagnosticSetting setting;
    private DiagnosticResult result;
    private Vector mses;
    private Vector tests;
    private boolean abort = false;
    private boolean isRunning = false;

    public SuiteExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting, Vector vector, Vector vector2) {
        this.mse = referenceForMSE;
        this.setting = diagnosticSetting;
        this.mses = vector;
        this.tests = vector2;
    }

    public DiagnosticSetting getDiagnosticSetting() {
        return this.setting;
    }

    public ReferenceForMSE getMSE() {
        return this.mse;
    }

    public ReferenceForMSE getExclusiveMSE() {
        return null;
    }

    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        this.result = diagnosticResult;
        this.isRunning = true;
        diagnosticResult.setTestStartTime(new CIMDateTime());
        diagnosticResult.setTestState(TestState.IN_PROGRESS);
        diagnosticResult.setEstimatedTimeOfPerforming(100);
        diagnosticResult.setPercentComplete((short)0);
        diagnosticResult.addTestResults("Settings for test :\n" + this.setting.toString());
        try {
            Object object;
            int n = 0;
            while (n < this.tests.size()) {
                TestTemplate testTemplate = (TestTemplate)this.tests.get(n);
                DiagnosticResult diagnosticResult2 = new DiagnosticResult();
                ReferenceForMSE referenceForMSE = (ReferenceForMSE)this.mses.get(n);
                System.out.println("Running test " + testTemplate.getTestName() + " on " + referenceForMSE);
                object = testTemplate.getTestExec(referenceForMSE, this.setting);
                diagnosticResult2.setTestState(TestState.IN_PROGRESS);
                diagnosticResult2.setPercentComplete((short)0);
                object.runTest(diagnosticResult2);
                diagnosticResult.add(diagnosticResult2);
                ++n;
            }
            do {
                object = Thread.currentThread();
                Thread.sleep(5000L);
                if (this.updateResult()) continue;
                diagnosticResult.setResultsToAborted();
                return;
            } while (diagnosticResult.getPercentCompleteValue() < 100);
        }
        catch (Exception exception) {
            diagnosticResult.setFinalResults(TestState.FAILED, exception.toString());
            return;
        }
        this.isRunning = false;
        this.abort = false;
    }

    private boolean updateResult() {
        int n = 0;
        boolean bl = true;
        if (this.abort) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.tests.size()) {
            DiagnosticResult diagnosticResult = this.result.get(n2);
            TestState testState = diagnosticResult.getTestStateValueMap();
            n = testState.equals(TestState.IN_PROGRESS) ? (n += diagnosticResult.getPercentCompleteValue()) : (n += 100);
            if (!testState.equals(TestState.PASSED)) {
                bl = false;
            }
            if (testState.equals(TestState.FAILED)) {
                this.result.setTestState(TestState.FAILED);
                this.result.addTestResults("Test Suite Failed");
                this.result.addTestResults("Test = " + this.result.getDiagnosticName());
                ReferenceForMSE referenceForMSE = (ReferenceForMSE)this.mses.get(n2);
                this.result.addTestResults("Node = " + referenceForMSE.getCreationClassName() + "/" + referenceForMSE.getKeyValue());
                if (this.setting.getHaltOnErrorValue()) {
                    this.result.setTestState(TestState.FAILED);
                    return false;
                }
            }
            ++n2;
        }
        this.result.setPercentComplete((short)(n /= this.tests.size()));
        if (bl) {
            this.result.setFinalResults(TestState.PASSED, "Test Suite Passed.");
        }
        return true;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        if (!this.isRunning || this.abort) {
            return false;
        }
        this.abort = true;
        this.notify();
        return true;
    }

    public boolean pauseTest() throws DiagnosticException {
        return false;
    }

    public boolean continueTest() throws DiagnosticException {
        return false;
    }
}

