/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.util.log.Report;

public abstract class TestExecutableImpl
implements TestExecutable {
    protected DiagnosticSetting setting;
    protected ReferenceForMSE mse;
    protected int warnLevel;
    protected boolean reportStatus;
    protected boolean reportErrors;
    protected boolean haltOnError;
    protected boolean isQuick;
    protected int percentCover;
    private static final String sccs_id = "@(#)TestExecutableImpl.java\t1.5 07/24/01 SMI";

    protected TestExecutableImpl(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        Report.trace.log("initialize");
        this.mse = referenceForMSE;
        this.setting = diagnosticSetting;
    }

    protected void parseSettings() {
        Report.trace.log("parseSettings");
        if (this.setting != null) {
            this.warnLevel = this.setting.getTestWarningLevelValue();
            this.reportStatus = this.setting.getReportStatusMessagesValue();
            this.reportErrors = this.setting.getReportSoftErrorsValue();
            this.haltOnError = this.setting.getHaltOnErrorValue();
        }
    }

    protected void parsePercentCoverageSettings() {
        this.isQuick = this.setting.getQuickModeValue();
        this.percentCover = this.setting.getPercentOfTestCoverageValue();
    }

    public DiagnosticSetting getDiagnosticSetting() {
        Report.trace.log("getDiagnosticSetting");
        return this.setting;
    }

    public ReferenceForMSE getMSE() {
        Report.trace.log("getMSE");
        return this.mse;
    }

    public ReferenceForMSE getExclusiveMSE() {
        Report.trace.log("getExclusiveMSE");
        return this.mse;
    }

    public boolean pauseTest() throws DiagnosticException {
        Report.trace.log("pauseTest");
        return false;
    }

    public boolean continueTest() throws DiagnosticException {
        Report.trace.log("continueTest");
        return false;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log("abortTest");
        return false;
    }

    protected void failure(String string, DiagnosticResult diagnosticResult) throws DiagnosticException {
        if (this.haltOnError) {
            throw new DiagnosticException(string);
        }
        diagnosticResult.addTestResults(string);
    }

    protected void softError(String string, DiagnosticResult diagnosticResult) {
        if (this.reportErrors || this.reportStatus) {
            diagnosticResult.addTestResults(string);
        }
    }

    protected void status(String string, DiagnosticResult diagnosticResult) {
        if (this.reportStatus) {
            diagnosticResult.addTestResults(string);
        }
    }
}

