/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.exec;

import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosableHelperImpl;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ParameterType;
import com.sun.jade.cim.util.ValueMap;
import com.sun.jade.logic.mf.MFImpl;
import com.sun.jade.logic.wbem.CIMClientUser;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Date;
import java.util.Vector;

public class RunDiag {
    String cimomHost = "localhost";
    String userName = "guest";
    String password = "";
    String systemClassName = "CIM_System";
    String systemName;
    String mseClassName;
    String mseKey;
    String testName;
    String elementKey;
    boolean listTests = true;
    boolean verbose;
    int timeout = 300;
    String[] args;

    public RunDiag(String[] stringArray) {
        this.args = stringArray;
    }

    public static void main(String[] stringArray) {
        RunDiag runDiag = new RunDiag(stringArray);
        runDiag.exec();
    }

    private void usage() {
        System.out.println("Usage: RunDiag [options] [param=value...]");
        System.out.println("\t-c <host>      CIMOM host name");
        System.out.println("\t-u <user>      CIMOM user name");
        System.out.println("\t-p <passowd>   CIMOM password");
        System.out.println("\t-s <system>    Class name of the system.");
        System.out.println("\t-n <sys name>  The name of the system.");
        System.out.println("\t-r <test name> Run the given test.");
        System.out.println("\t-m <mse class> Class name of the mse.");
        System.out.println("\t-k <mse key>   Keys to define mse.");
        System.out.println("\t-a <key>       Abort test");
        System.out.println("\t-t <timeout>   Max test run time seconds.");
    }

    private String getMSEkey(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        while (n < vector.size()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)vector.get(n);
            if (cIMProperty.getName().equalsIgnoreCase("Name") && (cIMValue = cIMProperty.getValue()) != null) {
                return (String)cIMValue.getValue();
            }
            if (cIMProperty.getName().equalsIgnoreCase("DeviceID") && (cIMValue = cIMProperty.getValue()) != null) {
                return (String)cIMValue.getValue();
            }
            ++n;
        }
        return null;
    }

    private boolean checkMSEmatch(CIMObjectPath cIMObjectPath, String string, String string2) {
        if (!string.equalsIgnoreCase(cIMObjectPath.getObjectName())) {
            return false;
        }
        String string3 = this.getMSEkey(cIMObjectPath);
        return string3 == null || string2.equalsIgnoreCase(string3);
    }

    public void exec() {
        String string;
        if (this.args.length < 1) {
            this.usage();
            System.exit(-1);
        }
        int n = 0;
        while (n < this.args.length) {
            string = this.args[n];
            if (!string.startsWith("-") || string.equals("-")) break;
            if (string.equals("-v")) {
                this.verbose = true;
                Report.setApplicationName("Diag:");
                Report.debug.enableLogging();
            } else if (string.equals("-c")) {
                this.cimomHost = this.args[++n];
            } else if (string.equals("-u")) {
                this.userName = this.args[++n];
            } else if (string.equals("-p")) {
                this.password = this.args[++n];
            } else if (string.equals("-r")) {
                this.listTests = false;
                this.testName = this.args[++n];
            } else if (string.equals("-a")) {
                this.listTests = false;
                this.elementKey = this.args[++n];
            } else if (string.equals("-k")) {
                this.mseKey = this.args[++n];
            } else if (string.equals("-m")) {
                this.mseClassName = this.args[++n];
            } else if (string.equals("-s")) {
                this.systemClassName = this.args[++n];
            } else if (string.equals("-n")) {
                this.systemName = this.args[++n];
            } else if (string.equals("-t")) {
                this.timeout = Integer.parseInt(this.args[++n]);
            }
            ++n;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            string = new CIMObjectPath(this.mseClassName);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.systemClassName);
            CIMNameSpace cIMNameSpace = new CIMNameSpace(this.cimomHost);
            CIMClientUserTestImpl cIMClientUserTestImpl = new CIMClientUserTestImpl(cIMNameSpace, this.userName, this.password);
            MFImpl mFImpl = new MFImpl(this.systemName, this.systemClassName, this.cimomHost, null, null, null, null);
            DiagnosableHelperImpl diagnosableHelperImpl = new DiagnosableHelperImpl(mFImpl, cIMClientUserTestImpl);
            System.out.println("DiagnosableHelper implemented");
            if (this.elementKey != null) {
                System.out.println("Aborting " + this.elementKey);
                diagnosableHelperImpl.abortTest(new ElementKey(this.elementKey));
                System.exit(0);
            }
            if (this.testName != null) {
                System.out.println("Running Test = " + this.testName);
                object5 = null;
                DiagnosticTestInfo[] diagnosticTestInfoArray = diagnosableHelperImpl.getDiagnosticTests();
                int n2 = 0;
                while (n2 < diagnosticTestInfoArray.length) {
                    if (diagnosticTestInfoArray[n2].getTestName().equals(this.testName) && this.checkMSEmatch(diagnosticTestInfoArray[n2].getMSE(), this.mseClassName, this.mseKey)) {
                        object4 = diagnosticTestInfoArray[n2].getSettingsForTest();
                        int n3 = n;
                        while (n3 < this.args.length) {
                            int n4 = this.args[n3].indexOf("=");
                            String string2 = this.args[n3].substring(0, n4);
                            object2 = ((DiagnosticSetting)((Object)object4)).setTestParameter(string2, (String)(object3 = this.args[n3].substring(n4 + 1)));
                            if (object2 == null) {
                                System.out.println(string2 + " NOT SET");
                            } else {
                                System.out.println(string2 + " Set To " + object2);
                            }
                            ++n3;
                        }
                        System.out.println("Running test..." + this.testName);
                        object = new UnitTestListener(this.timeout, diagnosableHelperImpl);
                        object5 = diagnosableHelperImpl.runTest(diagnosticTestInfoArray[n2], (DiagnosticResultListener)object);
                        System.out.println("Test started.");
                        ((UnitTestListener)object).notify(new DiagnosticResultEvent((DiagnosticResult)object5));
                        break;
                    }
                    ++n2;
                }
                if (object5 == null) {
                    System.out.println("Test not found.");
                }
            }
            if (this.listTests) {
                System.out.println("Getting tests...");
                object5 = diagnosableHelperImpl.getDiagnosticTests();
                System.out.println("Found " + ((DiagnosticTestInfo[])object5).length + " tests");
                int n5 = 0;
                while (n5 < ((DiagnosticTestInfo[])object5).length) {
                    DiagnosticSetting diagnosticSetting;
                    System.out.println("==========================");
                    System.out.println("Test      = " + object5[n5]);
                    CIMObjectPath cIMObjectPath2 = object5[n5].getMSE();
                    object4 = "";
                    System.out.println("MSE class = " + cIMObjectPath2.getObjectName());
                    System.out.println("MSE key   = " + this.getMSEkey(cIMObjectPath2));
                    if (object5[n5] != null && (diagnosticSetting = object5[n5].getSettingsForTest()) != null) {
                        object = diagnosticSetting.getTestParameters();
                        int n6 = 0;
                        while (n6 < ((Vector)object).size()) {
                            Object[] objectArray;
                            object3 = (TestParameter)((Vector)object).get(n6);
                            System.out.println(((TestParameter)object3).getName() + "=" + ((TestParameter)object3).getCurrentValue());
                            object2 = ((TestParameter)object3).getParameterType();
                            if (((ValueMap)object2).equals(ParameterType.CHOICE) || ((ValueMap)object2).equals(ParameterType.MULTI_CHOICE)) {
                                objectArray = ((TestParameter)object3).getValidValues();
                                int n7 = 0;
                                while (n7 < objectArray.length) {
                                    System.out.println("\t" + n7 + " = " + objectArray[n7].toString());
                                    ++n7;
                                }
                            } else if (((ValueMap)object2).equals(ParameterType.INTEGER) || ((ValueMap)object2).equals(ParameterType.HEX_NUMBER) || ((ValueMap)object2).equals(ParameterType.OCTAL_NUMBER) || ((ValueMap)object2).equals(ParameterType.SLIDER)) {
                                objectArray = ((TestParameter)object3).getValidValues();
                                if (objectArray.length == 2 && objectArray[0] instanceof Integer && objectArray[1] instanceof Integer) {
                                    System.out.println("\t(" + objectArray[0] + " - " + objectArray[1]);
                                }
                            } else if (((ValueMap)object2).equals(ParameterType.UNKNOWN)) {
                                System.out.println("\tUNKNOWN type");
                            }
                            ++n6;
                        }
                    }
                    ++n5;
                }
                Report.debug.log("==========================");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CIMClientUserTestImpl
    implements CIMClientUser {
        UserPrincipal up;
        PasswordCredential pc;
        CIMNameSpace ns;

        CIMClientUserTestImpl(CIMNameSpace cIMNameSpace, String string, String string2) {
            this.ns = cIMNameSpace;
            this.up = new UserPrincipal(string);
            this.pc = new PasswordCredential(string2);
        }

        public CIMClient getCIMClient() {
            try {
                return new CIMClient(this.ns, (Principal)this.up, (Object)this.pc, 1);
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                return null;
            }
        }

        public void finished(CIMClient cIMClient) {
            if (cIMClient == null) {
                return;
            }
            try {
                cIMClient.close();
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
    }

    class UnitTestListener
    implements DiagnosticResultListener {
        int abortSeconds;
        long startTime;
        DiagnosableHelper helper;
        int resultLines = 0;
        int resultPercent = 0;

        UnitTestListener(int n, DiagnosableHelper diagnosableHelper) throws RemoteException {
            this.abortSeconds = n;
            this.helper = diagnosableHelper;
            Date date = new Date();
            this.startTime = date.getTime();
        }

        public void notify(DiagnosticResultEvent diagnosticResultEvent) throws RemoteException {
            String[] stringArray;
            DiagnosticResult diagnosticResult = diagnosticResultEvent.getResult();
            Report.debug.log("Getting updated results");
            Report.debug.log(diagnosticResult);
            int n = diagnosticResult.getPercentCompleteValue();
            if (n != this.resultPercent) {
                this.resultPercent = n;
                System.out.println(n + "%");
            }
            if ((stringArray = diagnosticResult.getTestResults()).length != this.resultLines) {
                int n2 = this.resultLines;
                while (n2 < stringArray.length) {
                    if (stringArray[n2] != null) {
                        System.out.println(stringArray[n2]);
                    }
                    ++n2;
                }
                this.resultLines = stringArray.length;
            }
            if (this.abortTest(new ElementKey(diagnosticResult.getExecutionID()))) {
                Report.debug.log("Test timed out. Aborting!!!");
            }
            if (diagnosticResult.getTestState().intValue() != 4) {
                System.out.println("+++\nTest Execution Finished.");
                System.out.println(diagnosticResult);
            }
        }

        private boolean abortTest(ElementKey elementKey) {
            if (this.abortSeconds == 0) {
                return false;
            }
            Date date = new Date();
            long l = date.getTime();
            int n = (int)(l - this.startTime);
            if (this.abortSeconds > n) {
                return false;
            }
            try {
                this.helper.abortTest(elementKey);
                this.abortSeconds = 0;
            }
            catch (RemoteException remoteException) {
                return false;
            }
            catch (DiagnosticException diagnosticException) {
                return false;
            }
            return true;
        }
    }
}

