/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.provider;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestException;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.provider.TestQueue;
import com.sun.jade.cim.provider.TestRepository;
import com.sun.jade.cim.provider.TestRun;
import com.sun.jade.cim.util.MSE_Status;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.ReferenceForMSEinCIMOM;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.InstanceProvider;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class SADE_DiagnosticTestProvider
implements InstanceProvider,
MethodProvider {
    private ProviderCIMOMHandle cimomhandle;
    private TestTemplate[] testList;
    private TestRepository dataStore;
    public static final String classNameCIM = "SADE_DiagnosticTest";
    public static final String classNameResult = "SADE_DiagnosticResult";
    static int testExecID = 0;
    private static final String sccs_id = "@(#)SADE_DiagnosticTestProvider.java\t1.22 02/20/03 SMI";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        if (this.dataStore == null) {
            this.dataStore = TestRepository.getInstance();
            this.dataStore.init(cIMOMHandle);
            this.testList = this.dataStore.getAvailableTests();
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        TestTemplate testTemplate = this.dataStore.getTest(cIMObjectPath);
        if (cIMObjectPath.getObjectName().equalsIgnoreCase(classNameCIM)) {
            if (string.equals("RunTest")) {
                return this.runTest(cIMObjectPath, testTemplate, vector, vector2);
            }
            if (string.equals("ClearResults")) {
                return this.clearResults(testTemplate, vector, vector2);
            }
            if (string.equals("DiscontinueTest")) {
                return this.discontinueTest(testTemplate, vector, vector2);
            }
            if (string.equals("StartService")) {
                DiagnosticSetting diagnosticSetting = testTemplate.getDefaultSetting(Locale.getDefault());
                if (!diagnosticSetting.getCreationClassName().equals("SADE_DiagnosticSetting")) {
                    try {
                        this.dataStore.createSettingClass(diagnosticSetting);
                    }
                    catch (CIMException cIMException) {
                        System.out.println("Error creating setting class " + (Object)((Object)cIMException));
                    }
                }
                return new CIMValue((Object)new UnsignedInt32(0L));
            }
            if (string.equals("StopService")) {
                return new CIMValue((Object)new UnsignedInt32(0L));
            }
        }
        throw new CIMException("CIM_ERR_NOT_FOUND", (Object)string);
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        System.out.println("enumInstances path = " + cIMObjectPath);
        if (cIMObjectPath.getObjectName().equalsIgnoreCase(classNameCIM)) {
            CIMInstance cIMInstance = null;
            this.testList = this.dataStore.getAvailableTests();
            int n = 0;
            while (n < this.testList.length) {
                TestTemplate testTemplate = this.testList[n];
                System.out.println("Enumerate Test " + testTemplate.getTestName());
                cIMInstance = cIMClass.newInstance();
                this.writeCIMInstance(testTemplate, cIMInstance);
                vector.addElement(cIMInstance);
                ++n;
            }
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        System.out.println("enumInstances path = " + cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        if (cIMObjectPath.getObjectName().equalsIgnoreCase(classNameCIM)) {
            this.testList = this.dataStore.getAvailableTests();
            int n = 0;
            while (n < this.testList.length) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)this.testList[n].getTestName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)classNameCIM));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
        }
        return vector;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        System.out.println("getInstance path = " + cIMObjectPath);
        TestTemplate testTemplate = this.dataStore.getTest(cIMObjectPath);
        CIMInstance cIMInstance = cIMClass.newInstance();
        this.writeCIMInstance(testTemplate, cIMInstance);
        if (testTemplate != null) {
            // empty if block
        }
        return cIMInstance;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        System.out.println("setInstance path = " + cIMObjectPath);
        TestTemplate testTemplate = this.dataStore.getTest(cIMObjectPath);
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        System.out.println("setInstance path = " + cIMObjectPath);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        System.out.println("In deleteInstance, where cp=" + cIMObjectPath);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue runTest(CIMObjectPath cIMObjectPath, TestTemplate testTemplate, Vector vector, Vector vector2) throws CIMException {
        TestExecutable testExecutable;
        int n = 0;
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        CIMValue cIMValue = (CIMValue)vector.elementAt(0);
        CIMValue cIMValue2 = (CIMValue)vector.elementAt(1);
        System.out.println("runTest input:");
        System.out.println(cIMValue.toString());
        System.out.println(cIMValue2.toString());
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMValue.getValue();
        ReferenceForMSEinCIMOM referenceForMSEinCIMOM = new ReferenceForMSEinCIMOM(cIMObjectPath2, (CIMOMHandle)this.cimomhandle);
        if (referenceForMSEinCIMOM.getCreationClassName() == null || referenceForMSEinCIMOM.getKeyValue() == null) {
            System.out.println("Test ReferenceForMSE not found.");
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMValue2.getValue();
        DiagnosticSetting diagnosticSetting = this.dataStore.getSetting(cIMObjectPath3);
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(classNameCIM, "Name", testTemplate.getTestName());
        TestRun testRun = new TestRun(referenceForMSEinCIMOM, referenceForMSE);
        DiagnosticResult diagnosticResult = testRun.getResult();
        this.setTestExecutionID(diagnosticResult, testTemplate.getTestName());
        testRun.setSettings(diagnosticSetting);
        try {
            testExecutable = testTemplate.getTestExec(referenceForMSEinCIMOM, diagnosticSetting);
            TestQueue.master.addTest(testExecutable, diagnosticResult);
        }
        catch (TestException testException) {
            n = 1;
        }
        this.dataStore.addTestRun(testRun);
        System.out.println("Test started id = " + testRun.getResult().getExecutionID());
        testExecutable = new CIMObjectPath(classNameResult);
        testExecutable.addKey("DiagnosticCreationClassName", new CIMValue((Object)diagnosticResult.getDiagnosticCreationClassName()));
        testExecutable.addKey("DiagnosticName", new CIMValue((Object)diagnosticResult.getDiagnosticName()));
        testExecutable.addKey("ExecutionID", new CIMValue((Object)diagnosticResult.getExecutionID()));
        vector2.add(new CIMValue((Object)testExecutable));
        return new CIMValue((Object)new UnsignedInt32((long)n));
    }

    private CIMValue clearResults(TestTemplate testTemplate, Vector vector, Vector vector2) throws CIMException {
        int n = 2;
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        CIMValue cIMValue = (CIMValue)vector.elementAt(0);
        System.out.println("clearResults input:");
        System.out.println(cIMValue.toString());
        CIMObjectPath cIMObjectPath = (CIMObjectPath)cIMValue.getValue();
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(cIMObjectPath);
        if (referenceForMSE.getCreationClassName() == null || referenceForMSE.getKeyValue() == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        Collection collection = this.dataStore.getTestRunCollection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TestRun testRun = (TestRun)iterator.next();
            if (!referenceForMSE.equals(testRun.getDeviceRef())) continue;
            DiagnosticResult diagnosticResult = testRun.getResult();
            if (diagnosticResult.getTestState().equals((Object)TestState.IN_PROGRESS)) {
                vector2.add(new CIMValue((Object)diagnosticResult.getExecutionID()));
                continue;
            }
            this.dataStore.deleteTestRun(testRun.getID());
        }
        return new CIMValue((Object)new UnsignedInt32((long)n));
    }

    private CIMValue discontinueTest(TestTemplate testTemplate, Vector vector, Vector vector2) throws CIMException {
        Object object;
        int n = 0;
        TestRun testRun = null;
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        CIMValue cIMValue = (CIMValue)vector.elementAt(0);
        CIMValue cIMValue2 = (CIMValue)vector.elementAt(1);
        CIMObjectPath cIMObjectPath = (CIMObjectPath)cIMValue.getValue();
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(cIMObjectPath);
        if (referenceForMSE.getCreationClassName() == null || referenceForMSE.getKeyValue() == null) {
            System.out.println("Failed to abort " + testTemplate.getTestName());
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMValue2.getValue();
        String string = null;
        Enumeration enumeration = cIMObjectPath2.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase("ExecutionID")) continue;
            string = (String)object.getValue().getValue();
        }
        System.out.println("====discontinueTest====");
        System.out.println("Test   = " + cIMObjectPath);
        System.out.println("Result = " + cIMObjectPath2);
        System.out.println("Aborting Test Run " + string);
        testRun = this.dataStore.getTestRun(string);
        if (testRun == null) {
            System.out.println("Couldn't find " + string);
            vector2.add(CIMValue.TRUE);
            throw new CIMException("CIM_ERR_FAILED");
        }
        object = new Boolean(TestQueue.master.abortTest(testRun.getResult()));
        vector2.add(new CIMValue(object));
        return new CIMValue((Object)new UnsignedInt32((long)n));
    }

    private void writeCIMInstance(TestTemplate testTemplate, CIMInstance cIMInstance) {
        Object object;
        if (testTemplate == null) {
            return;
        }
        cIMInstance.setProperty("Name", new CIMValue((Object)testTemplate.getTestName()));
        cIMInstance.setProperty("StartMode", new CIMValue((Object)"Automatic"));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)classNameCIM));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"CIM_System"));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)"localhost"));
        cIMInstance.setProperty("IsInUse", CIMValue.FALSE);
        cIMInstance.setProperty("Started", CIMValue.TRUE);
        int[] nArray = testTemplate.getTestCharacteristics();
        if (nArray != null && nArray.length > 0) {
            object = new Vector();
            int n = 0;
            while (n < nArray.length) {
                ((Vector)object).add(new UnsignedInt16(nArray[n]));
                ++n;
            }
            cIMInstance.setProperty("Characteristics", new CIMValue((Vector)object, new CIMDataType(16)));
        }
        if ((object = testTemplate.getTestResources()) != null && ((int[])object).length > 0) {
            Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
            int n = 0;
            while (n < ((int[])object).length) {
                vector.add(new UnsignedInt16((int)object[n]));
                ++n;
            }
            cIMInstance.setProperty("ResourcesUsed", new CIMValue(vector, new CIMDataType(16)));
        }
        cIMInstance.setProperty("Caption", new CIMValue((Object)testTemplate.getTestCaption(Locale.getDefault())));
        cIMInstance.setProperty("Description", new CIMValue((Object)testTemplate.getTestDescription(Locale.getDefault())));
        cIMInstance.setProperty("Status", new CIMValue((Object)MSE_Status.OK.toString()));
    }

    private synchronized void setTestExecutionID(DiagnosticResult diagnosticResult, String string) {
        diagnosticResult.setExecutionID(string + ":" + ++testExecID);
    }

    public static class Test
    extends UnitTest {
        public void testInit() throws CIMException {
            SADE_DiagnosticTestProvider sADE_DiagnosticTestProvider = new SADE_DiagnosticTestProvider();
            sADE_DiagnosticTestProvider.initialize(null);
            sADE_DiagnosticTestProvider.cleanup();
        }
    }
}

