/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.provider;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.provider.TestRegister;
import com.sun.jade.cim.provider.TestRun;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class TestRepository {
    private static final String sccs_id = "@(#)TestRepository.java\t1.13 02/20/03 SMI";
    private static TestRepository INSTANCE = new TestRepository();
    private CIMOMHandle cimom;
    private TestTemplate[] tests;
    private Map testMap = new HashMap();
    private Map testRunMap = new HashMap();
    private Map settingMap = new HashMap();

    public static TestRepository getInstance() {
        return INSTANCE;
    }

    private TestRepository() {
    }

    public synchronized void registerTest(TestTemplate testTemplate) {
        DiagnosticSetting diagnosticSetting;
        System.out.println("Registering test " + testTemplate.getTestName());
        this.testMap.put(testTemplate.getTestName(), testTemplate);
        if (this.cimom != null && !(diagnosticSetting = testTemplate.getDefaultSetting(Locale.getDefault())).getCreationClassName().equals("CIM_DiagnosticSetting")) {
            try {
                this.createSettingClass(diagnosticSetting);
            }
            catch (CIMException cIMException) {
                System.out.println("Error creating setting class " + (Object)((Object)cIMException));
            }
        }
        this.tests = null;
    }

    void createSettingClass(DiagnosticSetting diagnosticSetting) throws CIMException {
        CIMClass cIMClass = diagnosticSetting.getCIMClass();
        String string = diagnosticSetting.getCreationClassName();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string, "\\root\\cimv2");
        System.out.println("createSettingClass=" + cIMClass);
        CIMClass cIMClass2 = null;
        try {
            cIMClass2 = this.cimom.getClass(cIMObjectPath, true);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        if (cIMClass2 != null) {
            return;
        }
        this.cimom.createClass(cIMObjectPath, cIMClass);
    }

    public synchronized void registerTests(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                Class<?> clazz = Class.forName(stringArray[n]);
                TestTemplate testTemplate = (TestTemplate)clazz.newInstance();
                this.registerTest(testTemplate);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    synchronized TestTemplate[] getAvailableTests() {
        if (this.tests == null) {
            if (this.testMap.size() > 0) {
                Collection collection = this.testMap.values();
                this.tests = (TestTemplate[])collection.toArray((Object[])new TestTemplate[0]);
            } else {
                this.tests = new TestTemplate[0];
            }
        }
        return this.tests;
    }

    synchronized TestTemplate getTest(String string) throws CIMException {
        if (string == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        TestTemplate testTemplate = (TestTemplate)this.testMap.get(string);
        if (testTemplate == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        return testTemplate;
    }

    synchronized TestTemplate getTest(CIMObjectPath cIMObjectPath) throws CIMException {
        Object var2_2 = null;
        String string = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("Name") || (cIMValue = cIMProperty.getValue()) == null) continue;
            string = (String)cIMValue.getValue();
        }
        return this.getTest(string);
    }

    synchronized void addSetting(DiagnosticSetting diagnosticSetting) throws CIMException {
        if (this.settingMap.containsKey(diagnosticSetting.getKey())) {
            throw new CIMException("CIM_ERR_ALREADY_EXISTS");
        }
        this.settingMap.put(diagnosticSetting.getSettingID(), diagnosticSetting);
    }

    synchronized void deleteSetting(DiagnosticSetting diagnosticSetting) throws CIMException {
        Object v = this.settingMap.remove(diagnosticSetting.getSettingID());
        if (v == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
    }

    synchronized DiagnosticSetting getSetting(String string) throws CIMException {
        if (string == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        DiagnosticSetting diagnosticSetting = (DiagnosticSetting)((Object)this.settingMap.get(string));
        if (diagnosticSetting == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        return diagnosticSetting;
    }

    synchronized DiagnosticSetting getSetting(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        Object var3_3 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("SettingID") || (cIMValue = cIMProperty.getValue()) == null) continue;
            string = (String)cIMValue.getValue();
        }
        return this.getSetting(string);
    }

    synchronized Collection getSettingCollection() {
        return this.settingMap.values();
    }

    synchronized void addTestRun(TestRun testRun) {
        this.testRunMap.put(testRun.getID(), testRun);
    }

    synchronized void deleteTestRun(String string) throws CIMException {
        Object v = this.testRunMap.remove(string);
        if (v == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
    }

    synchronized void storeFinishedTests(InstanceProvider instanceProvider, CIMClass cIMClass) throws CIMException {
        if (cIMClass == null) {
            return;
        }
        Iterator iterator = this.settingMap.values().iterator();
        while (iterator.hasNext()) {
            TestRun testRun = (TestRun)iterator.next();
            DiagnosticResult diagnosticResult = testRun.getResult();
            if (diagnosticResult.getPercentCompleteValue() < 100) continue;
            CIMObjectPath cIMObjectPath = new CIMObjectPath();
            CIMInstance cIMInstance = cIMClass.newInstance();
            diagnosticResult.writeCIMInstance(cIMInstance);
            this.deleteTestRun(diagnosticResult.getExecutionID());
            instanceProvider.createInstance(cIMObjectPath, cIMInstance);
        }
    }

    synchronized TestRun getTestRun(String string) throws CIMException {
        if (string == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        TestRun testRun = (TestRun)this.testRunMap.get(string);
        if (testRun == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        return testRun;
    }

    synchronized Collection getTestRunCollection() {
        return this.testRunMap.values();
    }

    void init(CIMOMHandle cIMOMHandle) {
        if (this.cimom == null) {
            this.cimom = cIMOMHandle;
            this.registerTests(TestRegister.getRegister());
        }
    }
}

