/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.util;

import com.sun.jade.cim.bean.CIM_Configuration;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Properties;
import java.util.StringTokenizer;

public class EmbeddedObject {
    private static final String sccs_id = "(#)@EmbeddedObject.java 1.6 02/04/08 SMI";
    private Properties properties = new Properties();
    public static final String JADE_BEAN_PKG = "com.sun.jade.cim.bean";
    public static final String SWITCH_BEAN_PKG = "com.sun.jade.cim.bean";
    public static final String T3_BEAN_PKG = "com.sun.jade.cim.bean";
    private static final String[] BEAN_PKGS = new String[]{"com.sun.jade.cim.bean", "com.sun.jade.cim.bean", "com.sun.jade.cim.bean"};
    public static final String MOF_DELIMETER = ";";
    public static final char MOF_ESCAPE_CHAR = '\\';
    public static final char MOF_QUOTE_CHAR = '\"';
    public static final String MOF_QUOTE_STRING = "\"";
    public static final String MOF_INSTANCE_KEYWORD = "INSTANCE";
    public static final String MOF_OF_KEYWORD = "OF";
    public static final String MOF_INSTANCE_BEGIN = "{";
    public static final String MOF_INSTANCE_END = "}";
    private String className;
    private StringTokenizer parseString;

    public EmbeddedObject(String string) throws InvalidFormatException {
        this.parseEmbeddedObject(string);
    }

    public CIMBean getBean() {
        int n = 0;
        while (n < BEAN_PKGS.length) {
            try {
                CIMBean cIMBean = this.getBean(BEAN_PKGS[n]);
                return cIMBean;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return null;
    }

    public CIMBean getBean(String string) throws Exception {
        CIMBeanBase cIMBeanBase = null;
        Class<?> clazz = Class.forName(string + "." + this.className);
        cIMBeanBase = (CIMBeanBase)clazz.newInstance();
        cIMBeanBase.fromMOFProperties(this.properties);
        return cIMBeanBase;
    }

    public String getClassName() {
        return this.className;
    }

    private void parseEmbeddedObject(String string) throws InvalidFormatException {
        String string2;
        this.parseString = new StringTokenizer(string);
        if (this.parseString.hasMoreTokens()) {
            string2 = this.parseString.nextToken();
            if (!MOF_INSTANCE_KEYWORD.equals(string2.toUpperCase())) {
                throw new InvalidFormatException("Missing INSTANCE keyword");
            }
        } else {
            throw new InvalidFormatException("Premature End of  Definiton parsing at INSTANCE");
        }
        if (this.parseString.hasMoreTokens()) {
            string2 = this.parseString.nextToken();
            if (!MOF_OF_KEYWORD.equals(string2.toUpperCase())) {
                throw new InvalidFormatException("Missing OF keyword");
            }
        } else {
            throw new InvalidFormatException("Premature End of  Definition parsing at OF");
        }
        if (!this.parseString.hasMoreTokens()) {
            throw new InvalidFormatException("Premature End of Definition parsing at classname");
        }
        this.className = this.parseString.nextToken();
        if (this.parseString.hasMoreTokens()) {
            string2 = this.parseString.nextToken();
            if (!string2.startsWith(MOF_INSTANCE_BEGIN)) {
                throw new InvalidFormatException("Missing {");
            }
            if (string2.length() > 1) {
                int n = string.indexOf(MOF_INSTANCE_BEGIN) + 1;
                if (n == -1) {
                    throw new InvalidFormatException("Missing {");
                }
                this.parseString = new StringTokenizer(string.substring(n));
            }
        } else {
            throw new InvalidFormatException("Premature End of Definition parsing at {");
        }
        String string3 = null;
        String string4 = null;
        while (this.parseString.hasMoreTokens()) {
            string2 = this.parseString.nextToken(MOF_DELIMETER);
            while (string2.charAt(string2.length() - 1) == '\\') {
                if (this.parseString.hasMoreTokens()) {
                    string2 = string2 + MOF_DELIMETER + this.parseString.nextToken();
                    continue;
                }
                throw new InvalidFormatException("Premature End of Definition parsing at " + string2);
            }
            if (MOF_INSTANCE_END.equals(string2)) break;
            if (string2.indexOf("=") == -1) continue;
            string3 = string2.substring(0, string2.indexOf("="));
            string3 = string3.trim();
            string4 = this.getAttrValue(string2.substring(string2.indexOf("=") + 1));
            if (string4 == null) continue;
            this.properties.setProperty(string3, string4);
        }
    }

    private String getAttrValue(String string) throws InvalidFormatException {
        String string2;
        if ((string = string.trim()).startsWith(MOF_QUOTE_STRING)) {
            int n = string.lastIndexOf(34);
            if (n == 0) {
                throw new InvalidFormatException("Missing close quote: " + string);
            }
            string2 = string;
        } else {
            string2 = string;
        }
        if (string2.equals("null")) {
            string2 = null;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testMSE();
    }

    public static class Test
    extends UnitTest {
        public void testMSE() {
            String[] stringArray = new String[]{"Instance of CIM_Configuration  {Caption=\"testvalue\";Description=\"testdesc\";Name= null;}", "Instance of CIM_Configuration { Caption=\"testvalue\"   ;}", "Instance of CIM_Configuration {Caption =\"testvalue\";   }", "Instance of CIM_Configuration {Caption= \"test value\"   ;   }", "Instance of CIM_Configuration {Caption = \"testvalue\";Name=null;}", "Instance of CIM_Configuration { Caption = \"testvalue\";}", "Instance of CIM_Configuration { Caption = \"test\\; value\";}", "Instance of CIM_Configuration { Caption = \"testvalue\";}", "Instance of CIM_Configuration {Caption= \"prevValue\";Name=\"Name\"}", "Instance of CIM_Configuration {Caption=\"prevValue\";}", "Instance of CIM_Configuration {Caption=\"prevValue\"  ;  }", "Instance of CIM_Configuration {Caption=\"prevValue\";}", "Instance of CIM_Configuration {Caption=\"prev\\\" \\\"Value\";}", "Instance of CIM_Configuration {Caption=\"prevValue\";}", "Instance of CIM_Configuration {   Caption   =   \"prev Value\"   ;   }", "Instance of CIM_Configuration {Caption=\"prevValue\";}", "Instance of CIM_Configuration { attr = \"junk\" }", "Instance of CIM_Configuration { attr junk;}", "Instance of {     fgfd", "Instance of {", "Instance of CIM_Configuration { attr junk;}", "Instance of CIM_Configuration { attr = \"junk\" }", "lsfdg;khsfkld;"};
            String[] stringArray2 = new String[]{"testvalue", "testvalue", "testvalue", "test value", "testvalue", "testvalue", "test\\; value", "testvalue", "prevValue", "prevValue", "prevValue", "prevValue", "prev\\\" \\\"Value", "prevValue", "prev Value", "prevValue", "Missing \"=\": attr junk", "Missing \"=\": attr junk", "Missing {", "Premature End of Definition parsing at {", "Premature End of Definition", "Premature End of Definition", "Missing INSTANCE keyword"};
            String string = null;
            String string2 = null;
            String string3 = null;
            EmbeddedObject embeddedObject = null;
            Properties properties = null;
            int n = 0;
            while (n < 15) {
                try {
                    string = null;
                    embeddedObject = new EmbeddedObject(stringArray[n]);
                    CIM_Configuration cIM_Configuration = (CIM_Configuration)embeddedObject.getBean();
                    properties = null;
                    properties = embeddedObject.properties;
                    string2 = properties.getProperty("Caption");
                    if (string2 != null && string2.startsWith(EmbeddedObject.MOF_QUOTE_STRING) && string2.endsWith(EmbeddedObject.MOF_QUOTE_STRING)) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    string3 = cIM_Configuration.getCaption();
                    this.assertEquals(string2, string3);
                }
                catch (InvalidFormatException invalidFormatException) {
                    string = invalidFormatException.getMessage();
                }
                if (n > 15) {
                    if (n == 17 || n == 18 || n == 21 || n == 22) {
                        this.assertEquals(string, null);
                    } else {
                        this.assertEquals(stringArray2[n], string);
                    }
                } else {
                    this.assertEquals(stringArray2[n], string2);
                }
                ++n;
            }
        }
    }

    public class InvalidFormatException
    extends Exception {
        InvalidFormatException(String string) {
            super(string);
        }
    }
}

