/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cli;

import com.sun.jade.cli.util.PasswordField;
import com.sun.jade.cli.util.Utilities;
import com.sun.jade.cli.util.ValueField;
import java.io.IOException;
import java.util.HashMap;

class Command {
    protected static final String USER_COMMAND = "--username";
    protected static final String PASSWORD_COMMAND = "--password";
    protected static final String ROLE_COMMAND = "--role";
    protected static final String SERVER_COMMAND = "--server";
    protected static final String PORT_COMMAND = "--port";
    protected static final String PROXY_HOST_COMMAND = "--proxyHost";
    protected static final String PROXY_PORT_COMMAND = "--proxyPort";
    protected static final String TRUSTED_COMMAND = "--trusted";
    protected static final String USER = "username";
    protected static final String PASSWORD = "password";
    protected static final String ROLE = "role";
    protected static final String SERVER = "server";
    protected static final String PORT = "port";
    protected static final String PROXY_HOST = "proxyHost";
    protected static final String PROXY_PORT = "proxyPort";
    protected static final String SECURE_SERVER = "https.server";
    protected static final String SECURE_PORT = "https.port";
    protected static final String SECURE_PROXY_HOST = "https.proxyHost";
    protected static final String SECURE_PROXY_PORT = "https.proxyPort";
    protected static final String TRUSTED = "trusted";
    protected static final String SECURE = "secure";
    protected static final String SECURE_OPTION = "--secure";
    protected static final String SECURE_SHORT_OPTION = "-s";
    private boolean isSecure = false;
    private String user;
    private String password;
    private String role;
    private String server;
    private String port;
    private String proxyHost;
    private String proxyPort;
    private String trusted;
    private String[] args;

    public boolean isSecure() {
        return this.isSecure;
    }

    public Command(String[] stringArray) {
        this.args = stringArray;
        this.build();
    }

    private void build() {
        if (this.args == null) {
            return;
        }
        int n = 0;
        if (this.args.length > 0 && (SECURE_OPTION.equals(this.args[0]) || SECURE_SHORT_OPTION.equals(this.args[0]))) {
            this.isSecure = true;
            n = 1;
        }
        int n2 = n;
        while (n2 < this.args.length) {
            if (SERVER_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.server = this.args[n2 + 1];
                }
            } else if (PORT_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.port = this.args[n2 + 1];
                }
            } else if (USER_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.user = this.args[n2 + 1];
                }
            } else if (PASSWORD_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.password = this.args[n2 + 1];
                }
            } else if (ROLE_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.role = this.args[n2 + 1];
                }
            } else if (PROXY_HOST_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.proxyHost = this.args[n2 + 1];
                }
            } else if (PROXY_PORT_COMMAND.equals(this.args[n2])) {
                if (n2 < this.args.length - 1) {
                    this.proxyPort = this.args[n2 + 1];
                }
            } else if (TRUSTED_COMMAND.equals(this.args[n2]) && n2 < this.args.length - 1) {
                this.trusted = this.args[n2 + 1];
            }
            ++n2;
        }
        HashMap hashMap = Utilities.readFile();
        String string = (String)hashMap.get(SECURE);
        if ("true".equals(string)) {
            this.isSecure = true;
        }
        if (this.user == null) {
            this.user = (String)hashMap.get(USER);
        }
        if (this.password == null) {
            this.password = (String)hashMap.get(PASSWORD);
        }
        if (this.role == null) {
            this.role = (String)hashMap.get(ROLE);
        }
        if (this.server == null) {
            this.server = !this.isSecure ? (String)hashMap.get(SERVER) : (String)hashMap.get(SECURE_SERVER);
            if (this.server == null) {
                this.server = "localhost";
            }
        }
        if (this.port == null) {
            if (!this.isSecure) {
                this.port = (String)hashMap.get(PORT);
                if (this.port == null) {
                    this.port = "80";
                }
            } else {
                this.port = (String)hashMap.get(SECURE_PORT);
                if (this.port == null) {
                    this.port = "443";
                }
            }
        }
        if (this.proxyHost == null) {
            if (!this.isSecure) {
                this.proxyHost = (String)hashMap.get(PROXY_HOST);
                if (this.proxyHost != null) {
                    System.getProperties().put(PROXY_HOST, this.proxyHost);
                }
            } else {
                this.proxyHost = (String)hashMap.get(SECURE_PROXY_HOST);
                if (this.proxyHost != null) {
                    System.getProperties().put(SECURE_PROXY_HOST, this.proxyHost);
                }
            }
        }
        if (this.proxyPort == null) {
            if (!this.isSecure) {
                this.proxyPort = (String)hashMap.get(PROXY_PORT);
                if (this.proxyPort != null) {
                    System.getProperties().put(PROXY_PORT, this.proxyPort);
                }
            } else {
                this.proxyPort = (String)hashMap.get(SECURE_PROXY_PORT);
                if (this.proxyPort != null) {
                    System.getProperties().put(SECURE_PROXY_PORT, this.proxyPort);
                }
            }
        }
        if (this.isSecure && this.trusted == null) {
            this.trusted = (String)hashMap.get(TRUSTED);
            if (this.trusted == null) {
                this.trusted = "";
            }
        }
    }

    public void validate() throws IOException {
        if (this.user == null) {
            this.user = new ValueField().getValue("User:");
        }
        if (this.password == null) {
            this.password = new PasswordField().getPassword("Password:");
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRole() {
        return this.role;
    }

    public String getServer() {
        return this.server;
    }

    public String getPort() {
        return this.port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getTrusted() {
        return this.trusted;
    }

    public String getParameters() {
        if (this.args == null) {
            return "";
        }
        int n = this.isSecure ? 1 : 0;
        String string = "";
        int n2 = n;
        while (n2 < this.args.length) {
            String string2 = this.args[n2];
            if (string2.indexOf(" ") != -1) {
                string2 = "\"" + string2 + "\"";
            }
            string = string + string2 + " ";
            ++n2;
        }
        return string;
    }

    public String toString() {
        String string = "isSecure:   " + this.isSecure + "\n" + "server:     " + this.server + "\n" + "port:       " + this.port + "\n" + "user:       " + this.user + "\n" + "password:   " + this.password + "\n" + "proxyHost:  " + this.proxyHost + "\n" + "proxyPort:  " + this.proxyPort + "\n" + "parameters: " + this.getParameters() + "\n";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        Command command = new Command(stringArray);
        command.validate();
        System.out.println(command);
    }
}

