/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cli.parser;

import com.sun.jade.cli.parser.TagProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;

public class TABLEProcessor
implements TagProcessor {
    private static final String lineSeparator = System.getProperty("line.separator", "\r\n");
    private static final HTML.Tag[] tags = new HTML.Tag[]{HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.TD};
    private Writer out;
    private boolean isInTable = false;
    private int columnIndex = 0;
    private Vector column;
    private Vector table;
    private Vector line;
    private Vector cell;

    public TABLEProcessor(Writer writer) {
        this.out = writer;
    }

    public HTML.Tag[] getTags() {
        return tags;
    }

    public boolean isActive() {
        return this.isInTable;
    }

    public void processText(char[] cArray) {
        this.processTableElement(cArray);
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
        if (tag == HTML.Tag.TABLE) {
            this.startTable();
        } else if (tag == HTML.Tag.TD) {
            this.startTD();
        } else if (tag == HTML.Tag.TR) {
            this.startTR();
        }
    }

    public void handleEndTag(HTML.Tag tag) {
        if (tag == HTML.Tag.TABLE) {
            this.endTable();
        } else if (tag == HTML.Tag.TD) {
            this.endTD();
        } else if (tag == HTML.Tag.TR) {
            this.endTR();
        }
    }

    private void processColumn(Vector vector, char[] cArray, int n) {
        if (n < vector.size()) {
            Integer n2 = (Integer)vector.get(n);
            if (cArray.length > n2) {
                vector.set(n, new Integer(cArray.length));
            }
        } else if (n == vector.size()) {
            vector.add(new Integer(cArray.length));
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void startTable() {
        this.isInTable = true;
        this.column = new Vector();
        this.table = new Vector();
    }

    private void endTable() {
        try {
            this.out.write(lineSeparator);
            int n = 0;
            while (n < this.table.size()) {
                Vector vector = (Vector)this.table.get(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    char[] cArray = (char[])vector.get(n2);
                    this.out.write(cArray);
                    this.out.write(32);
                    int n3 = (Integer)this.column.get(n2) - cArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        this.out.write(32);
                        ++n4;
                    }
                    ++n2;
                }
                this.out.write(lineSeparator);
                this.out.flush();
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.isInTable = false;
    }

    private void startTR() {
        this.line = new Vector();
    }

    private void endTR() {
        this.table.add(this.line);
        this.columnIndex = 0;
    }

    private void startTD() {
        this.cell = new Vector();
    }

    private void processTableElement(char[] cArray) {
        this.cell.add(cArray);
    }

    private void endTD() {
        char[] cArray;
        int n = 0;
        int n2 = 0;
        while (n2 < this.cell.size()) {
            cArray = (char[])this.cell.get(n2);
            n += cArray.length;
            ++n2;
        }
        cArray = new char[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.cell.size()) {
            char[] cArray2 = (char[])this.cell.get(n4);
            int n5 = 0;
            while (n5 < cArray2.length) {
                cArray[n3] = cArray2[n5];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.line.add(cArray);
        this.processColumn(this.column, cArray, this.columnIndex);
        ++this.columnIndex;
    }
}

