/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cli.parser;

import com.sun.jade.cli.parser.TagProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;

public class ULProcessor
implements TagProcessor {
    private static final String lineSeparator = System.getProperty("line.separator", "\r\n");
    private static final HTML.Tag[] tags = new HTML.Tag[]{HTML.Tag.UL, HTML.Tag.LI};
    private static final String TYPE = "type";
    private static final String DISK = "disk";
    private static final String CIRCLE = "circle";
    private static final String SQUARE = "square";
    private Writer out;
    private int level = 0;
    private String mode;
    private boolean isInList = false;
    private Vector line;
    private Vector cell;

    public ULProcessor(Writer writer) {
        this.out = writer;
    }

    public HTML.Tag[] getTags() {
        return tags;
    }

    public boolean isActive() {
        return this.isInList;
    }

    public void processText(char[] cArray) {
        this.processListElement(cArray);
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
        if (tag == HTML.Tag.UL) {
            this.startUL(mutableAttributeSet);
        } else if (tag == HTML.Tag.LI) {
            this.startLI();
        }
    }

    public void handleEndTag(HTML.Tag tag) {
        if (tag == HTML.Tag.UL) {
            this.endUL();
        } else if (tag == HTML.Tag.LI) {
            this.endLI();
        }
    }

    private void startUL(MutableAttributeSet mutableAttributeSet) {
        ++this.level;
        this.mode = null;
        if (mutableAttributeSet != null) {
            Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                HTML.Attribute attribute = (HTML.Attribute)enumeration.nextElement();
                if (!TYPE.equals(attribute.toString())) continue;
                this.mode = (String)mutableAttributeSet.getAttribute(attribute);
            }
        }
        if (!this.isInList) {
            this.isInList = true;
            this.line = new Vector();
        }
    }

    private void endUL() {
        --this.level;
        if (this.level != 0) {
            return;
        }
        try {
            this.out.write(lineSeparator);
            int n = 0;
            while (n < this.line.size()) {
                IndexedText indexedText = (IndexedText)this.line.get(n);
                int n2 = indexedText.index;
                char[] cArray = indexedText.value;
                int n3 = 1;
                while (n3 < n2) {
                    this.out.write(32);
                    this.out.write(32);
                    ++n3;
                }
                if (DISK.equals(indexedText.mode)) {
                    this.out.write(42);
                    this.out.write(32);
                } else if (CIRCLE.equals(indexedText.mode)) {
                    this.out.write(111);
                    this.out.write(32);
                } else if (SQUARE.equals(indexedText.mode)) {
                    this.out.write(35);
                    this.out.write(32);
                }
                this.out.write(cArray);
                this.out.write(lineSeparator);
                this.out.flush();
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.isInList = false;
    }

    private void startLI() {
        this.cell = new Vector();
    }

    private void endLI() {
        char[] cArray;
        int n = 0;
        int n2 = 0;
        while (n2 < this.cell.size()) {
            cArray = (char[])this.cell.get(n2);
            n += cArray.length;
            ++n2;
        }
        cArray = new char[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.cell.size()) {
            char[] cArray2 = (char[])this.cell.get(n4);
            int n5 = 0;
            while (n5 < cArray2.length) {
                cArray[n3] = cArray2[n5];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.line.add(new IndexedText(this.level, cArray, this.mode));
    }

    private void processListElement(char[] cArray) {
        this.cell.add(cArray);
    }

    private class IndexedText {
        int index;
        char[] value;
        String mode;

        IndexedText(int n, char[] cArray, String string) {
            this.index = n;
            this.value = cArray;
            this.mode = string;
        }
    }
}

