/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.wbem;

import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.topology.lib.TopologyHelper;
import com.sun.jade.device.host.wbem.CIMAssetHelper;
import com.sun.jade.device.host.wbem.CIMTopologyHelper;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.logic.asset.AssetHelper;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.MFAdmin;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.logic.wbem.CIMBeanHelper;
import com.sun.jade.logic.wbem.CIMClientUser;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Properties;

public class CIMHostMF
implements MF,
CIMClientUser,
MFAdmin {
    private String systemName;
    private String systemClassName = "CIM_UnitaryComputerSystem";
    private String cimomIp;
    private Properties properties;
    private LocalizedMessage caption = new LocalizedString("host");
    private LocalizedMessage description = new LocalizedString("CIM Computer System");
    private AssetHelper assetHelper;
    private TopologyHelper topologyHelper;
    private CIMBeanHelper healthHelper;
    private DiagnosableHelper diagHelper;
    private CIMClient cc;
    private MFStatus status;
    private boolean started;
    private static final String sccs_id = "@(#)CIMHostMF.java\t1.6 09/16/02 SMI";

    public CIMHostMF(Properties properties) {
        this.properties = properties;
        this.systemName = this.cimomIp = this.resolveIP(properties);
        this.caption = new LocalizedString(this.cimomIp);
        this.init();
        this.topologyHelper = new CIMTopologyHelper(this);
        this.assetHelper = new CIMAssetHelper(this);
    }

    private void init() {
        Report.debug.log("CIMHostMF starting...");
        this.status = MFStatus.STARTING;
        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.cimomIp);
        UserPrincipal userPrincipal = new UserPrincipal(this.properties.getProperty("user"));
        PasswordCredential passwordCredential = new PasswordCredential(this.properties.getProperty("password"));
        try {
            this.cc = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential, 1);
        }
        catch (Exception exception) {
            try {
                Report.info.log("Using XML connection to CIMOM.");
                this.cc = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential, 0);
            }
            catch (Exception exception2) {
                this.status = MFStatus.NO_CONTACT;
                this.started = false;
                Report.error.log(exception2, (Object)"Service failed to start.");
                return;
            }
        }
        this.started = true;
    }

    public String getClassName() {
        return this.systemClassName;
    }

    public String getName() {
        return this.systemName;
    }

    public String getManagerName() {
        return this.cimomIp;
    }

    public LocalizedMessage getDescription() {
        return this.description;
    }

    public LocalizedMessage getCaption() {
        return this.caption;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ServiceHelper[] getServiceHelpers() throws RemoteException {
        int n = 0;
        if (this.assetHelper != null) {
            ++n;
        }
        if (this.topologyHelper != null) {
            ++n;
        }
        if (this.healthHelper != null) {
            ++n;
        }
        if (this.diagHelper != null) {
            ++n;
        }
        ServiceHelper[] serviceHelperArray = new ServiceHelper[n];
        int n2 = 0;
        if (this.assetHelper != null) {
            serviceHelperArray[n2++] = this.assetHelper;
        }
        if (this.topologyHelper != null) {
            serviceHelperArray[n2++] = this.topologyHelper;
        }
        if (this.healthHelper != null) {
            serviceHelperArray[n2++] = this.healthHelper;
        }
        if (this.diagHelper != null) {
            serviceHelperArray[n2++] = this.diagHelper;
        }
        return serviceHelperArray;
    }

    public ServiceHelper getServiceHelper(String string) throws RemoteException {
        Class<?> clazz;
        ServiceHelper[] serviceHelperArray = this.getServiceHelpers();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.warning.log(classNotFoundException.toString());
            return null;
        }
        int n = 0;
        while (n < serviceHelperArray.length) {
            if (clazz.isInstance(serviceHelperArray[n])) {
                return serviceHelperArray[n];
            }
            ++n;
        }
        return null;
    }

    public MFAdmin getAdmin() {
        return this;
    }

    public MFStatus getStatus() {
        return this.status;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void startService() {
        this.init();
    }

    public void stopService() {
        this.status = MFStatus.STOPPING;
        try {
            this.cc.close();
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        this.started = false;
        this.status = MFStatus.STOPPED;
        this.cc = null;
    }

    public CIMClient getCIMClient() {
        return this.cc;
    }

    public void finished(CIMClient cIMClient) {
    }

    private String resolveIP(Properties properties) {
        String string;
        String string2;
        InetAddress inetAddress;
        boolean bl = false;
        String string3 = properties.getProperty("ip");
        try {
            inetAddress = InetAddress.getByName(string3);
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = properties.getProperty("ipno");
            if (string2 == null) {
                throw new IllegalArgumentException("Unknown ip " + string3);
            }
            string3 = string2;
            try {
                inetAddress = InetAddress.getByName(string3);
            }
            catch (UnknownHostException unknownHostException2) {
                throw new IllegalArgumentException("Unknown ip " + string3);
            }
        }
        String string4 = properties.getProperty("ipno");
        if (string4 == null || !string4.equals(string2)) {
            properties.setProperty("ipno", string2);
            bl = true;
        }
        if ((string = properties.getProperty("logicalName")) == null) {
            properties.setProperty("logicalName", inetAddress.getHostName());
            DeviceConfig deviceConfig = StoradeEnvironment.getDeviceConfig();
            deviceConfig.store();
        }
        if (bl) {
            bl = true;
        }
        return string3;
    }
}

