/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.apps.diags.lib.Diagnosable;
import com.sun.jade.apps.diags.lib.DiagnosticMonitor;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.protocol.agent.DiagnosticListCommand;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.rmi.RemoteException;
import java.util.Vector;

public class AgentDiagnosable
implements Diagnosable {
    private String systemName;
    private String systemClassName;
    private String agent;
    private int port;
    public static final String sccs_id = "@(#)AgentDiagnosable.java\t1.3 10/10/02 SMI";

    public String getSystemClassName() {
        return this.systemClassName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public DiagnosticTestInfo[] getDiagnosticTests() throws RemoteException, DiagnosticException {
        Vector vector = new Vector();
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(this.getSystemObjectPath());
        referenceForMSE.setDeviceService(this);
        HTTPConnection hTTPConnection = new HTTPConnection(this.agent, this.port);
        DiagnosticListCommand diagnosticListCommand = new DiagnosticListCommand();
        String string = hTTPConnection.sendCommand(diagnosticListCommand);
        return new DiagnosticTestInfo[0];
    }

    public boolean validateTest(DiagnosticTestInfo diagnosticTestInfo) throws RemoteException, DiagnosticException {
        DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest();
        Vector vector = diagnosticSetting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            if (!((TestParameter)vector.get(n)).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public DiagnosticResult runTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResultListener diagnosticResultListener) throws RemoteException, DiagnosticException {
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        diagnosticResult.setDiagnosticName(diagnosticTestInfo.getTestClassName());
        diagnosticResult.setMse(new ReferenceForMSE(diagnosticTestInfo.getMSE()));
        diagnosticResult.setExecutionID(diagnosticTestInfo.getTestClassName() + ":" + DiagnosticMonitor.getExecID());
        diagnosticResult.setPercentComplete((short)0);
        HTTPConnection hTTPConnection = new HTTPConnection(this.agent, this.port);
        return diagnosticResult;
    }

    public DiagnosticResult getTestResults(ElementKey elementKey) throws RemoteException, DiagnosticException {
        if (elementKey == null) {
            throw new IllegalArgumentException();
        }
        DiagnosticResult diagnosticResult = DiagnosticMonitor.getResult(elementKey.toString());
        return (DiagnosticResult)diagnosticResult.clone();
    }

    public boolean abortTest(ElementKey elementKey) throws RemoteException, DiagnosticException {
        if (elementKey == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        diagnosticResult.setExecutionID(elementKey.toString());
        return DiagnosticMonitor.abortTest(diagnosticResult);
    }

    private CIMObjectPath getSystemObjectPath() {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.getSystemClassName());
        cIMObjectPath.addKey("Name", new CIMValue((Object)this.getSystemName()));
        return cIMObjectPath;
    }
}

