/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.device.protocol.agent.AgentEvent;
import com.sun.jade.device.protocol.agent.AgentEventDispatcher;
import com.sun.jade.device.protocol.agent.AgentEventListener;
import com.sun.jade.device.protocol.agent.AgentReport;
import com.sun.jade.device.protocol.agent.AgentReportListener;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.device.protocol.agent.SetProviderSettingsCommand;
import com.sun.jade.logic.service.StorAdeError;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class AgentEventDispatcherService
implements AgentEventDispatcher {
    private static AgentEventDispatcher service;
    private static String KEY;
    private static String USER;
    private static int RAS_PORT;
    private static int WEB_PORT;
    private static AgentReportListener HBA_FACTORY;
    private Collection reportList = new LinkedList();
    private Collection listeners = new LinkedList();
    private Map agents = new HashMap();
    private Properties properties;
    public static final String sccs_id = "@(#)AgentEventDispatcherService.java\t1.10 01/23/03 SMI";

    public synchronized void subscribeListener(String string, String string2, AgentEventListener agentEventListener) {
        Object object;
        if (null == this.agents.get(string) && (object = this.subscribeAgent(string)) != null) {
            this.agents.put(object, string);
        }
        object = new ListenerData(string, string2, agentEventListener);
        this.listeners.add(object);
    }

    public synchronized void unsubscribeListener(AgentEventListener agentEventListener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            if (agentEventListener != listenerData.listener) continue;
            this.listeners.remove(listenerData);
        }
    }

    public void dispatch(AgentEvent agentEvent) {
        String string = agentEvent.getSource();
        String string2 = agentEvent.getTarget();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            if (string2 == null || !string2.equals(listenerData.deviceKey)) continue;
            listenerData.listener.notify(agentEvent);
        }
    }

    public synchronized void subscribeListener(String string, AgentReportListener agentReportListener) {
        ReportListenerData reportListenerData = new ReportListenerData(string, agentReportListener);
        this.reportList.add(reportListenerData);
    }

    public synchronized void unsubscribeListener(AgentReportListener agentReportListener) {
        Iterator iterator = this.reportList.iterator();
        while (iterator.hasNext()) {
            ReportListenerData reportListenerData = (ReportListenerData)iterator.next();
            if (agentReportListener != reportListenerData.listener) continue;
            this.reportList.remove(reportListenerData);
        }
    }

    public void dispatch(AgentReport agentReport) {
        String string = agentReport.getProperty("info.hostid");
        Iterator iterator = this.reportList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ReportListenerData reportListenerData = (ReportListenerData)iterator.next();
            if (reportListenerData.agent == null) {
                reportListenerData.listener.notify(agentReport);
                continue;
            }
            if (!reportListenerData.agent.equals(string)) continue;
            reportListenerData.listener.notify(agentReport);
            bl = true;
        }
        if (!bl && HBA_FACTORY != null) {
            HBA_FACTORY.notify(agentReport);
        }
    }

    public static AgentEventDispatcher getService(Properties properties) {
        if (service == null) {
            service = new AgentEventDispatcherService(properties);
        }
        return service;
    }

    public String getInterfaceName() {
        return "AgentEventDispatcher";
    }

    public String getName() {
        return "StorADE Agent";
    }

    public boolean isStarted() {
        return true;
    }

    public String getStatus() {
        return "OK";
    }

    public void startService() throws StorAdeException {
        throw new StorAdeException(StorAdeError.NOT_IMPLEMENTED);
    }

    public void stopService() throws StorAdeException {
        throw new StorAdeException(StorAdeError.NOT_IMPLEMENTED);
    }

    private AgentEventDispatcherService(Properties properties) {
        this.properties = properties;
        String string = properties.getProperty("key");
        if (string != null) {
            KEY = string;
        }
        if ((string = properties.getProperty("ras_port")) != null) {
            RAS_PORT = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("web_port")) != null) {
            WEB_PORT = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("User-Agent")) != null) {
            USER = string;
        }
        if ((string = properties.getProperty("host.load.class")) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                HBA_FACTORY = (AgentReportListener)clazz.newInstance();
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"No agent factory");
            }
        }
    }

    private String subscribeAgent(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string2 = KEY;
        String string3 = inetAddress.getHostAddress() + ":" + WEB_PORT + "/agent/storade" + "?Auth=" + string2 + "?Agent=" + string;
        HTTPConnection hTTPConnection = new HTTPConnection(string, RAS_PORT);
        SetProviderSettingsCommand setProviderSettingsCommand = new SetProviderSettingsCommand("sae", true, string3, false, "tab");
        String string4 = hTTPConnection.sendCommand(setProviderSettingsCommand);
        return string2;
    }

    static {
        KEY = "StoradeAgent";
        USER = "storade_7654";
        RAS_PORT = 7654;
        WEB_PORT = 8088;
    }

    private class ReportListenerData {
        String agent;
        AgentReportListener listener;

        ReportListenerData(String string, AgentReportListener agentReportListener) {
            this.agent = string;
            this.listener = agentReportListener;
        }
    }

    private class ListenerData {
        String agent;
        String deviceKey;
        AgentEventListener listener;

        ListenerData(String string, String string2, AgentEventListener agentEventListener) {
            if (string == null || string2 == null || agentEventListener == null) {
                throw new IllegalArgumentException();
            }
            this.agent = string;
            this.deviceKey = string2;
            this.listener = agentEventListener;
        }

        public boolean equals(Object object) {
            ListenerData listenerData = (ListenerData)object;
            return this.agent.equals(listenerData.agent) && this.deviceKey.equals(listenerData.deviceKey);
        }
    }
}

